/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.fiducial;

import boofcv.abst.fiducial.MicroQrCodeDetector;
import boofcv.abst.filter.binary.BinaryContourHelper;
import boofcv.abst.filter.binary.BinaryContourInterface;
import boofcv.abst.filter.binary.InputToBinary;
import boofcv.alg.distort.LensDistortionNarrowFOV;
import boofcv.alg.fiducial.microqr.MicroQrCode;
import boofcv.alg.fiducial.microqr.MicroQrCodeDecoderImage;
import boofcv.alg.fiducial.qrcode.QrCodePositionPatternDetector;
import boofcv.alg.shapes.polygon.DetectPolygonBinaryGrayRefine;
import boofcv.alg.shapes.polygon.DetectPolygonFromContour;
import boofcv.misc.MovingAverage;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageGray;
import java.io.PrintStream;
import java.util.List;
import java.util.Set;
import org.ddogleg.struct.VerbosePrint;
import org.ddogleg.util.VerboseUtils;
import org.jetbrains.annotations.Nullable;

public class MicroQrCodePreciseDetector<T extends ImageGray<T>>
implements MicroQrCodeDetector<T>,
VerbosePrint {
    QrCodePositionPatternDetector<T> detectPositionPatterns;
    MicroQrCodeDecoderImage<T> decoder;
    InputToBinary<T> inputToBinary;
    Class<T> imageType;
    BinaryContourHelper contourHelper;
    @Nullable
    PrintStream profiler = null;
    protected MovingAverage milliBinary = new MovingAverage(0.8);
    protected MovingAverage milliDecoding = new MovingAverage(0.8);

    public MicroQrCodePreciseDetector(InputToBinary<T> inputToBinary, QrCodePositionPatternDetector<T> detectPositionPatterns, @Nullable String forceEncoding, String defaultEncoding, boolean copyBinary, Class<T> imageType) {
        this.inputToBinary = inputToBinary;
        this.detectPositionPatterns = detectPositionPatterns;
        this.decoder = new MicroQrCodeDecoderImage<T>(forceEncoding, defaultEncoding, imageType);
        this.imageType = imageType;
        this.contourHelper = new BinaryContourHelper((BinaryContourInterface)detectPositionPatterns.getSquareDetector().getDetector().getContourFinder(), copyBinary);
        detectPositionPatterns.setMaxContourFraction(4.0);
    }

    @Override
    public void process(T gray) {
        long time0 = System.nanoTime();
        this.contourHelper.reshape(((ImageGray)gray).width, ((ImageGray)gray).height);
        this.inputToBinary.process(gray, this.contourHelper.withoutPadding());
        long time1 = System.nanoTime();
        this.milliBinary.update((double)(time1 - time0) * 1.0E-6);
        this.detectPositionPatterns.process(gray, this.contourHelper.padded());
        List positionPatterns = this.detectPositionPatterns.getPositionPatterns().toList();
        time0 = System.nanoTime();
        this.decoder.process(positionPatterns, gray);
        time1 = System.nanoTime();
        this.milliDecoding.update((double)(time1 - time0) * 1.0E-6);
        if (this.profiler != null) {
            DetectPolygonFromContour detectorPoly = this.detectPositionPatterns.getSquareDetector().getDetector();
            this.profiler.printf("qrcode: binary %5.2f contour %5.1f shapes %5.1f adjust_bias %5.2f PosPat %6.2f decoding %5.1f\n", this.milliBinary.getAverage(), detectorPoly.getMilliContour(), detectorPoly.getMilliShapes(), this.detectPositionPatterns.getSquareDetector().getMilliAdjustBias(), this.detectPositionPatterns.getProfilingMS().getAverage(), this.milliDecoding.getAverage());
        }
    }

    @Override
    public List<MicroQrCode> getDetections() {
        return this.decoder.getFound();
    }

    @Override
    public List<MicroQrCode> getFailures() {
        return this.decoder.getFailures();
    }

    public void setLensDistortion(int width, int height, @Nullable LensDistortionNarrowFOV model) {
        this.detectPositionPatterns.setLensDistortion(width, height, model);
        this.decoder.setLensDistortion(width, height, model);
    }

    public GrayU8 getBinary() {
        return this.contourHelper.withoutPadding();
    }

    public void resetRuntimeProfiling() {
        this.milliBinary.reset();
        this.milliDecoding.reset();
        this.detectPositionPatterns.resetRuntimeProfiling();
    }

    public DetectPolygonBinaryGrayRefine<T> getSquareDetector() {
        return this.detectPositionPatterns.getSquareDetector();
    }

    @Override
    public Class<T> getImageType() {
        return this.imageType;
    }

    public void setVerbose(@Nullable PrintStream out, @Nullable Set<String> configuration) {
        VerboseUtils.verboseChildren((PrintStream)out, configuration, (VerbosePrint[])new VerbosePrint[]{this.decoder, this.detectPositionPatterns});
        if (configuration == null) {
            return;
        }
        if (configuration.contains("runtime")) {
            this.profiler = VerboseUtils.addPrefix((VerbosePrint)this, (PrintStream)out);
        }
    }

    public QrCodePositionPatternDetector<T> getDetectPositionPatterns() {
        return this.detectPositionPatterns;
    }

    public MicroQrCodeDecoderImage<T> getDecoder() {
        return this.decoder;
    }
}

