/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.fiducial.aztec;

import boofcv.alg.fiducial.aztec.AztecCode;
import boofcv.alg.fiducial.aztec.AztecMessageErrorCorrection;
import boofcv.alg.fiducial.qrcode.PackedBits8;
import boofcv.misc.BoofMiscOps;
import java.io.PrintStream;
import java.util.Objects;
import java.util.Set;
import org.ddogleg.struct.VerbosePrint;
import org.ddogleg.util.VerboseUtils;
import org.jetbrains.annotations.Nullable;

public class AztecDecoder
extends AztecMessageErrorCorrection
implements VerbosePrint {
    AztecCode.Mode current = AztecCode.Mode.UPPER;
    @Nullable
    AztecCode.Mode shiftMode = null;
    boolean latched;
    StringBuilder workString = new StringBuilder();
    @Nullable
    PrintStream verbose = null;
    boolean failedECC;

    public boolean process(AztecCode marker) {
        BoofMiscOps.checkTrue((marker.dataLayers >= 1 ? 1 : 0) != 0);
        Objects.requireNonNull(marker.rawbits);
        this.failedECC = false;
        if (!this.applyErrorCorrection(marker)) {
            this.failedECC = true;
            if (this.verbose != null) {
                this.verbose.println("ECC failed");
            }
            return false;
        }
        PackedBits8 paddedBits = PackedBits8.wrap(marker.corrected, marker.messageWordCount * marker.getWordBitCount());
        PackedBits8 bits = new PackedBits8();
        if (!this.removeExtraBits(marker.getWordBitCount(), marker.messageWordCount, paddedBits, bits)) {
            return false;
        }
        return this.bitsToMessage(marker, bits);
    }

    boolean removeExtraBits(int wordBitCount, int messageWordCount, PackedBits8 bitsExtras, PackedBits8 bits) {
        BoofMiscOps.checkTrue((bitsExtras.size % wordBitCount == 0 ? 1 : 0) != 0);
        int numWords = bitsExtras.size / wordBitCount;
        int ones = (1 << wordBitCount) - 1;
        int onesMinusOne = (1 << wordBitCount) - 2;
        for (int i = 0; i < numWords; ++i) {
            int value = bitsExtras.read(i * wordBitCount, wordBitCount, true);
            if (value == 1 || value == onesMinusOne) {
                bits.append(value >> 1, wordBitCount - 1, false);
                continue;
            }
            if (i < messageWordCount && (value == 0 || value == ones)) {
                if (this.verbose != null) {
                    this.verbose.println("invalid message word. All zeros or ones");
                }
                return false;
            }
            bits.append(value, wordBitCount, false);
        }
        return true;
    }

    boolean bitsToMessage(AztecCode marker, PackedBits8 bits) {
        this.latched = false;
        this.shiftMode = null;
        this.workString.delete(0, this.workString.length());
        this.current = AztecCode.Mode.UPPER;
        int location = 0;
        while (location + this.current.wordSize <= bits.size) {
            boolean success;
            if (this.current == AztecCode.Mode.BYTE) {
                int length = bits.read(location, 5, true);
                location += 5;
                if (length == 0) {
                    length = bits.read(location, 11, true) + 31;
                    location += 11;
                }
                if (this.verbose != null) {
                    this.verbose.println("current=" + this.current + " length=" + length);
                }
                for (int i = 0; i < length; ++i) {
                    this.workString.append((char)bits.read(location, 8, true));
                    location += 8;
                }
                this.current = Objects.requireNonNull(this.shiftMode);
                this.shiftMode = null;
                continue;
            }
            int value = bits.read(location, this.current.wordSize, true);
            if (this.verbose != null) {
                this.verbose.println("current=" + this.current + " latched=" + this.latched + " value=" + value);
            }
            location += this.current.wordSize;
            this.latched = true;
            AztecCode.Mode previous = this.current;
            switch (this.current) {
                case UPPER: {
                    boolean bl = this.handleUpper(value);
                    break;
                }
                case LOWER: {
                    boolean bl = this.handleLower(value);
                    break;
                }
                case MIXED: {
                    boolean bl = this.handleMixed(value);
                    break;
                }
                case PUNCT: {
                    boolean bl = this.handlePunct(value);
                    break;
                }
                case DIGIT: {
                    boolean bl = this.handleDigit(value);
                    break;
                }
                default: {
                    if (this.verbose != null) {
                        this.verbose.println("Unhandled mode: " + this.current);
                    }
                    boolean bl = success = false;
                }
            }
            if (!success) {
                return false;
            }
            if (this.shiftMode != null) {
                this.current = this.shiftMode;
            }
            this.shiftMode = this.latched ? null : previous;
        }
        marker.message = this.workString.toString();
        return true;
    }

    boolean handleUpper(int value) {
        if (value == 0) {
            this.current = AztecCode.Mode.PUNCT;
            this.latched = false;
        } else if (value == 1) {
            this.workString.append(' ');
        } else if (value <= 27) {
            this.workString.append((char)(65 + (value - 2)));
        } else {
            switch (value) {
                case 28: {
                    this.current = AztecCode.Mode.LOWER;
                    break;
                }
                case 29: {
                    this.current = AztecCode.Mode.MIXED;
                    break;
                }
                case 30: {
                    this.current = AztecCode.Mode.DIGIT;
                    break;
                }
                case 31: {
                    this.current = AztecCode.Mode.BYTE;
                    this.latched = false;
                }
            }
        }
        return true;
    }

    boolean handleLower(int value) {
        if (value == 0) {
            this.current = AztecCode.Mode.PUNCT;
            this.latched = false;
        } else if (value == 1) {
            this.workString.append(' ');
        } else if (value <= 27) {
            this.workString.append((char)(97 + (value - 2)));
        } else {
            switch (value) {
                case 28: {
                    this.current = AztecCode.Mode.UPPER;
                    this.latched = false;
                    break;
                }
                case 29: {
                    this.current = AztecCode.Mode.MIXED;
                    break;
                }
                case 30: {
                    this.current = AztecCode.Mode.DIGIT;
                    break;
                }
                case 31: {
                    this.current = AztecCode.Mode.BYTE;
                    this.latched = false;
                }
            }
        }
        return true;
    }

    boolean handleMixed(int value) {
        if (value == 0) {
            this.current = AztecCode.Mode.PUNCT;
            this.latched = false;
        } else if (value == 1) {
            this.workString.append(' ');
        } else if (value <= 14) {
            this.workString.append((char)(value - 1));
        } else if (value <= 19) {
            this.workString.append((char)(value - 19 + 27));
        } else if (value == 20) {
            this.workString.append('@');
        } else if (value == 21) {
            this.workString.append('\\');
        } else if (value <= 24) {
            this.workString.append((char)(value - 22 + 94));
        } else {
            switch (value) {
                case 25: {
                    this.workString.append('|');
                    break;
                }
                case 26: {
                    this.workString.append('~');
                    break;
                }
                case 27: {
                    this.workString.append('\u007f');
                    break;
                }
                case 28: {
                    this.current = AztecCode.Mode.LOWER;
                    break;
                }
                case 29: {
                    this.current = AztecCode.Mode.UPPER;
                    break;
                }
                case 30: {
                    this.current = AztecCode.Mode.PUNCT;
                    break;
                }
                case 31: {
                    this.current = AztecCode.Mode.BYTE;
                    this.latched = false;
                }
            }
        }
        return true;
    }

    boolean handlePunct(int value) {
        if (value == 0) {
            if (this.verbose != null) {
                this.verbose.println("FlG(n) encountered");
            }
            return false;
        }
        switch (value) {
            case 1: {
                this.workString.append('\r');
                break;
            }
            case 2: {
                this.workString.append("\r\n");
                break;
            }
            case 3: {
                this.workString.append(". ");
                break;
            }
            case 4: {
                this.workString.append(", ");
                break;
            }
            case 5: {
                this.workString.append(": ");
                break;
            }
            case 27: {
                this.workString.append('[');
                break;
            }
            case 28: {
                this.workString.append(']');
                break;
            }
            case 29: {
                this.workString.append('{');
                break;
            }
            case 30: {
                this.workString.append('}');
                break;
            }
            case 31: {
                this.current = AztecCode.Mode.UPPER;
                break;
            }
            default: {
                if (value <= 20) {
                    this.workString.append((char)(value - 6 + 33));
                    break;
                }
                if (value > 26) break;
                this.workString.append((char)(value - 21 + 58));
            }
        }
        return true;
    }

    boolean handleDigit(int value) {
        if (value == 0) {
            this.current = AztecCode.Mode.PUNCT;
            this.latched = false;
        } else if (value == 1) {
            this.workString.append(' ');
        } else if (value <= 11) {
            this.workString.append((char)(value - 2 + 48));
        } else {
            switch (value) {
                case 12: {
                    this.workString.append(',');
                    break;
                }
                case 13: {
                    this.workString.append('.');
                    break;
                }
                case 14: {
                    this.current = AztecCode.Mode.UPPER;
                    break;
                }
                case 15: {
                    this.current = AztecCode.Mode.UPPER;
                    this.latched = false;
                }
            }
        }
        return true;
    }

    boolean handleByte(int value) {
        this.workString.append((char)value);
        return true;
    }

    public void setVerbose(@Nullable PrintStream out, @Nullable Set<String> set) {
        this.verbose = VerboseUtils.addPrefix((VerbosePrint)this, (PrintStream)out);
    }

    public boolean isFailedECC() {
        return this.failedECC;
    }
}

