/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.fiducial.aztec;

import boofcv.alg.fiducial.aztec.AztecCode;
import boofcv.alg.fiducial.aztec.AztecEncoder;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.util.Set;
import org.ddogleg.struct.DogArray;
import org.ddogleg.struct.VerbosePrint;
import org.ddogleg.util.VerboseUtils;
import org.jetbrains.annotations.Nullable;

public class AztecEncoderAutomatic
implements VerbosePrint {
    public static final AztecCode.Mode[] modes = new AztecCode.Mode[]{AztecCode.Mode.UPPER, AztecCode.Mode.LOWER, AztecCode.Mode.MIXED, AztecCode.Mode.PUNCT, AztecCode.Mode.DIGIT, AztecCode.Mode.BYTE};
    final DogArray<State> states = new DogArray(State::new, State::reset);
    static final int E = 0xFFFFFFF;
    static final int[][] latlen = new int[][]{{0, 5, 5, 10, 5, 10}, {10, 0, 5, 10, 5, 10}, {5, 5, 0, 5, 10, 10}, {5, 10, 10, 0, 10, 15}, {4, 9, 9, 14, 0, 14}, {0, 0, 0, 0, 0, 0}};
    static final int[][] shiftlen = new int[][]{{0xFFFFFFF, 0xFFFFFFF, 0xFFFFFFF, 5, 0xFFFFFFF}, {5, 0xFFFFFFF, 0xFFFFFFF, 5, 0xFFFFFFF}, {0xFFFFFFF, 0xFFFFFFF, 0xFFFFFFF, 5, 0xFFFFFFF}, {0xFFFFFFF, 0xFFFFFFF, 0xFFFFFFF, 0xFFFFFFF, 0xFFFFFFF}, {4, 0xFFFFFFF, 0xFFFFFFF, 4, 0xFFFFFFF}};
    @Nullable
    PrintStream verbose = null;

    public void process(String message, AztecEncoder encoder) {
        byte[] characters = message.getBytes(StandardCharsets.ISO_8859_1);
        this.initialize();
        this.encodeCharacters(characters);
        this.encodeMessageGivenSequence(this.selectBestState(), message, encoder);
    }

    void initialize() {
        this.states.reset().resize(latlen.length);
        State s = (State)this.states.get(AztecCode.Mode.UPPER.ordinal());
        s.curLen = 0;
        s.characterCount = 0;
        ((Group)s.sequence.grow()).setTo(AztecCode.Mode.UPPER, 0);
    }

    void encodeCharacters(byte[] characters) {
        for (int charIdx = 0; charIdx < characters.length; ++charIdx) {
            int prev;
            int curr = characters[charIdx] & 0xFF;
            if (this.verbose != null) {
                this.verbose.println("charIdx=" + charIdx + " value=" + curr + " char='" + (char)characters[charIdx] + "'");
            }
            this.latchToReduceMessageSize(charIdx);
            this.states.forEach(m -> {
                m.nxtLen = 0;
            });
            this.addCharacterToStates(curr);
            this.considerShiftingInstead(charIdx, curr);
            int n = prev = charIdx > 0 ? characters[charIdx - 1] & 0xFF : 0;
            if (this.isTwoCharacterSequence(prev, curr)) {
                State state = (State)this.states.get(AztecCode.Mode.PUNCT.ordinal());
                ++state.characterCount;
                ++((Group)state.sequence.getTail()).count;
            }
            if (((Group)((State)this.states.get((int)AztecCode.Mode.BYTE.ordinal())).sequence.getTail()).count == 32) {
                ((State)this.states.get((int)AztecCode.Mode.BYTE.ordinal())).nxtLen += 11;
            }
            this.states.forEach(m -> {
                m.curLen = m.nxtLen;
            });
        }
    }

    private void latchToReduceMessageSize(int charIdx) {
        for (int modeIdxA = 0; modeIdxA < this.states.size; ++modeIdxA) {
            State stateA = (State)this.states.get(modeIdxA);
            if (stateA.characterCount != charIdx) continue;
            for (int modeIdxB = 0; modeIdxB < this.states.size; ++modeIdxB) {
                if (modeIdxA == modeIdxB) continue;
                boolean byteTransition = modes[modeIdxA] == AztecCode.Mode.BYTE && modes[modeIdxB] != stateA.backTo;
                int lengthIfTransition = stateA.curLen + latlen[modeIdxA][modeIdxB];
                if (byteTransition) {
                    lengthIfTransition += latlen[stateA.backTo.ordinal()][modeIdxB];
                }
                State stateB = (State)this.states.get(modeIdxB);
                if (lengthIfTransition >= stateB.curLen && stateB.characterCount == charIdx) continue;
                if (this.verbose != null) {
                    this.verbose.println("latching " + modes[modeIdxA] + "->" + modes[modeIdxB]);
                }
                stateB.curLen = lengthIfTransition;
                stateB.characterCount = stateA.characterCount;
                stateB.sequence.reset();
                stateB.sequence.copyAll(stateA.sequence.toList(), (src, dst) -> dst.setTo((Group)src));
                stateB.backTo = modes[modeIdxA];
                if (byteTransition) {
                    ((Group)stateB.sequence.grow()).setTo(modes[modeIdxA], 0);
                }
                ((Group)stateB.sequence.grow()).setTo(modes[modeIdxB], 0);
            }
        }
    }

    private void addCharacterToStates(int curr) {
        for (int modeIdx = 0; modeIdx < modes.length; ++modeIdx) {
            State state = (State)this.states.get(modeIdx);
            if (!this.isMember(modeIdx, curr)) {
                state.nxtLen = state.curLen;
                continue;
            }
            int length = state.curLen + AztecEncoderAutomatic.modes[modeIdx].wordSize;
            if (state.nxtLen != 0 && state.nxtLen <= length) continue;
            state.nxtLen = length;
            ++state.characterCount;
            ++((Group)state.sequence.getTail()).count;
            if (this.verbose == null) continue;
            this.verbose.printf("add %5s length=%d\n", new Object[]{modes[modeIdx], length});
        }
    }

    private void considerShiftingInstead(int charIdx, int curr) {
        for (int modeIdxA = 0; modeIdxA < modes.length - 1; ++modeIdxA) {
            if (!this.isMember(modeIdxA, curr)) continue;
            for (int modeIdxB = 0; modeIdxB < modes.length - 1; ++modeIdxB) {
                if (this.isMember(modeIdxB, curr) || shiftlen[modeIdxB][modeIdxA] == 0xFFFFFFF) continue;
                State stateB = (State)this.states.get(modeIdxB);
                int shiftLength = stateB.curLen + shiftlen[modeIdxB][modeIdxA] + AztecEncoderAutomatic.modes[modeIdxA].wordSize;
                if (stateB.characterCount == charIdx + 1 && shiftLength >= stateB.nxtLen) continue;
                stateB.nxtLen = shiftLength;
                ++stateB.characterCount;
                ((Group)stateB.sequence.grow()).setTo(modes[modeIdxA], 1);
                ((Group)stateB.sequence.grow()).setTo(modes[modeIdxB], 0);
            }
        }
    }

    private boolean isTwoCharacterSequence(int a, int b) {
        if (a == 13 && b == 10) {
            return true;
        }
        if (b == 32) {
            if (a == 46) {
                return true;
            }
            if (a == 44) {
                return true;
            }
            if (a == 58) {
                return true;
            }
        }
        return false;
    }

    private void encodeMessageGivenSequence(State state, String message, AztecEncoder encoder) {
        int char0 = 0;
        for (int i = 0; i < state.sequence.size; ++i) {
            Group g = (Group)state.sequence.get(i);
            int char1 = char0 + g.count;
            switch (g.mode) {
                case UPPER: {
                    encoder.addUpper(message.substring(char0, char1));
                    break;
                }
                case LOWER: {
                    encoder.addLower(message.substring(char0, char1));
                    break;
                }
                case MIXED: {
                    encoder.addMixed(message.substring(char0, char1));
                    break;
                }
                case PUNCT: {
                    encoder.addPunctuation(message.substring(char0, char1));
                    break;
                }
                case DIGIT: {
                    encoder.addDigit(message.substring(char0, char1));
                    break;
                }
                case BYTE: {
                    byte[] data = message.substring(char0, char1).getBytes(StandardCharsets.ISO_8859_1);
                    encoder.addBytes(data, 0, data.length);
                    break;
                }
                default: {
                    throw new RuntimeException("Invalid");
                }
            }
            char0 = char1;
        }
    }

    State selectBestState() {
        State state = (State)this.states.get(0);
        for (int i = 1; i < this.states.size; ++i) {
            State candidate = (State)this.states.get(i);
            if (candidate.characterCount > state.characterCount) {
                state = (State)this.states.get(i);
                continue;
            }
            if (candidate.characterCount != state.characterCount || ((State)this.states.get((int)i)).curLen >= state.curLen) continue;
            state = (State)this.states.get(i);
        }
        return state;
    }

    boolean isMember(int mode, int curr) {
        boolean bl;
        switch (modes[mode]) {
            case UPPER: {
                bl = this.isUpper(curr);
                break;
            }
            case LOWER: {
                bl = this.isLower(curr);
                break;
            }
            case MIXED: {
                bl = this.isMixed(curr);
                break;
            }
            case PUNCT: {
                bl = this.isPunctuation(curr);
                break;
            }
            case DIGIT: {
                bl = this.isDigit(curr);
                break;
            }
            case BYTE: {
                bl = true;
                break;
            }
            default: {
                throw new RuntimeException("Invalid");
            }
        }
        return bl;
    }

    boolean isUpper(int c) {
        if (c == 32) {
            return true;
        }
        return c >= 65 && c <= 90;
    }

    boolean isLower(int c) {
        if (c == 32) {
            return true;
        }
        return c >= 97 && c <= 122;
    }

    boolean isMixed(int c) {
        if (c >= 1 && c <= 13) {
            return true;
        }
        if (c >= 27 && c <= 32) {
            return true;
        }
        if (c == 64) {
            return true;
        }
        if (c == 92) {
            return true;
        }
        if (c == 94) {
            return true;
        }
        if (c == 95) {
            return true;
        }
        if (c == 96) {
            return true;
        }
        if (c == 124) {
            return true;
        }
        if (c == 126) {
            return true;
        }
        return c == 127;
    }

    public boolean isPunctuation(int c) {
        if (c == 13) {
            return true;
        }
        if (c >= 33 && c <= 47) {
            return true;
        }
        if (c >= 58 && c <= 63) {
            return true;
        }
        if (c == 91) {
            return true;
        }
        if (c == 93) {
            return true;
        }
        if (c == 123) {
            return true;
        }
        return c == 125;
    }

    boolean isDigit(int c) {
        if (c == 32) {
            return true;
        }
        if (c >= 48 && c <= 57) {
            return true;
        }
        if (c == 44) {
            return true;
        }
        return c == 46;
    }

    public void setVerbose(@Nullable PrintStream out, @Nullable Set<String> configuration) {
        this.verbose = VerboseUtils.addPrefix((VerbosePrint)this, (PrintStream)out);
    }

    static class State {
        int curLen = Integer.MAX_VALUE;
        int nxtLen = -1;
        int characterCount = -1;
        DogArray<Group> sequence = new DogArray(Group::new, Group::reset);
        AztecCode.Mode backTo = AztecCode.Mode.UPPER;

        State() {
        }

        public void reset() {
            this.curLen = Integer.MAX_VALUE;
            this.nxtLen = -1;
            this.characterCount = -1;
            this.sequence.reset();
            this.backTo = AztecCode.Mode.UPPER;
        }
    }

    static class Group {
        AztecCode.Mode mode = AztecCode.Mode.UPPER;
        int count;

        Group() {
        }

        public void reset() {
            this.mode = AztecCode.Mode.UPPER;
            this.count = 0;
        }

        public void setTo(AztecCode.Mode mode, int count) {
            this.mode = mode;
            this.count = count;
        }

        public void setTo(Group g) {
            this.mode = g.mode;
            this.count = g.count;
        }
    }
}

