/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.fiducial.calib.chess;

import boofcv.alg.feature.detect.chess.ChessboardCorner;
import boofcv.core.graph.FeatureGraph2D;
import java.util.List;
import org.ddogleg.struct.DogArray;
import org.jetbrains.annotations.Nullable;

public class ChessboardCornerGraph {
    public DogArray<Node> corners = new DogArray(Node::new);

    public void convert(FeatureGraph2D graph) {
        Node c;
        int i;
        graph.nodes.resize(this.corners.size);
        graph.reset();
        for (i = 0; i < this.corners.size; ++i) {
            c = (Node)this.corners.get(i);
            FeatureGraph2D.Node n = (FeatureGraph2D.Node)graph.nodes.grow();
            n.reset();
            n.setTo(c.corner.x, c.corner.y);
            n.index = c.index;
        }
        for (i = 0; i < this.corners.size; ++i) {
            c = (Node)this.corners.get(i);
            for (int j = 0; j < 4; ++j) {
                if (c.edges[j] == null) continue;
                graph.connect(c.index, c.edges[j].index);
            }
        }
    }

    public Node growCorner() {
        Node n = (Node)this.corners.grow();
        n.reset();
        n.index = this.corners.size - 1;
        return n;
    }

    @Nullable
    public Node findClosest(double x, double y) {
        double distance = Double.MAX_VALUE;
        Node closest = null;
        for (int i = 0; i < this.corners.size; ++i) {
            Node n = (Node)this.corners.get(i);
            double d = n.corner.distance2(x, y);
            if (!(d < distance)) continue;
            distance = d;
            closest = n;
        }
        return closest;
    }

    public void print() {
        for (int cornerIdx = 0; cornerIdx < this.corners.size; ++cornerIdx) {
            Node n = (Node)this.corners.get(cornerIdx);
            System.out.printf("[%3d] {%3.0f, %3.0f} -> ", n.index, n.corner.x, n.corner.y);
            for (int i = 0; i < 4; ++i) {
                if (n.edges[i] == null) {
                    System.out.print("[    ] ");
                    continue;
                }
                System.out.printf("[ %2d ] ", n.edges[i].index);
            }
            System.out.println();
        }
    }

    public void reset() {
        this.corners.reset();
    }

    public static class Node {
        public int index;
        public ChessboardCorner corner;
        public final Node[] edges = new Node[4];

        public double getX() {
            return this.corner.x;
        }

        public double getY() {
            return this.corner.y;
        }

        public double getOrientation() {
            return this.corner.orientation;
        }

        public void putEdgesIntoList(List<Node> found) {
            found.clear();
            for (int i = 0; i < 4; ++i) {
                if (this.edges[i] == null) continue;
                found.add(this.edges[i]);
            }
        }

        public void rotateEdgesDown() {
            Node tmp = this.edges[0];
            for (int i = 1; i < 4; ++i) {
                this.edges[i - 1] = this.edges[i];
            }
            this.edges[3] = tmp;
        }

        public void reset() {
            this.index = -1;
            this.corner = null;
            for (int i = 0; i < 4; ++i) {
                this.edges[i] = null;
            }
        }

        public int countEdges() {
            int total = 0;
            for (int i = 0; i < 4; ++i) {
                if (this.edges[i] == null) continue;
                ++total;
            }
            return total;
        }
    }
}

