/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.fiducial.dots;

import boofcv.abst.filter.binary.InputToBinary;
import boofcv.alg.distort.LensDistortionNarrowFOV;
import boofcv.alg.fiducial.dots.UchiyaMarkerTracker;
import boofcv.alg.shapes.ellipse.BinaryEllipseDetectorPixel;
import boofcv.alg.shapes.ellipse.EdgeIntensityEllipse;
import boofcv.struct.distort.PixelTransform;
import boofcv.struct.distort.Point2Transform2_F32;
import boofcv.struct.distort.PointToPixelTransform_F32;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageGray;
import georegression.struct.point.Point2D_F64;
import java.util.ArrayList;
import java.util.List;
import org.ddogleg.struct.DogArray;

public class UchiyaMarkerImageTracker<T extends ImageGray<T>> {
    GrayU8 binary = new GrayU8(1, 1);
    InputToBinary<T> inputToBinary;
    BinaryEllipseDetectorPixel ellipseDetector;
    EdgeIntensityEllipse<T> intensityCheck;
    UchiyaMarkerTracker tracker;
    List<Point2D_F64> foundDots = new ArrayList<Point2D_F64>();
    double timeBinary;
    double timeEllipse;
    double timeReject;

    public UchiyaMarkerImageTracker(InputToBinary<T> inputToBinary, BinaryEllipseDetectorPixel ellipseDetector, EdgeIntensityEllipse<T> intensityCheck, UchiyaMarkerTracker tracker) {
        this.inputToBinary = inputToBinary;
        this.ellipseDetector = ellipseDetector;
        this.intensityCheck = intensityCheck;
        this.tracker = tracker;
        ellipseDetector.setInternalContour(false);
    }

    public void detect(T input) {
        long nano0 = System.nanoTime();
        this.inputToBinary.process(input, this.binary);
        long nano1 = System.nanoTime();
        this.ellipseDetector.process(this.binary);
        long nano2 = System.nanoTime();
        this.intensityCheck.setImage(input);
        List foundRaw = this.ellipseDetector.getFound();
        this.foundDots.clear();
        for (int i = 0; i < foundRaw.size(); ++i) {
            BinaryEllipseDetectorPixel.Found f = (BinaryEllipseDetectorPixel.Found)foundRaw.get(i);
            if (!this.intensityCheck.process(f.ellipse)) {
                f.ellipse.b = 0.0;
                f.ellipse.a = 0.0;
                continue;
            }
            this.foundDots.add(f.ellipse.center);
        }
        long nano3 = System.nanoTime();
        this.timeBinary = (double)(nano1 - nano0) * 1.0E-6;
        this.timeEllipse = (double)(nano2 - nano1) * 1.0E-6;
        this.timeReject = (double)(nano3 - nano2) * 1.0E-6;
        this.tracker.process(this.foundDots);
    }

    public void setLensDistortion(LensDistortionNarrowFOV distortion, int width, int height) {
        if (distortion == null) {
            this.ellipseDetector.setLensDistortion(null);
            this.intensityCheck.setTransform(null);
        } else {
            Point2Transform2_F32 pointDistToUndist = distortion.undistort_F32(true, true);
            Point2Transform2_F32 point_undist_to_dist = distortion.distort_F32(true, true);
            PointToPixelTransform_F32 distToUndist = new PointToPixelTransform_F32(pointDistToUndist);
            PointToPixelTransform_F32 undist_to_dist = new PointToPixelTransform_F32(point_undist_to_dist);
            this.ellipseDetector.setLensDistortion((PixelTransform)distToUndist);
            this.intensityCheck.setTransform((PixelTransform)undist_to_dist);
        }
    }

    public void reset() {
        this.tracker.resetTracking();
    }

    public DogArray<UchiyaMarkerTracker.Track> getTracks() {
        return this.tracker.getCurrentTracks();
    }

    public GrayU8 getBinary() {
        return this.binary;
    }

    public InputToBinary<T> getInputToBinary() {
        return this.inputToBinary;
    }

    public BinaryEllipseDetectorPixel getEllipseDetector() {
        return this.ellipseDetector;
    }

    public EdgeIntensityEllipse<T> getIntensityCheck() {
        return this.intensityCheck;
    }

    public UchiyaMarkerTracker getTracker() {
        return this.tracker;
    }

    public List<Point2D_F64> getFoundDots() {
        return this.foundDots;
    }

    public double getTimeBinary() {
        return this.timeBinary;
    }

    public double getTimeEllipse() {
        return this.timeEllipse;
    }

    public double getTimeReject() {
        return this.timeReject;
    }
}

