/*
 * Decompiled with CFR 0.152.
 */
package boofcv.factory.fiducial;

import boofcv.abst.shapes.polyline.ConfigPolylineSplitMerge;
import boofcv.factory.filter.binary.ConfigThreshold;
import boofcv.factory.filter.binary.ConfigThresholdLocalOtsu;
import boofcv.factory.filter.binary.ThresholdType;
import boofcv.factory.shape.ConfigPolygonDetector;
import boofcv.struct.ConfigLength;
import boofcv.struct.Configuration;
import boofcv.struct.ConnectRule;
import org.jetbrains.annotations.Nullable;

public class ConfigQrCode
implements Configuration {
    public ConfigThreshold threshold;
    public ConfigPolygonDetector polygon = new ConfigPolygonDetector();
    public int versionMinimum = 1;
    public int versionMaximum = 40;
    @Nullable
    public String forceEncoding = null;
    public String defaultEncoding = "ISO8859_1";
    public boolean considerTransposed = true;
    public boolean ignorePaddingBytes = true;

    public ConfigQrCode() {
        ConfigThresholdLocalOtsu configThreshold = (ConfigThresholdLocalOtsu)ConfigThreshold.local((ThresholdType)ThresholdType.BLOCK_OTSU, (int)40);
        configThreshold.useOtsu2 = true;
        configThreshold.scale = 1.0;
        configThreshold.thresholdFromLocalBlocks = true;
        configThreshold.tuning = 4.0;
        this.threshold = configThreshold;
        this.polygon.detector.contourRule = ConnectRule.EIGHT;
        this.polygon.detector.clockwise = false;
        ((ConfigPolylineSplitMerge)this.polygon.detector.contourToPoly).maxSideError = ConfigLength.relative((double)0.12, (double)3.0);
        ((ConfigPolylineSplitMerge)this.polygon.detector.contourToPoly).cornerScorePenalty = 0.4;
        ((ConfigPolylineSplitMerge)this.polygon.detector.contourToPoly).minimumSideLength = 2;
        this.polygon.detector.minimumContour = ConfigLength.fixed((double)40.0);
        this.polygon.detector.minimumEdgeIntensity = 3.0;
        this.polygon.minimumRefineEdgeIntensity = 6.0;
        this.polygon.detector.tangentEdgeIntensity = 1.5;
    }

    public static ConfigQrCode fast() {
        ConfigQrCode config = new ConfigQrCode();
        config.threshold = ConfigThreshold.global((ThresholdType)ThresholdType.GLOBAL_OTSU);
        return config;
    }

    public ConfigQrCode setTo(ConfigQrCode src) {
        this.threshold.setTo(src.threshold);
        this.polygon.setTo(src.polygon);
        this.versionMinimum = src.versionMinimum;
        this.versionMaximum = src.versionMaximum;
        this.forceEncoding = src.forceEncoding;
        this.defaultEncoding = src.defaultEncoding;
        this.considerTransposed = src.considerTransposed;
        this.ignorePaddingBytes = src.ignorePaddingBytes;
        return this;
    }

    public void checkValidity() {
        this.threshold.checkValidity();
        this.polygon.checkValidity();
    }
}

