/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.similar;

import boofcv.abst.scene.nister2006.ConfigRecognitionNister2006;
import boofcv.factory.feature.associate.ConfigAssociate;
import boofcv.factory.feature.describe.ConfigConvertTupleDesc;
import boofcv.factory.feature.describe.ConfigDescribeRegion;
import boofcv.factory.feature.detdesc.ConfigDetectDescribe;
import boofcv.factory.feature.detect.interest.ConfigDetectInterestPoint;
import boofcv.misc.BoofMiscOps;
import boofcv.struct.ConfigLength;
import boofcv.struct.Configuration;

public class ConfigSimilarImagesSceneRecognition
implements Configuration {
    public int limitMatchesConsider = 30;
    public final ConfigLength minimumSimilar = ConfigLength.relative((double)0.2, (double)100.0);
    public final ConfigDetectDescribe features = new ConfigDetectDescribe();
    public final ConfigRecognitionNister2006 recognizeNister2006 = new ConfigRecognitionNister2006();
    public final ConfigAssociate associate = new ConfigAssociate();

    public ConfigSimilarImagesSceneRecognition() {
        this.recognizeNister2006.learningMinimumPointsForChildren.setFixed(20.0);
        this.features.typeDescribe = ConfigDescribeRegion.Type.SURF_STABLE;
        this.features.typeDetector = ConfigDetectInterestPoint.Type.FAST_HESSIAN;
        this.features.detectFastHessian.extract.threshold = 0.5f;
        this.features.detectFastHessian.extract.radius = 5;
        this.features.detectFastHessian.numberOfOctaves = 7;
        this.features.detectFastHessian.maxFeaturesAll = 1000;
        this.features.detectFastHessian.extract.radius = 6;
        this.features.detectFastHessian.maxFeaturesPerScale = 0;
        this.features.describeSift.sigmaToPixels = 2.0;
        this.features.detectSift.extract.threshold = 0.5f;
        this.features.detectSift.extract.radius = 6;
        this.features.detectSift.maxFeaturesAll = 800;
        this.features.detectSift.maxFeaturesPerScale = 0;
        this.features.convertDescriptor.outputData = ConfigConvertTupleDesc.DataType.F32;
    }

    public static ConfigSimilarImagesSceneRecognition createFailSafe() {
        ConfigSimilarImagesSceneRecognition config = new ConfigSimilarImagesSceneRecognition();
        config.features.detectFastHessian.extract.threshold = 0.0f;
        config.features.detectFastHessian.extract.radius = 2;
        config.features.detectFastHessian.numberOfOctaves = 4;
        config.features.detectSift.extract.threshold = 0.0f;
        config.features.detectSift.extract.radius = 2;
        config.features.describeSift.sigmaToPixels = 1.0;
        config.recognizeNister2006.learningMinimumPointsForChildren.setFixed(0.0);
        config.recognizeNister2006.minimumDepthFromRoot = 0;
        config.minimumSimilar.setFraction(0.4);
        return config;
    }

    public void checkValidity() {
        BoofMiscOps.checkTrue((this.limitMatchesConsider >= 1 ? 1 : 0) != 0, (String)"Must consider at least 1 match");
        this.features.checkValidity();
        this.recognizeNister2006.checkValidity();
        this.associate.checkValidity();
    }

    public void setTo(ConfigSimilarImagesSceneRecognition src) {
        this.limitMatchesConsider = src.limitMatchesConsider;
        this.minimumSimilar.setTo(src.minimumSimilar);
        this.features.setTo(src.features);
        this.recognizeNister2006.setTo(src.recognizeNister2006);
        this.associate.setTo(src.associate);
    }
}

