/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.structure;

import boofcv.abst.geo.TriangulateNViewsMetricH;
import boofcv.abst.geo.bundle.MetricBundleAdjustmentUtils;
import boofcv.abst.geo.bundle.SceneObservations;
import boofcv.abst.geo.bundle.SceneStructureCommon;
import boofcv.abst.geo.bundle.SceneStructureMetric;
import boofcv.alg.distort.brown.RemoveBrownPtoN_F64;
import boofcv.alg.geo.PerspectiveOps;
import boofcv.alg.geo.bundle.cameras.BundlePinholeSimplified;
import boofcv.alg.structure.LookUpSimilarImages;
import boofcv.alg.structure.PairwiseImageGraph;
import boofcv.alg.structure.SceneWorkingGraph;
import boofcv.factory.geo.FactoryMultiView;
import boofcv.misc.BoofMiscOps;
import boofcv.struct.calib.CameraPinholeBrown;
import georegression.struct.GeoTuple2D_F64;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point4D_F64;
import georegression.struct.se.Se3_F64;
import georegression.transform.se.SePointOps_F64;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.ddogleg.struct.DogArray;
import org.ddogleg.struct.DogArray_B;
import org.ddogleg.struct.DogArray_I32;
import org.ddogleg.struct.VerbosePrint;
import org.jetbrains.annotations.Nullable;

public class MetricSanityChecks
implements VerbosePrint {
    public TriangulateNViewsMetricH triangulator = FactoryMultiView.triangulateNViewMetricH(null);
    public double maxReprojectionErrorSq = 100.0;
    public DogArray_B badFeatures = new DogArray_B();
    int failedTriangulate;
    int failedBehind;
    int failedImageBounds;
    int failedReprojection;
    @Nullable
    PrintStream verbose;

    public boolean checkPhysicalConstraints(LookUpSimilarImages dbSimilar, SceneWorkingGraph scene, SceneWorkingGraph.View wview, int setIdx) {
        this.failedTriangulate = 0;
        this.failedBehind = 0;
        this.failedImageBounds = 0;
        this.failedReprojection = 0;
        SceneWorkingGraph.InlierInfo inliers = (SceneWorkingGraph.InlierInfo)wview.inliers.get(setIdx);
        int numFeatures = inliers.getInlierCount();
        this.badFeatures.resetResize(numFeatures, false);
        ArrayList<SceneWorkingGraph.View> listViews = new ArrayList<SceneWorkingGraph.View>();
        ArrayList<RemoveBrownPtoN_F64> listNormalize = new ArrayList<RemoveBrownPtoN_F64>();
        ArrayList<Se3_F64> listMotion = new ArrayList<Se3_F64>();
        ArrayList<DogArray> listFeatures = new ArrayList<DogArray>();
        ArrayList<Point2D_F64> listViewPixels = new ArrayList<Point2D_F64>();
        Se3_F64 view1_to_world = wview.world_to_view.invert(null);
        for (int i = 0; i < inliers.views.size; ++i) {
            SceneWorkingGraph.View w = scene.lookupView(((PairwiseImageGraph.View)inliers.views.get((int)i)).id);
            SceneWorkingGraph.Camera c = scene.getViewCamera(w);
            if (c.intrinsic.f <= 0.0) {
                if (this.verbose != null) {
                    this.verbose.println("Negative focal length. view='" + w.pview.id + "'");
                }
                return false;
            }
            listViews.add(w);
            RemoveBrownPtoN_F64 normalize = new RemoveBrownPtoN_F64();
            normalize.setK(c.intrinsic.f, c.intrinsic.f, 0.0, 0.0, 0.0).setDistortion(c.intrinsic.k1, c.intrinsic.k2);
            listNormalize.add(normalize);
            listMotion.add(view1_to_world.concat(w.world_to_view, null));
            SceneWorkingGraph.Camera wcamera = scene.getViewCamera(w);
            DogArray features = new DogArray(Point2D_F64::new);
            dbSimilar.lookupPixelFeats(w.pview.id, (DogArray<Point2D_F64>)features);
            double cx = wcamera.prior.cx;
            double cy = wcamera.prior.cy;
            features.forEach(p -> p.setTo(p.x - cx, p.y - cy));
            listFeatures.add(features);
        }
        List pixelNorms = BoofMiscOps.createListFilled((int)inliers.views.size, Point2D_F64::new);
        Point4D_F64 foundX = new Point4D_F64();
        Point4D_F64 viewX = new Point4D_F64();
        Point2D_F64 predictdPixel = new Point2D_F64();
        SceneWorkingGraph.Camera wviewCamera = scene.getViewCamera(wview);
        for (int inlierIdx = 0; inlierIdx < numFeatures; ++inlierIdx) {
            listViewPixels.clear();
            for (int viewIdx = 0; viewIdx < listViews.size(); ++viewIdx) {
                Point2D_F64 p2 = (Point2D_F64)((DogArray)listFeatures.get(viewIdx)).get(((DogArray_I32)inliers.observations.get(viewIdx)).get(inlierIdx));
                listViewPixels.add(p2);
                ((RemoveBrownPtoN_F64)listNormalize.get(viewIdx)).compute(p2.x, p2.y, (Point2D_F64)pixelNorms.get(viewIdx));
            }
            if (!this.triangulator.triangulate(pixelNorms, listMotion, foundX)) {
                ++this.failedTriangulate;
                this.badFeatures.set(inlierIdx, true);
                continue;
            }
            boolean badObservation = false;
            for (int viewIdx = 0; viewIdx < listViews.size(); ++viewIdx) {
                Se3_F64 view1_to_view = (Se3_F64)listMotion.get(viewIdx);
                SceneWorkingGraph.View w = (SceneWorkingGraph.View)listViews.get(viewIdx);
                SePointOps_F64.transform((Se3_F64)view1_to_view, (Point4D_F64)foundX, (Point4D_F64)viewX);
                if (PerspectiveOps.isBehindCamera((Point4D_F64)viewX)) {
                    badObservation = true;
                    ++this.failedBehind;
                }
                wviewCamera.intrinsic.project(viewX.x, viewX.y, viewX.z, predictdPixel);
                double reprojectionError = predictdPixel.distance2((GeoTuple2D_F64)((Point2D_F64)listViewPixels.get(viewIdx)));
                if (reprojectionError > this.maxReprojectionErrorSq) {
                    badObservation = true;
                    ++this.failedReprojection;
                }
                SceneWorkingGraph.Camera wcamera = scene.getViewCamera(w);
                int width = wcamera.prior.width;
                int height = wcamera.prior.height;
                double cx = wcamera.prior.cx;
                double cy = wcamera.prior.cy;
                if (BoofMiscOps.isInside((int)width, (int)height, (double)(predictdPixel.x + cx), (double)(predictdPixel.y + cy))) continue;
                badObservation = true;
                ++this.failedImageBounds;
            }
            this.badFeatures.set(inlierIdx, badObservation);
        }
        if (this.verbose != null) {
            this.verbose.printf("view.id='%s' inlierIdx=%d, errors: behind=%d bounds=%d reprojection=%d tri=%d, obs=%d\n", wview.pview.id, setIdx, this.failedBehind, this.failedImageBounds, this.failedReprojection, this.failedTriangulate, numFeatures);
        }
        return true;
    }

    public boolean checkPhysicalConstraints(MetricBundleAdjustmentUtils bundle, List<CameraPinholeBrown> listDimensions) {
        return this.checkPhysicalConstraints(bundle.structure, bundle.observations, listDimensions);
    }

    public boolean checkPhysicalConstraints(SceneStructureMetric structure, SceneObservations observations, List<CameraPinholeBrown> listPriors) {
        BoofMiscOps.checkEq((int)listPriors.size(), (int)structure.views.size);
        for (int i = 0; i < structure.cameras.size; ++i) {
            BundlePinholeSimplified pinhole = (BundlePinholeSimplified)((SceneStructureCommon.Camera)structure.cameras.get((int)i)).model;
            if (!(pinhole.f < 0.0)) continue;
            if (this.verbose != null) {
                this.verbose.println("Bad focal length. f=" + pinhole.f);
            }
            return false;
        }
        this.badFeatures.resetResize(structure.points.size, false);
        Point4D_F64 worldP = new Point4D_F64(0.0, 0.0, 0.0, 1.0);
        Point4D_F64 viewP = new Point4D_F64();
        Point2D_F64 observedPixel = new Point2D_F64();
        Point2D_F64 predictdPixel = new Point2D_F64();
        for (int viewIdx = 0; viewIdx < observations.views.size; ++viewIdx) {
            int cameraIdx = ((SceneStructureMetric.View)structure.views.get((int)viewIdx)).camera;
            BundlePinholeSimplified pinhole = (BundlePinholeSimplified)Objects.requireNonNull(((SceneStructureCommon.Camera)structure.cameras.get((int)cameraIdx)).model);
            CameraPinholeBrown priorCamera = listPriors.get(viewIdx);
            int width = priorCamera.width;
            int height = priorCamera.height;
            float cx = (float)priorCamera.cx;
            float cy = (float)priorCamera.cy;
            int failedBehind = 0;
            int failedImageBounds = 0;
            int failedReprojection = 0;
            Se3_F64 world_to_view = structure.getParentToView(viewIdx);
            SceneObservations.View oview = (SceneObservations.View)observations.views.get(viewIdx);
            for (int i = 0; i < oview.size(); ++i) {
                boolean badObservation = false;
                oview.getPixel(i, observedPixel);
                SceneStructureCommon.Point p = (SceneStructureCommon.Point)structure.points.get(oview.getPointId(i));
                worldP.x = p.getX();
                worldP.y = p.getY();
                worldP.z = p.getZ();
                if (structure.isHomogenous()) {
                    worldP.w = p.getW();
                }
                SePointOps_F64.transform((Se3_F64)world_to_view, (Point4D_F64)worldP, (Point4D_F64)viewP);
                if (PerspectiveOps.isBehindCamera((Point4D_F64)viewP)) {
                    badObservation = true;
                    ++failedBehind;
                }
                pinhole.project(viewP.x, viewP.y, viewP.z, predictdPixel);
                double reprojectionError = predictdPixel.distance2((GeoTuple2D_F64)observedPixel);
                if (reprojectionError > this.maxReprojectionErrorSq) {
                    badObservation = true;
                    ++failedReprojection;
                }
                if (!BoofMiscOps.isInside((int)width, (int)height, (double)(predictdPixel.x + (double)cx), (double)(predictdPixel.y + (double)cy))) {
                    badObservation = true;
                    ++failedImageBounds;
                }
                if (!badObservation) continue;
                this.badFeatures.set(oview.getPointId(i), true);
            }
            if (this.verbose == null) continue;
            this.verbose.printf("view[%d] errors: behind=%d bounds=%d reprojection=%d, obs=%d\n", viewIdx, failedBehind, failedImageBounds, failedReprojection, oview.size());
        }
        return true;
    }

    public void setVerbose(@Nullable PrintStream out, @Nullable Set<String> configuration) {
        this.verbose = BoofMiscOps.addPrefix((VerbosePrint)this, (PrintStream)out);
    }
}

