/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.structure;

import boofcv.abst.geo.TriangulateNViewsMetricH;
import boofcv.abst.geo.bundle.BundleAdjustmentCamera;
import boofcv.abst.geo.bundle.MetricBundleAdjustmentUtils;
import boofcv.abst.geo.bundle.SceneObservations;
import boofcv.abst.geo.bundle.SceneStructureCommon;
import boofcv.abst.geo.bundle.SceneStructureMetric;
import boofcv.alg.distort.LensDistortionNarrowFOV;
import boofcv.alg.geo.bundle.BundleAdjustmentOps;
import boofcv.alg.geo.bundle.cameras.BundlePinholeSimplified;
import boofcv.alg.structure.LookUpSimilarImages;
import boofcv.alg.structure.PairwiseImageGraph;
import boofcv.alg.structure.SceneWorkingGraph;
import boofcv.factory.distort.LensDistortionFactory;
import boofcv.misc.BoofMiscOps;
import boofcv.struct.calib.CameraModel;
import boofcv.struct.calib.CameraPinholeBrown;
import boofcv.struct.distort.Point2Transform2_F64;
import georegression.geometry.ConvertRotation3D_F64;
import georegression.struct.GeoTuple2D_F64;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point4D_F64;
import georegression.struct.se.Se3_F64;
import georegression.transform.se.SePointOps_F64;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.ddogleg.struct.DogArray;
import org.ddogleg.struct.DogArray_I32;
import org.ddogleg.struct.FastArray;
import org.ddogleg.struct.VerbosePrint;
import org.ejml.data.DMatrixRMaj;
import org.jetbrains.annotations.Nullable;

public class RefineMetricWorkingGraph
implements VerbosePrint {
    public double maxReprojectionErrorPixel = 1.0E100;
    public final MetricBundleAdjustmentUtils metricSba;
    protected final List<Point2Transform2_F64> listPixelToNorm = new ArrayList<Point2Transform2_F64>();
    protected final List<Point2Transform2_F64> listNormToPixel = new ArrayList<Point2Transform2_F64>();
    TObjectIntHashMap<String> viewToIntegerID = new TObjectIntHashMap();
    @Nullable
    private PrintStream verbose;
    public boolean verboseViewInfo = true;
    public FilterInlierSet inlierFilter = (scene, info) -> true;
    protected final DogArray<Point2D_F64> pixels = new DogArray(Point2D_F64::new);
    protected final DogArray<Point2D_F64> pixelNormalized = new DogArray(Point2D_F64::new);
    protected final DogArray<Se3_F64> listPoses = new DogArray(Se3_F64::new);
    protected final Se3_F64 view0_to_world = new Se3_F64();
    final DogArray_I32 unassigned = new DogArray_I32();
    final DogArray_I32 featureIdx3D = new DogArray_I32();
    final DogArray_I32 sceneViewIntIds = new DogArray_I32();
    private final Point2D_F64 pixelObserved = new Point2D_F64();
    private final Point2D_F64 pixelPredicted = new Point2D_F64();
    private final Point4D_F64 world3D = new Point4D_F64();
    private final Point4D_F64 camera3D = new Point4D_F64();
    private final Point4D_F64 found3D = new Point4D_F64();

    public RefineMetricWorkingGraph(MetricBundleAdjustmentUtils metricSba) {
        this.metricSba = metricSba;
    }

    public RefineMetricWorkingGraph() {
        this(new MetricBundleAdjustmentUtils());
    }

    public boolean process(LookUpSimilarImages dbSimilar, SceneWorkingGraph graph) {
        return this.process(dbSimilar, graph, utils -> {});
    }

    public boolean process(LookUpSimilarImages dbSimilar, SceneWorkingGraph graph, CallBeforeRefine op) {
        if (!this.constructBundleScene(dbSimilar, graph)) {
            return false;
        }
        op.process(this.metricSba);
        return this.refineViews(graph);
    }

    public boolean constructBundleScene(LookUpSimilarImages dbSimilar, SceneWorkingGraph graph) {
        this.initializeDataStructures(dbSimilar, graph);
        if (!this.createFeatures3D(graph)) {
            return false;
        }
        this.pruneUnassignedObservations();
        return true;
    }

    void initializeDataStructures(LookUpSimilarImages dbSimilar, SceneWorkingGraph graph) {
        this.viewToIntegerID.clear();
        this.listPixelToNorm.clear();
        this.listNormToPixel.clear();
        SceneStructureMetric structure = this.metricSba.structure;
        SceneObservations observations = this.metricSba.observations;
        structure.initialize(graph.listCameras.size, graph.listViews.size(), 0);
        observations.initialize(graph.listViews.size());
        for (int cameraIdx = 0; cameraIdx < graph.listCameras.size; ++cameraIdx) {
            SceneWorkingGraph.Camera wcam = (SceneWorkingGraph.Camera)graph.listCameras.get(cameraIdx);
            structure.setCamera(cameraIdx, false, (BundleAdjustmentCamera)wcam.intrinsic);
        }
        for (int viewIdx = 0; viewIdx < graph.listViews.size(); ++viewIdx) {
            SceneWorkingGraph.View wview = graph.listViews.get(viewIdx);
            SceneObservations.View oview = observations.getView(viewIdx);
            this.viewToIntegerID.put((Object)wview.pview.id, viewIdx);
            this.createProjectionModel(graph.getViewCamera((SceneWorkingGraph.View)wview).intrinsic);
            oview.resize(wview.pview.totalObservations);
            dbSimilar.lookupPixelFeats(wview.pview.id, this.pixels);
            BoofMiscOps.checkEq((int)this.pixels.size, (int)wview.pview.totalObservations);
            SceneWorkingGraph.Camera camera = graph.getViewCamera(wview);
            float cx = (float)camera.prior.cx;
            float cy = (float)camera.prior.cy;
            for (int obsIdx = 0; obsIdx < this.pixels.size; ++obsIdx) {
                Point2D_F64 p = (Point2D_F64)this.pixels.get(obsIdx);
                oview.setPixel(obsIdx, (float)(p.x - (double)cx), (float)(p.y - (double)cy));
            }
            structure.setView(viewIdx, camera.localIndex, viewIdx == 0, wview.world_to_view);
        }
    }

    boolean createFeatures3D(SceneWorkingGraph graph) {
        int filtered = 0;
        int total = 0;
        for (int workingIdx = 0; workingIdx < graph.listViews.size(); ++workingIdx) {
            SceneWorkingGraph.View wview = graph.listViews.get(workingIdx);
            for (int infoIdx = 0; infoIdx < wview.inliers.size; ++infoIdx) {
                SceneWorkingGraph.InlierInfo inliers = (SceneWorkingGraph.InlierInfo)wview.inliers.get(infoIdx);
                if (!this.inlierFilter.keep(wview, inliers)) {
                    ++filtered;
                    continue;
                }
                if (this.verbose != null && this.verboseViewInfo) {
                    this.verbose.print("inlier[" + infoIdx + "] view='" + wview.pview.id + "' size=" + inliers.getInlierCount() + " , ");
                }
                this.createFeaturesFromInlierInfo(graph, inliers);
            }
            total += wview.inliers.size;
        }
        if (this.verbose != null) {
            this.verbose.println("triangulation: sets: skipped=" + filtered + " total=" + total);
        }
        return filtered < total;
    }

    private void createFeaturesFromInlierInfo(SceneWorkingGraph graph, SceneWorkingGraph.InlierInfo inlierSet) {
        FastArray<PairwiseImageGraph.View> inlierViews = inlierSet.views;
        this.initLookUpTablesForInlierSet(graph, inlierViews);
        int numInliers = inlierSet.getInlierCount();
        int countMatched = 0;
        int countMixed = 0;
        int tooFew = 0;
        for (int inlierIdx = 0; inlierIdx < numInliers; ++inlierIdx) {
            this.findUnassignedObsAndKnown3D(inlierSet, inlierIdx);
            if (this.unassigned.size != 0 && this.featureIdx3D.size != 0) {
                ++countMixed;
            } else if (this.featureIdx3D.size != 0) {
                ++countMatched;
            }
            if (this.featureIdx3D.size > 0) {
                this.assignKnown3DToUnassignedObs(graph, inlierSet, inlierIdx);
            }
            if (this.unassigned.size < 2) {
                if (this.unassigned.size <= 0) continue;
                ++tooFew;
                continue;
            }
            this.triangulateAndSave(inlierSet, inlierIdx);
        }
        if (this.verbose != null && this.verboseViewInfo) {
            this.verbose.println("Adding Points: unmatched=" + (numInliers - countMatched) + " matched=" + countMatched + " mixed=" + countMixed + " tooFew=" + tooFew);
        }
    }

    void initLookUpTablesForInlierSet(SceneWorkingGraph graph, FastArray<PairwiseImageGraph.View> inlierViews) {
        this.pixelNormalized.resize(inlierViews.size);
        this.sceneViewIntIds.reset();
        this.listPoses.resize(inlierViews.size);
        Se3_F64 world_to_view0 = graph.views.get((Object)((PairwiseImageGraph.View)inlierViews.get((int)0)).id).world_to_view;
        world_to_view0.invert(this.view0_to_world);
        for (int i = 0; i < inlierViews.size; ++i) {
            String viewID = ((PairwiseImageGraph.View)inlierViews.get((int)i)).id;
            this.sceneViewIntIds.add(this.viewToIntegerID.get((Object)viewID));
            this.view0_to_world.concat(graph.views.get((Object)viewID).world_to_view, (Se3_F64)this.listPoses.get(i));
        }
    }

    void assignKnown3DToUnassignedObs(SceneWorkingGraph graph, SceneWorkingGraph.InlierInfo inliers, int inlierIdx) {
        SceneStructureMetric structure = this.metricSba.structure;
        SceneObservations observations = this.metricSba.observations;
        for (int unassignedIdx = this.unassigned.size - 1; unassignedIdx >= 0; --unassignedIdx) {
            int whichViewInliers = this.unassigned.get(unassignedIdx);
            int whichViewID = this.sceneViewIntIds.get(whichViewInliers);
            int viewObsIdx = ((DogArray_I32)inliers.observations.get(whichViewInliers)).get(inlierIdx);
            observations.getView(whichViewID).getPixel(viewObsIdx, this.pixelObserved);
            SceneWorkingGraph.View wview = graph.listViews.get(whichViewID);
            Point2Transform2_F64 normToPixels = this.listNormToPixel.get(whichViewID);
            double bestScore = this.maxReprojectionErrorPixel * this.maxReprojectionErrorPixel;
            int bestId = -1;
            for (int knownIdx = 0; knownIdx < this.featureIdx3D.size; ++knownIdx) {
                int featureId = this.featureIdx3D.get(knownIdx);
                if (((SceneStructureCommon.Point)structure.points.get((int)featureId)).views.contains(whichViewID)) continue;
                ((SceneStructureCommon.Point)structure.getPoints().get(featureId)).get(this.world3D);
                double error = this.computeReprojectionError(wview.world_to_view, normToPixels, this.pixelObserved, this.world3D);
                if (!(error <= bestScore)) continue;
                bestScore = error;
                bestId = featureId;
            }
            if (bestId == -1) {
                if (this.verbose == null) continue;
                this.verbose.println("Not matching. Reprojection error too large view=" + whichViewID);
                continue;
            }
            observations.getView(whichViewID).safeAssignToFeature(viewObsIdx, bestId);
            structure.connectPointToView(bestId, whichViewID);
            this.unassigned.removeSwap(unassignedIdx);
        }
    }

    double computeReprojectionError(Se3_F64 world_to_view, Point2Transform2_F64 normToPixels, Point2D_F64 pixelObs, Point4D_F64 world3D) {
        SePointOps_F64.transform((Se3_F64)world_to_view, (Point4D_F64)world3D, (Point4D_F64)this.camera3D);
        double normX = this.camera3D.x / this.camera3D.z;
        double normY = this.camera3D.y / this.camera3D.z;
        normToPixels.compute(normX, normY, this.pixelPredicted);
        return pixelObs.distance2((GeoTuple2D_F64)this.pixelPredicted);
    }

    void findUnassignedObsAndKnown3D(SceneWorkingGraph.InlierInfo inlierSet, int inlierIdx) {
        this.unassigned.reset();
        this.featureIdx3D.reset();
        for (int inlierViewIdx = 0; inlierViewIdx < this.sceneViewIntIds.size; ++inlierViewIdx) {
            int obsIdx = ((DogArray_I32)inlierSet.observations.get(inlierViewIdx)).get(inlierIdx);
            int featIdx = ((SceneObservations.View)this.metricSba.observations.views.get(this.sceneViewIntIds.get(inlierViewIdx))).getPointId(obsIdx);
            if (featIdx >= 0) {
                if (this.featureIdx3D.contains(featIdx)) continue;
                this.featureIdx3D.add(featIdx);
                continue;
            }
            this.unassigned.add(inlierViewIdx);
        }
    }

    void createProjectionModel(BundlePinholeSimplified intrinsic) {
        CameraPinholeBrown brown = new CameraPinholeBrown();
        BundleAdjustmentOps.convert((BundlePinholeSimplified)intrinsic, (int)0, (int)0, (CameraPinholeBrown)brown);
        LensDistortionNarrowFOV model = LensDistortionFactory.narrow((CameraModel)brown);
        this.listPixelToNorm.add(model.undistort_F64(true, false));
        this.listNormToPixel.add(model.distort_F64(false, true));
    }

    void triangulateAndSave(SceneWorkingGraph.InlierInfo inlierSet, int inlierIdx) {
        SceneStructureMetric structure = this.metricSba.structure;
        SceneObservations observations = this.metricSba.observations;
        TriangulateNViewsMetricH triangulator = this.metricSba.triangulator;
        for (int inlierViewIdx = 0; inlierViewIdx < this.sceneViewIntIds.size; ++inlierViewIdx) {
            int viewID = this.sceneViewIntIds.get(inlierViewIdx);
            int obsIdx = ((DogArray_I32)inlierSet.observations.get(inlierViewIdx)).get(inlierIdx);
            observations.getView(viewID).getPixel(obsIdx, this.pixelObserved);
            this.listPixelToNorm.get(viewID).compute(this.pixelObserved.x, this.pixelObserved.y, (Point2D_F64)this.pixelNormalized.get(inlierViewIdx));
        }
        if (!triangulator.triangulate(this.pixelNormalized.toList(), this.listPoses.toList(), this.found3D)) {
            return;
        }
        SePointOps_F64.transform((Se3_F64)this.view0_to_world, (Point4D_F64)this.found3D, (Point4D_F64)this.found3D);
        int pointID = structure.points.size;
        SceneStructureCommon.Point point3D = (SceneStructureCommon.Point)structure.points.grow();
        if (structure.isHomogenous()) {
            point3D.set(this.found3D.x, this.found3D.y, this.found3D.z, this.found3D.w);
        } else {
            point3D.set(this.found3D.x / this.found3D.w, this.found3D.y / this.found3D.w, this.found3D.z / this.found3D.w);
        }
        for (int i = 0; i < this.unassigned.size; ++i) {
            int inlierViewIdx = this.unassigned.get(i);
            int obsIdx = ((DogArray_I32)inlierSet.observations.get(inlierViewIdx)).get(inlierIdx);
            int viewID = this.sceneViewIntIds.get(inlierViewIdx);
            observations.getView((int)viewID).point.set(obsIdx, pointID);
            point3D.views.add(viewID);
        }
    }

    void pruneUnassignedObservations() {
        SceneObservations observations = this.metricSba.observations;
        for (int i = 0; i < observations.views.size; ++i) {
            SceneObservations.View v = (SceneObservations.View)observations.views.get(i);
            for (int j = v.point.size() - 1; j >= 0; --j) {
                if (v.point.get(j) != -1) continue;
                v.point.data[j] = v.point.removeTail();
                v.observations.data[j * 2] = v.observations.getTail(1);
                v.observations.data[j * 2 + 1] = v.observations.getTail(0);
                v.observations.size -= 2;
            }
        }
    }

    protected boolean refineViews(SceneWorkingGraph graph) {
        if (!this.metricSba.process()) {
            return false;
        }
        SceneStructureMetric structure = this.metricSba.structure;
        for (int cameraIdx = 0; cameraIdx < graph.listCameras.size(); ++cameraIdx) {
            BundlePinholeSimplified found = (BundlePinholeSimplified)((SceneStructureCommon.Camera)structure.cameras.get((int)cameraIdx)).model;
            ((SceneWorkingGraph.Camera)graph.listCameras.get((int)cameraIdx)).intrinsic.setTo(found);
        }
        for (int viewIdx = 0; viewIdx < graph.listViews.size(); ++viewIdx) {
            SceneWorkingGraph.View wview = graph.listViews.get(viewIdx);
            wview.world_to_view.setTo(structure.getParentToView(viewIdx));
            if (this.verbose == null || !this.verboseViewInfo) continue;
            BundlePinholeSimplified intrinsics = graph.getViewCamera((SceneWorkingGraph.View)wview).intrinsic;
            Se3_F64 m = this.metricSba.structure.getParentToView(viewIdx);
            double theta = ConvertRotation3D_F64.matrixToRodrigues((DMatrixRMaj)m.R, null).theta;
            this.verbose.printf("AFTER view='%s' T=(%.2f %.2f %.2f) R=%.4f, f=%.1f k1=%.1e k2=%.1e\n", wview.pview.id, m.T.x, m.T.y, m.T.z, theta, intrinsics.f, intrinsics.k1, intrinsics.k2);
        }
        return true;
    }

    public void setVerbose(@Nullable PrintStream out, @Nullable Set<String> configuration) {
        this.verbose = BoofMiscOps.addPrefix((VerbosePrint)this, (PrintStream)out);
        BoofMiscOps.verboseChildren((PrintStream)out, configuration, (VerbosePrint[])new VerbosePrint[]{this.metricSba});
    }

    @FunctionalInterface
    public static interface FilterInlierSet {
        public boolean keep(SceneWorkingGraph.View var1, SceneWorkingGraph.InlierInfo var2);
    }

    @FunctionalInterface
    public static interface CallBeforeRefine {
        public void process(MetricBundleAdjustmentUtils var1);
    }
}

