/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.structure;

import boofcv.alg.distort.brown.RemoveBrownPtoN_F64;
import boofcv.alg.geo.bundle.cameras.BundlePinholeSimplified;
import boofcv.alg.structure.LookUpSimilarImages;
import boofcv.alg.structure.MetricFromUncalibratedPairwiseGraph;
import boofcv.alg.structure.PairwiseImageGraph;
import boofcv.alg.structure.RefineMetricGraphSubset;
import boofcv.alg.structure.ResolveSceneScaleAmbiguity;
import boofcv.alg.structure.ScaleSe3_F64;
import boofcv.alg.structure.SceneWorkingGraph;
import boofcv.misc.BoofMiscOps;
import boofcv.struct.calib.CameraPinholeBrown;
import georegression.struct.point.Point2D_F64;
import georegression.struct.se.Se3_F64;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.ddogleg.sorting.QuickSort_S32;
import org.ddogleg.struct.DogArray;
import org.ddogleg.struct.DogArray_B;
import org.ddogleg.struct.DogArray_I32;
import org.ddogleg.struct.VerbosePrint;
import org.jetbrains.annotations.Nullable;

public class SceneMergingOperations
implements VerbosePrint {
    DogArray<DogArray<SceneCommonCounts>> commonViewCounts = new DogArray(() -> new DogArray(SceneCommonCounts::new, SceneCommonCounts::reset), DogArray::reset);
    DogArray_B enabledScenes = new DogArray_B();
    QuickSort_S32 sorter = new QuickSort_S32();
    ResolveSceneScaleAmbiguity resolveScale = new ResolveSceneScaleAmbiguity();
    RefineMetricGraphSubset refineSubset = new RefineMetricGraphSubset();
    public final List<SceneWorkingGraph.View> mergedViews = new ArrayList<SceneWorkingGraph.View>();
    public final List<SceneWorkingGraph.View> duplicateViews = new ArrayList<SceneWorkingGraph.View>();
    List<Se3_F64> listWorldToViewSrc = new ArrayList<Se3_F64>();
    DogArray<RemoveBrownPtoN_F64> listIntrinsicsSrc = new DogArray(RemoveBrownPtoN_F64::new);
    List<Se3_F64> listWorldToViewDst = new ArrayList<Se3_F64>();
    DogArray<RemoveBrownPtoN_F64> listIntrinsicsDst = new DogArray(RemoveBrownPtoN_F64::new);
    DogArray<Point2D_F64> zeroViewPixels = new DogArray(Point2D_F64::new);
    DogArray<Point2D_F64> dbPixels = new DogArray(Point2D_F64::new);
    DogArray_I32 zeroFeatureToCommonIndex = new DogArray_I32();
    DogArray<FailedMerged> failedMerges = new DogArray(FailedMerged::new, FailedMerged::reset);
    @Nullable
    PrintStream verbose;

    public void initializeViewCounts(MetricFromUncalibratedPairwiseGraph.PairwiseViewScenes scenesInEachView, int numScenes) {
        BoofMiscOps.checkTrue((scenesInEachView.views.size > 0 ? 1 : 0) != 0, (String)"There are no views");
        BoofMiscOps.checkTrue((numScenes > 0 ? 1 : 0) != 0, (String)"There are no scenes");
        this.failedMerges.reset();
        this.commonViewCounts.resetResize(numScenes);
        this.enabledScenes.resetResize(numScenes, true);
        for (int viewsIdx = 0; viewsIdx < scenesInEachView.views.size; ++viewsIdx) {
            MetricFromUncalibratedPairwiseGraph.ViewScenes v = (MetricFromUncalibratedPairwiseGraph.ViewScenes)scenesInEachView.views.get(viewsIdx);
            v.viewedBy.sort(this.sorter);
            for (int srcIdx = 0; srcIdx < v.viewedBy.size; ++srcIdx) {
                int sceneSrc = v.viewedBy.get(srcIdx);
                DogArray countsSrc = (DogArray)this.commonViewCounts.get(sceneSrc);
                for (int dstIdx = srcIdx + 1; dstIdx < v.viewedBy.size; ++dstIdx) {
                    int sceneDst = v.viewedBy.get(dstIdx);
                    ++SceneMergingOperations.findViewCounts((DogArray<SceneCommonCounts>)countsSrc, (int)sceneDst).counts;
                }
            }
        }
    }

    public void toggleViewEnabled(SceneWorkingGraph target, MetricFromUncalibratedPairwiseGraph.PairwiseViewScenes scenesInEachView) {
        BoofMiscOps.checkTrue((!target.listViews.isEmpty() ? 1 : 0) != 0);
        boolean enable = !this.enabledScenes.get(target.index);
        int amount = enable ? 1 : -1;
        target.listViews.forEach(wv -> {
            MetricFromUncalibratedPairwiseGraph.ViewScenes v = scenesInEachView.getView(wv.pview);
            for (int srcIdx = 0; srcIdx < v.viewedBy.size; ++srcIdx) {
                int sceneSrc = v.viewedBy.get(srcIdx);
                if (srcIdx > 0 && v.viewedBy.get(srcIdx - 1) >= sceneSrc) {
                    throw new RuntimeException("BUG! viewdBy isn't sorted");
                }
                DogArray countsSrc = (DogArray)this.commonViewCounts.get(sceneSrc);
                if (sceneSrc == target.index) {
                    for (int dstIdx = srcIdx + 1; dstIdx < v.viewedBy.size; ++dstIdx) {
                        int sceneDst = v.viewedBy.get(dstIdx);
                        if (!this.enabledScenes.get(sceneDst)) continue;
                        SceneMergingOperations.findViewCounts((DogArray<SceneCommonCounts>)countsSrc, (int)sceneDst).counts += amount;
                    }
                    continue;
                }
                if (sceneSrc >= target.index || !this.enabledScenes.get(sceneSrc)) continue;
                SceneMergingOperations.findViewCounts((DogArray<SceneCommonCounts>)countsSrc, (int)target.index).counts += amount;
            }
        });
        this.enabledScenes.set(target.index, enable);
    }

    public boolean selectScenesToMerge(SelectedScenes selected) {
        int bestCommon = 0;
        for (int sceneIndexA = 0; sceneIndexA < this.commonViewCounts.size; ++sceneIndexA) {
            if (!this.enabledScenes.get(sceneIndexA)) continue;
            DogArray list = (DogArray)this.commonViewCounts.get(sceneIndexA);
            for (int j = 0; j < list.size; ++j) {
                SceneCommonCounts overlap = (SceneCommonCounts)list.get(j);
                if (!this.enabledScenes.get(overlap.sceneIndex) || overlap.counts <= bestCommon || this.isMergedBlocked(sceneIndexA, overlap.sceneIndex)) continue;
                bestCommon = overlap.counts;
                selected.sceneA = sceneIndexA;
                selected.sceneB = overlap.sceneIndex;
            }
        }
        return bestCommon > 0;
    }

    public boolean isMergedBlocked(int indexSrc, int indexDst) {
        BoofMiscOps.checkTrue((indexSrc < indexDst ? 1 : 0) != 0);
        for (int failedIdx = 0; failedIdx < this.failedMerges.size; ++failedIdx) {
            FailedMerged f = (FailedMerged)this.failedMerges.get(failedIdx);
            if (f.src.index != indexSrc || f.dst.index != indexDst) continue;
            if (f.src.listViews.size() == f.viewCountSrc && f.dst.listViews.size() == f.viewCountDst) {
                return true;
            }
            this.failedMerges.removeSwap(failedIdx);
            return false;
        }
        return false;
    }

    public boolean decideFirstIntoSecond(SceneWorkingGraph scene1, SceneWorkingGraph scene2) {
        return scene1.listViews.size() < scene2.listViews.size();
    }

    void mergeStructure(SceneWorkingGraph src, SceneWorkingGraph dst, ScaleSe3_F64 src_to_dst, MetricFromUncalibratedPairwiseGraph.PairwiseViewScenes scenesInEachView) {
        this.mergedViews.clear();
        this.duplicateViews.clear();
        Se3_F64 src_to_view = new Se3_F64();
        Se3_F64 transform_dst_to_src = src_to_dst.transform.invert(null);
        for (int srcViewIdx = 0; srcViewIdx < src.listViews.size(); ++srcViewIdx) {
            SceneWorkingGraph.View dstView;
            SceneWorkingGraph.View srcView = src.listViews.get(srcViewIdx);
            boolean copySrc = false;
            if (dst.views.containsKey(srcView.pview.id)) {
                dstView = dst.views.get(srcView.pview.id);
                this.duplicateViews.add(dstView);
                if (this.verbose != null) {
                    BundlePinholeSimplified srcIntrinsic = src.getViewCamera((SceneWorkingGraph.View)srcView).intrinsic;
                    BundlePinholeSimplified dstIntrinsic = dst.getViewCamera((SceneWorkingGraph.View)dstView).intrinsic;
                    this.verbose.printf("view='%s', sets={%d %d}, scores: %.1f vs %.1f, src.f=%.1f dst.f=%.1f\n", srcView.pview.id, srcView.inliers.size, dstView.inliers.size, srcView.getBestInlierScore(), dstView.getBestInlierScore(), srcIntrinsic.f, dstIntrinsic.f);
                }
            } else {
                scenesInEachView.getView((PairwiseImageGraph.View)srcView.pview).viewedBy.add(dst.index);
                scenesInEachView.getView((PairwiseImageGraph.View)srcView.pview).viewedBy.sort(this.sorter);
                SceneWorkingGraph.Camera cameraSrc = src.getViewCamera(srcView);
                SceneWorkingGraph.Camera cameraDst = (SceneWorkingGraph.Camera)dst.cameras.get(cameraSrc.indexDB);
                if (cameraDst == null) {
                    cameraDst = dst.addCameraCopy(cameraSrc);
                }
                dstView = dst.addView(srcView.pview, cameraDst);
                copySrc = true;
                if (this.verbose != null) {
                    BundlePinholeSimplified srcIntrinsic = src.getViewCamera((SceneWorkingGraph.View)srcView).intrinsic;
                    this.verbose.printf("view='%s', sets=%d, score: %.1f, src.f=%.1f\n", srcView.pview.id, srcView.inliers.size, srcView.getBestInlierScore(), srcIntrinsic.f);
                }
            }
            this.mergedViews.add(dstView);
            for (int infoIdx = 0; infoIdx < srcView.inliers.size; ++infoIdx) {
                ((SceneWorkingGraph.InlierInfo)dstView.inliers.grow()).setTo((SceneWorkingGraph.InlierInfo)srcView.inliers.get(infoIdx));
            }
            if (!copySrc) continue;
            src_to_view.setTo(srcView.world_to_view);
            src_to_view.T.scale(src_to_dst.scale);
            transform_dst_to_src.concat(src_to_view, dstView.world_to_view);
        }
    }

    public boolean computeSceneTransform(LookUpSimilarImages dbSimilar, SceneWorkingGraph src, SceneWorkingGraph dst, SceneWorkingGraph.View selectedSrc, SceneWorkingGraph.View selectedDst, ScaleSe3_F64 src_to_dst) {
        int numObservations;
        DogArray_I32 zeroDstIdx;
        BoofMiscOps.checkSame((Object)selectedSrc.pview, (Object)selectedDst.pview);
        if (this.verbose != null) {
            this.printInlierViews(selectedSrc, selectedDst);
        }
        SceneWorkingGraph.InlierInfo inliersSrc = Objects.requireNonNull(selectedSrc.getBestInliers());
        SceneWorkingGraph.InlierInfo inliersDst = Objects.requireNonNull(selectedDst.getBestInliers());
        DogArray_I32 zeroSrcIdx = (DogArray_I32)inliersSrc.observations.get(0);
        int numCommon = SceneMergingOperations.findCommonInliers(zeroSrcIdx, zeroDstIdx = (DogArray_I32)inliersDst.observations.get(0), numObservations = selectedSrc.pview.totalObservations, this.zeroFeatureToCommonIndex);
        if (numCommon == 0) {
            return false;
        }
        SceneWorkingGraph.Camera cameraSrc = src.getViewCamera(selectedSrc);
        this.loadViewZeroCommonObservations(dbSimilar, cameraSrc.prior, numCommon, selectedSrc.pview.id);
        List<DogArray<Point2D_F64>> listViewPixelsSrc = this.getCommonFeaturePixelsViews(dbSimilar, src, inliersSrc);
        List<DogArray<Point2D_F64>> listViewPixelsDst = this.getCommonFeaturePixelsViews(dbSimilar, dst, inliersDst);
        this.loadExtrinsicsIntrinsics(src, inliersSrc, this.listWorldToViewSrc, this.listIntrinsicsSrc);
        this.loadExtrinsicsIntrinsics(dst, inliersDst, this.listWorldToViewDst, this.listIntrinsicsDst);
        if (this.verbose != null) {
            this.verbose.println("commonInliers.size=" + numCommon + " src.size=" + zeroSrcIdx.size + " dst.size=" + zeroDstIdx.size);
        }
        this.resolveScale.initialize(this.zeroViewPixels.size);
        this.resolveScale.setScene1((viewIdx, featureIdx, pixel) -> {
            if (viewIdx == 0) {
                pixel.setTo((Point2D_F64)this.zeroViewPixels.get(featureIdx));
            } else {
                pixel.setTo((Point2D_F64)((DogArray)listViewPixelsSrc.get(viewIdx - 1)).get(featureIdx));
            }
        }, this.listWorldToViewSrc, this.listIntrinsicsSrc.toList());
        this.resolveScale.setScene2((viewIdx, featureIdx, pixel) -> {
            if (viewIdx == 0) {
                pixel.setTo((Point2D_F64)this.zeroViewPixels.get(featureIdx));
            } else {
                pixel.setTo((Point2D_F64)((DogArray)listViewPixelsDst.get(viewIdx - 1)).get(featureIdx));
            }
        }, this.listWorldToViewDst, this.listIntrinsicsDst.toList());
        return this.resolveScale.process(src_to_dst);
    }

    private void printInlierViews(SceneWorkingGraph.View selectedSrc, SceneWorkingGraph.View selectedDst) {
        int i;
        SceneWorkingGraph.InlierInfo inliers;
        int infoIdx;
        PrintStream verbose = Objects.requireNonNull(this.verbose);
        for (infoIdx = 0; infoIdx < selectedSrc.inliers.size; ++infoIdx) {
            verbose.print("src.inliers[" + infoIdx + "].views = { ");
            inliers = (SceneWorkingGraph.InlierInfo)selectedSrc.inliers.get(infoIdx);
            for (i = 0; i < inliers.views.size; ++i) {
                verbose.print("'" + ((PairwiseImageGraph.View)inliers.views.get((int)i)).id + "' ");
            }
            verbose.printf("} count=%d score=%.1f\n", inliers.getInlierCount(), inliers.scoreGeometric);
        }
        for (infoIdx = 0; infoIdx < selectedDst.inliers.size; ++infoIdx) {
            verbose.print("dst.inliers[" + infoIdx + "].views = { ");
            inliers = (SceneWorkingGraph.InlierInfo)selectedDst.inliers.get(infoIdx);
            for (i = 0; i < inliers.views.size; ++i) {
                verbose.print("'" + ((PairwiseImageGraph.View)inliers.views.get((int)i)).id + "' ");
            }
            verbose.printf("} count=%d score=%.1f\n", inliers.getInlierCount(), inliers.scoreGeometric);
        }
    }

    private void loadViewZeroCommonObservations(LookUpSimilarImages dbSimilar, CameraPinholeBrown cameraPrior, int numCommon, String viewID) {
        dbSimilar.lookupPixelFeats(viewID, this.dbPixels);
        this.zeroViewPixels.resetResize(numCommon);
        for (int featureIdx = 0; featureIdx < this.zeroFeatureToCommonIndex.size; ++featureIdx) {
            int commonIdx = this.zeroFeatureToCommonIndex.get(featureIdx);
            if (commonIdx == -1) continue;
            Point2D_F64 p = (Point2D_F64)this.zeroViewPixels.get(commonIdx);
            p.setTo((Point2D_F64)this.dbPixels.get(featureIdx));
            p.x -= cameraPrior.cx;
            p.y -= cameraPrior.cy;
        }
    }

    private void loadExtrinsicsIntrinsics(SceneWorkingGraph scene, SceneWorkingGraph.InlierInfo inliers, List<Se3_F64> listWorldToViewSrc, DogArray<RemoveBrownPtoN_F64> listIntrinsicsSrc) {
        listWorldToViewSrc.clear();
        listIntrinsicsSrc.reset();
        for (int viewIdx = 0; viewIdx < inliers.views.size; ++viewIdx) {
            PairwiseImageGraph.View pview = (PairwiseImageGraph.View)inliers.views.get(viewIdx);
            SceneWorkingGraph.View wview = scene.views.get(pview.id);
            BundlePinholeSimplified cam = scene.getViewCamera((SceneWorkingGraph.View)wview).intrinsic;
            listWorldToViewSrc.add(wview.world_to_view);
            RemoveBrownPtoN_F64 pixelToNorm = (RemoveBrownPtoN_F64)listIntrinsicsSrc.grow();
            pixelToNorm.setK(cam.f, cam.f, 0.0, 0.0, 0.0);
            pixelToNorm.setDistortion(cam.k1, cam.k2);
        }
    }

    List<DogArray<Point2D_F64>> getCommonFeaturePixelsViews(LookUpSimilarImages db, SceneWorkingGraph workingGraph, SceneWorkingGraph.InlierInfo inliers) {
        ArrayList<DogArray<Point2D_F64>> listViewPixels = new ArrayList<DogArray<Point2D_F64>>();
        DogArray_I32 viewZeroInlierIdx = (DogArray_I32)inliers.observations.get(0);
        int numViews = inliers.observations.size;
        for (int viewIdx = 1; viewIdx < numViews; ++viewIdx) {
            db.lookupPixelFeats(((PairwiseImageGraph.View)inliers.views.get((int)viewIdx)).id, this.dbPixels);
            DogArray_I32 inlierIdx = (DogArray_I32)inliers.observations.get(viewIdx);
            BoofMiscOps.checkEq((int)viewZeroInlierIdx.size, (int)inlierIdx.size, (String)"Inliers count should be the same");
            DogArray viewPixels = new DogArray(Point2D_F64::new);
            listViewPixels.add((DogArray<Point2D_F64>)viewPixels);
            viewPixels.resize(this.zeroViewPixels.size);
            SceneWorkingGraph.View wview = workingGraph.views.get(((PairwiseImageGraph.View)inliers.views.get((int)viewIdx)).id);
            SceneWorkingGraph.Camera camera = workingGraph.getViewCamera(wview);
            CameraPinholeBrown cameraPrior = camera.prior;
            for (int idx = 0; idx < inlierIdx.size; ++idx) {
                int viewZeroIdx = viewZeroInlierIdx.get(idx);
                int commonFeatureIdx = this.zeroFeatureToCommonIndex.get(viewZeroIdx);
                if (commonFeatureIdx < 0) continue;
                Point2D_F64 p = (Point2D_F64)viewPixels.get(commonFeatureIdx);
                p.setTo((Point2D_F64)this.dbPixels.get(inlierIdx.get(idx)));
                p.x -= cameraPrior.cx;
                p.y -= cameraPrior.cy;
            }
        }
        return listViewPixels;
    }

    static int findCommonInliers(DogArray_I32 indexesA, DogArray_I32 indexesB, int numObservations, DogArray_I32 zeroFeatureToCommonIndex) {
        zeroFeatureToCommonIndex.resetResize(numObservations, 0);
        indexesA.forEach(v -> {
            int n = v;
            zeroFeatureToCommonIndex.data[n] = zeroFeatureToCommonIndex.data[n] + 1;
        });
        indexesB.forEach(v -> {
            int n = v;
            zeroFeatureToCommonIndex.data[n] = zeroFeatureToCommonIndex.data[n] + 1;
        });
        int count = 0;
        for (int i = 0; i < numObservations; ++i) {
            zeroFeatureToCommonIndex.data[i] = zeroFeatureToCommonIndex.data[i] == 2 ? count++ : -1;
        }
        return count;
    }

    static SceneCommonCounts findViewCounts(DogArray<SceneCommonCounts> list, int targetScene) {
        for (int i = 0; i < list.size; ++i) {
            if (((SceneCommonCounts)list.get((int)i)).sceneIndex != targetScene) continue;
            return (SceneCommonCounts)list.get(i);
        }
        SceneCommonCounts match = (SceneCommonCounts)list.grow();
        match.sceneIndex = targetScene;
        return match;
    }

    public void sanityCheckTable(List<SceneWorkingGraph> scenes) {
        BoofMiscOps.checkEq((int)scenes.size(), (int)this.commonViewCounts.size);
        for (int sceneIdxA = 0; sceneIdxA < scenes.size(); ++sceneIdxA) {
            if (!this.enabledScenes.get(sceneIdxA)) continue;
            DogArray counts = (DogArray)this.commonViewCounts.get(sceneIdxA);
            for (int sceneIdxB = sceneIdxA + 1; sceneIdxB < scenes.size(); ++sceneIdxB) {
                if (!this.enabledScenes.get(sceneIdxB)) continue;
                SceneWorkingGraph sceneB = scenes.get(sceneIdxB);
                int found = this.countCommonViews(scenes.get(sceneIdxA), sceneB);
                int indexInCounts = counts.findIdx(v -> v.sceneIndex == sceneB.index);
                if (found == 0 && indexInCounts != -1) {
                    throw new RuntimeException("Counts not zero when there are no common scenes. " + sceneIdxA + "->" + sceneIdxB + " counts=" + found);
                }
                if (found == 0) continue;
                if (indexInCounts == -1) {
                    throw new RuntimeException("There are matches but that's not in the table: scenes, " + sceneIdxA + "<->" + sceneIdxB);
                }
                int tableCounts = ((SceneCommonCounts)counts.get((int)indexInCounts)).counts;
                if (tableCounts == found) continue;
                throw new RuntimeException("Found and table counts do not match. " + sceneIdxA + "->" + sceneIdxB + " counts={" + found + "," + tableCounts + "}");
            }
        }
    }

    private int countCommonViews(SceneWorkingGraph sceneA, SceneWorkingGraph sceneB) {
        int commonCount = 0;
        for (int i = 0; i < sceneA.listViews.size(); ++i) {
            PairwiseImageGraph.View va = sceneA.listViews.get((int)i).pview;
            if (-1 == BoofMiscOps.indexOf(sceneB.listViews, v -> v.pview == va)) continue;
            ++commonCount;
        }
        return commonCount;
    }

    public void setVerbose(@Nullable PrintStream out, @Nullable Set<String> configuration) {
        this.verbose = BoofMiscOps.addPrefix((VerbosePrint)this, (PrintStream)out);
        BoofMiscOps.verboseChildren((PrintStream)this.verbose, configuration, (VerbosePrint[])new VerbosePrint[]{this.resolveScale, this.refineSubset});
    }

    public void markAsFailed(SceneWorkingGraph src, SceneWorkingGraph dst) {
        if (src.index > dst.index) {
            SceneWorkingGraph tmp = src;
            src = dst;
            dst = tmp;
        }
        FailedMerged failed = (FailedMerged)this.failedMerges.grow();
        failed.src = src;
        failed.dst = dst;
        failed.viewCountSrc = src.listViews.size();
        failed.viewCountDst = dst.listViews.size();
    }

    public ResolveSceneScaleAmbiguity getResolveScale() {
        return this.resolveScale;
    }

    public RefineMetricGraphSubset getRefineSubset() {
        return this.refineSubset;
    }

    static class SceneCommonCounts {
        public int sceneIndex;
        public int counts;

        SceneCommonCounts() {
        }

        public void reset() {
            this.sceneIndex = -1;
            this.counts = 0;
        }
    }

    public static class SelectedScenes {
        public int sceneA;
        public int sceneB;
    }

    public static class FailedMerged {
        public SceneWorkingGraph src;
        public SceneWorkingGraph dst;
        public int viewCountSrc;
        public int viewCountDst;

        public void reset() {
            this.src = null;
            this.dst = null;
            this.viewCountSrc = -1;
            this.viewCountDst = -1;
        }
    }

    public static class SelectedViews {
        public SceneWorkingGraph.View src;
        public SceneWorkingGraph.View dst;
    }
}

