/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.structure;

import boofcv.alg.geo.bundle.cameras.BundlePinholeSimplified;
import boofcv.alg.structure.PairwiseImageGraph;
import boofcv.misc.BoofMiscOps;
import boofcv.struct.calib.CameraPinhole;
import boofcv.struct.calib.CameraPinholeBrown;
import georegression.struct.point.Point2D_F64;
import georegression.struct.se.Se3_F64;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.TObjectIntMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.ddogleg.struct.DogArray;
import org.ddogleg.struct.DogArray_I32;
import org.ddogleg.struct.FastArray;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.jetbrains.annotations.Nullable;

public class SceneWorkingGraph {
    public final TIntObjectMap<Camera> cameras = new TIntObjectHashMap();
    public final DogArray<Camera> listCameras = new DogArray(Camera::new, Camera::reset);
    public final Map<String, View> views = new HashMap<String, View>();
    public final List<View> listViews = new ArrayList<View>();
    public HashSet<String> exploredViews = new HashSet();
    public int index;
    public FastArray<PairwiseImageGraph.View> open = new FastArray(PairwiseImageGraph.View.class);
    public int numSeedViews;

    public void reset() {
        this.cameras.clear();
        this.listCameras.reset();
        this.views.clear();
        this.listViews.clear();
        this.exploredViews.clear();
        this.index = -1;
        this.open.reset();
        this.numSeedViews = 0;
    }

    public void setTo(SceneWorkingGraph src) {
        Camera c;
        this.reset();
        for (int cameraIdx = 0; cameraIdx < src.listCameras.size; ++cameraIdx) {
            Camera csrc = (Camera)src.listCameras.get(cameraIdx);
            c = (Camera)this.listCameras.grow();
            c.setTo(csrc);
            this.cameras.put(c.indexDB, (Object)c);
        }
        for (int viewIdx = 0; viewIdx < src.listViews.size(); ++viewIdx) {
            View vsrc = src.listViews.get(viewIdx);
            c = this.getViewCamera(vsrc);
            this.addView(vsrc.pview, c).setTo(vsrc);
        }
        this.exploredViews.addAll(src.exploredViews);
        this.index = src.index;
        this.numSeedViews = src.numSeedViews;
        this.open.addAll(src.open);
    }

    public View lookupView(String id) {
        return this.views.get(id);
    }

    public boolean isSeedSet(String id) {
        return this.views.get((Object)id).index < this.numSeedViews;
    }

    public boolean isKnown(PairwiseImageGraph.View pview) {
        return this.views.containsKey(pview.id);
    }

    public Camera addCamera(int indexDB) {
        Camera c = (Camera)this.listCameras.grow();
        c.localIndex = this.listCameras.size - 1;
        c.indexDB = indexDB;
        this.cameras.put(indexDB, (Object)c);
        return c;
    }

    public Camera addCameraCopy(Camera src) {
        Camera c = (Camera)this.listCameras.grow();
        c.localIndex = this.listCameras.size - 1;
        c.indexDB = src.indexDB;
        c.prior.setTo((CameraPinhole)src.prior);
        c.intrinsic.setTo(src.intrinsic);
        this.cameras.put(src.indexDB, (Object)c);
        return c;
    }

    public View addView(PairwiseImageGraph.View pview, Camera camera) {
        View v = new View();
        v.pview = pview;
        v.cameraIdx = camera.localIndex;
        BoofMiscOps.checkTrue((null == this.views.put(v.pview.id, v) ? 1 : 0) != 0, (String)("There shouldn't be an existing view with the same key: '" + v.pview.id + "'"));
        v.index = this.listViews.size();
        this.listViews.add(v);
        return v;
    }

    public List<View> getAllViews() {
        return this.listViews;
    }

    public Camera getViewCamera(View v) {
        return (Camera)this.listCameras.get(v.cameraIdx);
    }

    public TObjectIntMap<String> lookupUsedViewIds(@Nullable TObjectIntMap<String> storage) {
        if (storage == null) {
            storage = new TObjectIntHashMap();
        }
        for (int i = 0; i < this.listViews.size(); ++i) {
            storage.put((Object)this.listViews.get((int)i).pview.id, i);
        }
        return storage;
    }

    public static class Camera {
        public int localIndex;
        public int indexDB;
        public final CameraPinholeBrown prior = new CameraPinholeBrown(2);
        public final BundlePinholeSimplified intrinsic = new BundlePinholeSimplified();

        public void reset() {
            this.localIndex = -1;
            this.indexDB = -1;
            this.prior.reset();
            this.intrinsic.reset();
        }

        public void setTo(Camera src) {
            this.localIndex = src.localIndex;
            this.indexDB = src.indexDB;
            this.prior.setTo((CameraPinhole)src.prior);
            this.intrinsic.setTo(src.intrinsic);
        }
    }

    public static class View {
        public PairwiseImageGraph.View pview;
        public final DogArray<InlierInfo> inliers = new DogArray(InlierInfo::new, InlierInfo::reset);
        public final DMatrixRMaj projective = new DMatrixRMaj(3, 4);
        public final Se3_F64 world_to_view = new Se3_F64();
        public int cameraIdx = -1;
        public int index = -1;

        public double getBestInlierScore() {
            double max = 0.0;
            for (int i = 0; i < this.inliers.size; ++i) {
                max = Math.max(max, ((InlierInfo)this.inliers.get((int)i)).scoreGeometric);
            }
            return max;
        }

        @Nullable
        public InlierInfo getBestInliers() {
            InlierInfo best = null;
            double bestScore = 0.0;
            for (int i = 0; i < this.inliers.size; ++i) {
                InlierInfo info = (InlierInfo)this.inliers.get(i);
                if (!(info.scoreGeometric > bestScore)) continue;
                best = info;
                bestScore = info.scoreGeometric;
            }
            return best;
        }

        public void reset() {
            this.index = -1;
            this.pview = null;
            this.cameraIdx = -1;
            this.projective.zero();
            this.inliers.reset();
            this.world_to_view.reset();
        }

        public void setTo(View src) {
            this.reset();
            this.index = src.index;
            this.pview = src.pview;
            this.cameraIdx = src.cameraIdx;
            this.projective.setTo((DMatrixD1)src.projective);
            this.inliers.resetResize(src.inliers.size);
            for (int i = 0; i < src.inliers.size; ++i) {
                ((InlierInfo)this.inliers.get(i)).setTo((InlierInfo)src.inliers.get(i));
            }
            this.world_to_view.setTo(src.world_to_view);
        }

        public String toString() {
            return "View{id='" + this.pview.id + "' inliers=" + this.inliers.size + "}";
        }
    }

    public static class InlierInfo {
        public final FastArray<PairwiseImageGraph.View> views = new FastArray(PairwiseImageGraph.View.class);
        public final DogArray<DogArray_I32> observations = new DogArray(DogArray_I32::new, DogArray_I32::reset);
        public double scoreGeometric;

        public boolean isEmpty() {
            return this.observations.size == 0;
        }

        public int getInlierCount() {
            return ((DogArray_I32)this.observations.get((int)0)).size;
        }

        public void setTo(InlierInfo src) {
            this.reset();
            this.views.addAll(src.views);
            this.observations.resize(src.observations.size);
            for (int i = 0; i < src.observations.size; ++i) {
                ((DogArray_I32)this.observations.get(i)).setTo((DogArray_I32)src.observations.get(i));
            }
            this.scoreGeometric = src.scoreGeometric;
        }

        public void reset() {
            this.views.reset();
            this.observations.reset();
            this.scoreGeometric = 0.0;
        }

        public String toString() {
            return String.format("InlierInfo {views.size=%d, score=%.1f}", this.views.size, this.scoreGeometric);
        }
    }

    public static class Observation {
        public View view;
        public int observationIdx;
        public final Point2D_F64 pixel = new Point2D_F64();

        public Observation() {
        }

        public Observation(View view, int observationIdx) {
            this.view = view;
            this.observationIdx = observationIdx;
        }

        public void reset() {
            this.view = null;
            this.observationIdx = -1;
            this.pixel.setTo(Double.NaN, Double.NaN);
        }
    }
}

