/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.structure;

import boofcv.abst.geo.Estimate1ofTrifocalTensor;
import boofcv.abst.geo.RefineThreeViewProjective;
import boofcv.abst.geo.bundle.BundleAdjustment;
import boofcv.abst.geo.bundle.BundleAdjustmentCamera;
import boofcv.abst.geo.bundle.PruneStructureFromSceneMetric;
import boofcv.abst.geo.bundle.SceneObservations;
import boofcv.abst.geo.bundle.SceneStructure;
import boofcv.abst.geo.bundle.SceneStructureCommon;
import boofcv.abst.geo.bundle.SceneStructureMetric;
import boofcv.abst.geo.selfcalib.ProjectiveToMetricCameras;
import boofcv.alg.geo.MetricCameras;
import boofcv.alg.geo.MultiViewOps;
import boofcv.alg.geo.PerspectiveOps;
import boofcv.alg.geo.bundle.cameras.BundlePinholeSimplified;
import boofcv.alg.geo.selfcalib.TwoViewToCalibratingHomography;
import boofcv.factory.geo.ConfigBundleAdjustment;
import boofcv.factory.geo.ConfigRansac;
import boofcv.factory.geo.ConfigSelfCalibDualQuadratic;
import boofcv.factory.geo.ConfigTrifocal;
import boofcv.factory.geo.ConfigTrifocalError;
import boofcv.factory.geo.EnumTrifocal;
import boofcv.factory.geo.FactoryMultiView;
import boofcv.factory.geo.FactoryMultiViewRobust;
import boofcv.misc.ConfigConverge;
import boofcv.struct.calib.CameraPinhole;
import boofcv.struct.calib.ElevateViewInfo;
import boofcv.struct.geo.AssociatedPair;
import boofcv.struct.geo.AssociatedTriple;
import boofcv.struct.geo.AssociatedTupleN;
import boofcv.struct.geo.TrifocalTensor;
import georegression.geometry.ConvertRotation3D_F64;
import georegression.struct.point.Point3D_F64;
import georegression.struct.se.Se3_F64;
import georegression.struct.so.Rodrigues_F64;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.ddogleg.fitting.modelset.ransac.Ransac;
import org.ddogleg.optimization.lm.ConfigLevenbergMarquardt;
import org.ddogleg.struct.DogArray;
import org.ddogleg.struct.VerbosePrint;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import org.jetbrains.annotations.Nullable;

public class ThreeViewEstimateMetricScene
implements VerbosePrint {
    public ConfigRansac configRansac = new ConfigRansac();
    public ConfigTrifocal configTriRansac = new ConfigTrifocal();
    public ConfigTrifocal configTriFit = new ConfigTrifocal();
    public ConfigTrifocalError configError = new ConfigTrifocalError();
    public ConfigLevenbergMarquardt configLM = new ConfigLevenbergMarquardt();
    public ConfigBundleAdjustment configSBA = new ConfigBundleAdjustment();
    public ConfigConverge convergeSBA = new ConfigConverge(1.0E-6, 1.0E-6, 100);
    public Ransac<TrifocalTensor, AssociatedTriple> ransac;
    public List<AssociatedTriple> inliers;
    public Estimate1ofTrifocalTensor trifocalEstimator;
    private PrintStream verbose;
    protected DMatrixRMaj P1 = CommonOps_DDRM.identity((int)3, (int)4);
    protected DMatrixRMaj P2 = new DMatrixRMaj(3, 4);
    protected DMatrixRMaj P3 = new DMatrixRMaj(3, 4);
    public final List<CameraPinhole> listPinhole = new ArrayList<CameraPinhole>();
    public BundleAdjustment<SceneStructureMetric> bundleAdjustment;
    public SceneStructureMetric structure;
    public SceneObservations observations;
    public double manualFocalLength = -1.0;
    public double pruneFraction = 0.7;
    private int width;
    private int height;
    protected List<Se3_F64> listWorldToView = new ArrayList<Se3_F64>();

    public ThreeViewEstimateMetricScene() {
        this.configRansac.iterations = 500;
        this.configRansac.inlierThreshold = 1.0;
        this.configError.model = ConfigTrifocalError.Model.REPROJECTION_REFINE;
        this.configTriFit.which = EnumTrifocal.ALGEBRAIC_7;
        this.configTriFit.converge.maxIterations = 100;
        this.configLM.dampeningInitial = 0.001;
        this.configLM.hessianScaling = false;
        this.configSBA.configOptimizer = this.configLM;
        for (int i = 0; i < 3; ++i) {
            this.listWorldToView.add(new Se3_F64());
        }
    }

    public boolean process(List<AssociatedTriple> associated, int width, int height) {
        this.init(width, height);
        if (!this.robustFitTrifocal(associated)) {
            return false;
        }
        if (!this.estimateProjectiveScene()) {
            return false;
        }
        if (!this.projectiveToMetric()) {
            return false;
        }
        this.setupMetricBundleAdjustment(this.inliers);
        this.bundleAdjustment = FactoryMultiView.bundleSparseMetric((ConfigBundleAdjustment)this.configSBA);
        this.findBestValidSolution(this.bundleAdjustment);
        this.pruneOutliers(this.bundleAdjustment);
        return true;
    }

    private void init(int width, int height) {
        this.width = width;
        this.height = height;
        this.ransac = FactoryMultiViewRobust.trifocalRansac((ConfigTrifocal)this.configTriRansac, (ConfigTrifocalError)this.configError, (ConfigRansac)this.configRansac);
        this.trifocalEstimator = FactoryMultiView.trifocal_1((ConfigTrifocal)this.configTriFit);
        this.structure = null;
        this.observations = null;
    }

    private boolean robustFitTrifocal(List<AssociatedTriple> associated) {
        this.ransac.process(associated);
        this.inliers = this.ransac.getMatchSet();
        TrifocalTensor model = (TrifocalTensor)this.ransac.getModelParameters();
        if (this.verbose != null) {
            this.verbose.println("Remaining after RANSAC " + this.inliers.size() + " / " + associated.size());
        }
        if (!this.trifocalEstimator.process(this.inliers, (Object)model)) {
            if (this.verbose != null) {
                this.verbose.println("Trifocal estimator failed");
            }
            return false;
        }
        return true;
    }

    private void pruneOutliers(BundleAdjustment<SceneStructureMetric> bundleAdjustment) {
        if (this.pruneFraction == 1.0) {
            return;
        }
        if (this.verbose != null) {
            this.verbose.println("Pruning Outliers");
        }
        PruneStructureFromSceneMetric pruner = new PruneStructureFromSceneMetric(this.structure, this.observations);
        pruner.pruneObservationsByErrorRank(this.pruneFraction);
        pruner.pruneViews(10);
        pruner.pruneUnusedMotions();
        pruner.prunePoints(1);
        bundleAdjustment.setParameters((SceneStructure)this.structure, this.observations);
        double before = bundleAdjustment.getFitScore();
        bundleAdjustment.optimize((SceneStructure)this.structure);
        if (this.verbose != null) {
            this.verbose.println("   before " + before + " after " + bundleAdjustment.getFitScore());
        }
        if (this.verbose != null) {
            int i;
            this.verbose.println("\nCamera");
            for (i = 0; i < this.structure.cameras.size; ++i) {
                this.verbose.println("  " + ((SceneStructureCommon.Camera[])this.structure.cameras.data)[i].getModel().toString());
            }
            this.verbose.println("\nworldToView");
            for (i = 0; i < this.structure.views.size; ++i) {
                if (this.verbose == null) continue;
                Se3_F64 se = this.structure.getParentToView(i);
                Rodrigues_F64 rod = ConvertRotation3D_F64.matrixToRodrigues((DMatrixRMaj)se.R, null);
                this.verbose.println("  T=" + se.T + "  R=" + rod);
            }
        }
    }

    private void findBestValidSolution(BundleAdjustment<SceneStructureMetric> bundleAdjustment) {
        BundlePinholeSimplified c;
        int i;
        bundleAdjustment.configure(this.convergeSBA.ftol, this.convergeSBA.gtol, this.convergeSBA.maxIterations);
        bundleAdjustment.setParameters((SceneStructure)this.structure, this.observations);
        bundleAdjustment.optimize((SceneStructure)this.structure);
        if (this.checkBehindCamera(this.structure)) {
            if (this.verbose != null) {
                this.verbose.println("  #1 Points Behind. Flipping view");
            }
            ThreeViewEstimateMetricScene.flipAround(this.structure, this.observations);
            bundleAdjustment.setParameters((SceneStructure)this.structure, this.observations);
            bundleAdjustment.optimize((SceneStructure)this.structure);
        }
        double bestScore = bundleAdjustment.getFitScore();
        if (this.verbose != null) {
            this.verbose.println("First Pass: SBA score " + bestScore);
        }
        ArrayList<Se3_F64> bestPose = new ArrayList<Se3_F64>();
        ArrayList<BundlePinholeSimplified> bestCameras = new ArrayList<BundlePinholeSimplified>();
        for (i = 0; i < this.structure.views.size; ++i) {
            c = (BundlePinholeSimplified)((SceneStructureCommon.Camera[])this.structure.cameras.data)[i].getModel();
            bestPose.add(this.structure.getParentToView(i).copy());
            bestCameras.add(c.copy());
        }
        for (i = 0; i < this.structure.cameras.size; ++i) {
            c = (BundlePinholeSimplified)((SceneStructureCommon.Camera[])this.structure.cameras.data)[i].getModel();
            c.f = this.listPinhole.get((int)i).fx;
            c.k2 = 0.0;
            c.k1 = 0.0;
        }
        for (i = 1; i < this.structure.views.size; ++i) {
            CommonOps_DDRM.transpose((DMatrixRMaj)this.structure.getParentToView((int)i).R);
        }
        MultiViewOps.triangulatePoints((SceneStructureMetric)this.structure, (SceneObservations)this.observations);
        bundleAdjustment.setParameters((SceneStructure)this.structure, this.observations);
        bundleAdjustment.optimize((SceneStructure)this.structure);
        if (this.checkBehindCamera(this.structure)) {
            if (this.verbose != null) {
                this.verbose.println("  #2 Points Behind. Flipping view");
            }
            ThreeViewEstimateMetricScene.flipAround(this.structure, this.observations);
            bundleAdjustment.setParameters((SceneStructure)this.structure, this.observations);
            bundleAdjustment.optimize((SceneStructure)this.structure);
        }
        if (this.verbose != null) {
            this.verbose.println(" First Pass / Transpose(R) = " + bestScore + " / " + bundleAdjustment.getFitScore());
        }
        if (bundleAdjustment.getFitScore() > bestScore) {
            if (this.verbose != null) {
                this.verbose.println("  recomputing old structure");
            }
            for (i = 0; i < this.structure.cameras.size; ++i) {
                c = (BundlePinholeSimplified)((SceneStructureCommon.Camera[])this.structure.cameras.data)[i].getModel();
                c.setTo((BundlePinholeSimplified)bestCameras.get(i));
                this.structure.getParentToView(i).setTo((Se3_F64)bestPose.get(i));
            }
            MultiViewOps.triangulatePoints((SceneStructureMetric)this.structure, (SceneObservations)this.observations);
            bundleAdjustment.setParameters((SceneStructure)this.structure, this.observations);
            bundleAdjustment.optimize((SceneStructure)this.structure);
            if (this.verbose != null) {
                this.verbose.println("  score after reverting = " + bundleAdjustment.getFitScore() + "  original " + bestScore);
            }
        }
    }

    private boolean estimateProjectiveScene() {
        List inliers = this.ransac.getMatchSet();
        TrifocalTensor model = (TrifocalTensor)this.ransac.getModelParameters();
        MultiViewOps.trifocalToCameraMatrices((TrifocalTensor)model, (DMatrixRMaj)this.P2, (DMatrixRMaj)this.P3);
        RefineThreeViewProjective refineP23 = FactoryMultiView.threeViewRefine(null);
        if (!refineP23.process(inliers, this.P2, this.P3, this.P2, this.P3)) {
            if (this.verbose != null) {
                this.verbose.println("Can't refine P2 and P3!");
            }
            return false;
        }
        return true;
    }

    private void setupMetricBundleAdjustment(List<AssociatedTriple> inliers) {
        int i;
        this.structure = new SceneStructureMetric(false);
        this.structure.initialize(3, 3, inliers.size());
        this.observations = new SceneObservations();
        this.observations.initialize(3);
        for (i = 0; i < this.listPinhole.size(); ++i) {
            CameraPinhole cp = this.listPinhole.get(i);
            BundlePinholeSimplified bp = new BundlePinholeSimplified();
            bp.f = cp.fx;
            this.structure.setCamera(i, false, (BundleAdjustmentCamera)bp);
            this.structure.setView(i, i, i == 0, this.listWorldToView.get(i));
        }
        for (i = 0; i < inliers.size(); ++i) {
            AssociatedTriple t = inliers.get(i);
            this.observations.getView(0).add(i, (float)t.p1.x, (float)t.p1.y);
            this.observations.getView(1).add(i, (float)t.p2.x, (float)t.p2.y);
            this.observations.getView(2).add(i, (float)t.p3.x, (float)t.p3.y);
            this.structure.connectPointToView(i, 0);
            this.structure.connectPointToView(i, 1);
            this.structure.connectPointToView(i, 2);
        }
        MultiViewOps.triangulatePoints((SceneStructureMetric)this.structure, (SceneObservations)this.observations);
    }

    boolean projectiveToMetric() {
        Se3_F64 world_to_view;
        int i;
        this.listPinhole.clear();
        boolean successfulSelfCalibration = false;
        if (this.manualFocalLength <= 0.0) {
            ConfigSelfCalibDualQuadratic config = new ConfigSelfCalibDualQuadratic();
            ProjectiveToMetricCameras selfcalib = FactoryMultiView.projectiveToMetric((ConfigSelfCalibDualQuadratic)config);
            ArrayList<ElevateViewInfo> views = new ArrayList<ElevateViewInfo>();
            for (int i2 = 0; i2 < 3; ++i2) {
                views.add(new ElevateViewInfo(this.width, this.height, i2));
            }
            ArrayList<DMatrixRMaj> cameras = new ArrayList<DMatrixRMaj>();
            cameras.add(this.P2);
            cameras.add(this.P3);
            DogArray observations = new DogArray(() -> new AssociatedTupleN(3));
            MultiViewOps.convertTr((List)this.ransac.getMatchSet(), (DogArray)observations);
            MetricCameras results = new MetricCameras();
            boolean success = selfcalib.process(views, cameras, observations.toList(), results);
            if (success) {
                successfulSelfCalibration = true;
                this.listPinhole.addAll(results.intrinsics.toList());
                this.listWorldToView.get(0).reset();
                this.listWorldToView.get(1).setTo((Se3_F64)results.motion_1_to_k.get(0));
                this.listWorldToView.get(2).setTo((Se3_F64)results.motion_1_to_k.get(1));
                if (this.verbose != null) {
                    this.verbose.println("Auto calibration success");
                }
            } else if (this.verbose != null) {
                this.verbose.println("Auto calibration failed");
            }
        }
        if (!successfulSelfCalibration) {
            double focalLength;
            double d = focalLength = this.manualFocalLength <= 0.0 ? (double)(Math.max(this.width, this.height) / 2) : this.manualFocalLength;
            if (this.verbose != null) {
                this.verbose.println("Assuming fixed focal length for all views. f=" + focalLength);
            }
            TwoViewToCalibratingHomography estimateH = new TwoViewToCalibratingHomography();
            DMatrixRMaj F21 = MultiViewOps.projectiveToFundamental((DMatrixRMaj)this.P2, null);
            estimateH.initialize(F21, this.P2);
            DMatrixRMaj K = PerspectiveOps.pinholeToMatrix((double)focalLength, (double)focalLength, (double)0.0, (double)0.0, (double)0.0);
            DogArray pairs = new DogArray(AssociatedPair::new);
            MultiViewOps.convertTr((List)this.ransac.getMatchSet(), (int)0, (int)1, (DogArray)pairs);
            if (!estimateH.process(K, K, pairs.toList())) {
                throw new RuntimeException("Failed to estimate H given 'known' intrinsics");
            }
            DMatrixRMaj H = estimateH.getCalibrationHomography();
            this.listPinhole.clear();
            for (int i3 = 0; i3 < 3; ++i3) {
                this.listPinhole.add(PerspectiveOps.matrixToPinhole((DMatrixRMaj)K, (int)this.width, (int)this.height, null));
            }
            this.listWorldToView.get(0).reset();
            MultiViewOps.projectiveToMetric((DMatrixRMaj)this.P2, (DMatrixRMaj)H, (Se3_F64)this.listWorldToView.get(1), (DMatrixRMaj)K);
            MultiViewOps.projectiveToMetric((DMatrixRMaj)this.P3, (DMatrixRMaj)H, (Se3_F64)this.listWorldToView.get(2), (DMatrixRMaj)K);
        }
        if (this.verbose != null) {
            this.verbose.println("Initial Intrinsic Estimate:");
            for (int i4 = 0; i4 < 3; ++i4) {
                CameraPinhole r = this.listPinhole.get(i4);
                this.verbose.printf("  fx = %6.1f, fy = %6.1f, skew = %6.3f\n", r.fx, r.fy, r.skew);
            }
            this.verbose.println("Initial Motion Estimate:");
        }
        double maxT = 0.0;
        for (i = 0; i < this.listWorldToView.size(); ++i) {
            world_to_view = this.listWorldToView.get(i);
            maxT = Math.max(maxT, world_to_view.T.norm());
        }
        for (i = 0; i < this.listWorldToView.size(); ++i) {
            world_to_view = this.listWorldToView.get(i);
            world_to_view.T.scale(1.0 / maxT);
            if (this.verbose == null) continue;
            Rodrigues_F64 rod = ConvertRotation3D_F64.matrixToRodrigues((DMatrixRMaj)world_to_view.R, null);
            this.verbose.println("  T=" + world_to_view.T + "  R=" + rod);
        }
        return true;
    }

    private boolean checkBehindCamera(SceneStructureMetric structure) {
        int totalBehind = 0;
        Point3D_F64 X = new Point3D_F64();
        for (int i = 0; i < structure.points.size; ++i) {
            ((SceneStructureCommon.Point[])structure.points.data)[i].get(X);
            if (!(X.z < 0.0)) continue;
            ++totalBehind;
        }
        if (this.verbose != null) {
            this.verbose.println("points behind " + totalBehind + " / " + structure.points.size);
        }
        return totalBehind > structure.points.size / 2;
    }

    private static void flipAround(SceneStructureMetric structure, SceneObservations observations) {
        for (int i = 1; i < structure.views.size; ++i) {
            Se3_F64 w2v = structure.getParentToView(i);
            w2v.setTo(w2v.invert(null));
        }
        MultiViewOps.triangulatePoints((SceneStructureMetric)structure, (SceneObservations)observations);
    }

    public SceneStructureMetric getStructure() {
        return this.structure;
    }

    public void setVerbose(@Nullable PrintStream out, @Nullable Set<String> configuration) {
        this.verbose = out;
    }
}

