/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.structure.score3d;

import boofcv.alg.geo.MultiViewOps;
import boofcv.alg.geo.robust.DistanceFundamentalGeometric;
import boofcv.alg.geo.robust.GenerateHomographyLinear;
import boofcv.alg.structure.EpipolarScore3D;
import boofcv.misc.BoofMiscOps;
import boofcv.struct.ConfigLength;
import boofcv.struct.calib.CameraPinholeBrown;
import boofcv.struct.geo.AssociatedPair;
import georegression.geometry.GeometryMath_F64;
import georegression.struct.GeoTuple3D_F64;
import georegression.struct.homography.Homography2D_F64;
import georegression.struct.homography.UtilHomography_F64;
import georegression.struct.point.Point3D_F64;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.ddogleg.fitting.modelset.ModelMatcher;
import org.ddogleg.struct.DogArray_I32;
import org.ddogleg.struct.VerbosePrint;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.jetbrains.annotations.Nullable;

public class ScoreFundamentalHomographyCompatibility
implements EpipolarScore3D {
    ModelMatcher<DMatrixRMaj, AssociatedPair> ransac3D;
    public double ratio3D = 1.5;
    public double maxRatioScore = 5.0;
    public final ConfigLength minimumInliers = ConfigLength.fixed((double)30.0);
    public double inlierErrorTol = 1.0;
    List<AssociatedPair> inliers = new ArrayList<AssociatedPair>();
    GenerateHomographyLinear estimateH = new GenerateHomographyLinear(true);
    DistanceFundamentalGeometric distanceF = new DistanceFundamentalGeometric();
    DMatrixRMaj H = new DMatrixRMaj(3, 3);
    Homography2D_F64 H2 = new Homography2D_F64();
    double score;
    boolean is3D;
    PrintStream verbose;
    Point3D_F64 e1 = new Point3D_F64();
    Point3D_F64 e2 = new Point3D_F64();
    DMatrixRMaj F_alt = new DMatrixRMaj(3, 3);

    public ScoreFundamentalHomographyCompatibility(ModelMatcher<DMatrixRMaj, AssociatedPair> ransac3D) {
        this.ransac3D = ransac3D;
    }

    @Override
    public void process(CameraPinholeBrown cameraA, @Nullable CameraPinholeBrown cameraB, int featuresA, int featuresB, List<AssociatedPair> pairs, DMatrixRMaj fundamental, DogArray_I32 inliersIdx) {
        this.is3D = false;
        this.score = 0.0;
        if (pairs.size() < this.ransac3D.getMinimumSize()) {
            if (this.verbose != null) {
                this.verbose.printf("pairs.size=%d less than ransac3D.getMinimumSize()\n", pairs.size());
            }
            return;
        }
        int minimumAllowed = this.minimumInliers.computeI((double)pairs.size());
        if (pairs.size() < minimumAllowed) {
            if (this.verbose != null) {
                this.verbose.printf("REJECTED: pairs.size=%d < minimum.size=%d\n", pairs.size(), minimumAllowed);
            }
            return;
        }
        if (!this.ransac3D.process(pairs)) {
            this.is3D = false;
            this.score = 0.0;
            if (this.verbose != null) {
                this.verbose.println("ransac failed. not 3D");
            }
            return;
        }
        if (this.ransac3D.getMatchSet().size() < minimumAllowed) {
            if (this.verbose != null) {
                this.verbose.printf("REJECTED: pairs.size=%d inlier.size=%d < minimum.size=%d\n", pairs.size(), this.ransac3D.getMatchSet().size(), minimumAllowed);
            }
            return;
        }
        fundamental.setTo((DMatrixD1)this.ransac3D.getModelParameters());
        inliersIdx.resize(this.ransac3D.getMatchSet().size());
        this.inliers.clear();
        for (int i = 0; i < inliersIdx.size; ++i) {
            inliersIdx.set(i, this.ransac3D.getInputIndex(i));
            this.inliers.add(pairs.get(inliersIdx.get(i)));
        }
        int fitModelF = this.countFitModel((DMatrixRMaj)this.ransac3D.getModelParameters());
        this.estimateH.generate(this.inliers, this.H2);
        UtilHomography_F64.convert((Homography2D_F64)this.H2, (DMatrixRMaj)this.H);
        MultiViewOps.extractEpipoles((DMatrixRMaj)fundamental, (Point3D_F64)this.e1, (Point3D_F64)this.e2);
        GeometryMath_F64.multCrossA((GeoTuple3D_F64)this.e2, (DMatrixRMaj)this.H, (DMatrixRMaj)this.F_alt);
        int fitModelH = this.countFitModel(this.F_alt) + 1;
        this.is3D = (double)fitModelH * this.ratio3D <= (double)fitModelF;
        double ratio = (double)fitModelF / (double)fitModelH;
        this.score = Math.min(this.maxRatioScore, ratio) * (double)inliersIdx.size / 200.0;
        if (this.verbose != null) {
            this.verbose.printf("score=%7.2f pairs=%d inliers=%d ratio=%6.2f fitH=%4d fitF=%4d 3d=%s\n", this.score, pairs.size(), inliersIdx.size, ratio, fitModelH, fitModelF, this.is3D);
        }
    }

    private int countFitModel(DMatrixRMaj fundamental) {
        this.distanceF.setModel(fundamental);
        int total = 0;
        double threshold = this.inlierErrorTol * this.inlierErrorTol * 2.0;
        for (int i = 0; i < this.inliers.size(); ++i) {
            double doubleDistanceSq = this.distanceF.distance(this.inliers.get(i));
            if (!(doubleDistanceSq <= threshold)) continue;
            ++total;
        }
        return total;
    }

    @Override
    public double getScore() {
        return this.score;
    }

    @Override
    public boolean is3D() {
        return this.is3D;
    }

    public void setVerbose(@Nullable PrintStream out, @Nullable Set<String> param) {
        this.verbose = BoofMiscOps.addPrefix((VerbosePrint)this, (PrintStream)out);
    }

    public ModelMatcher<DMatrixRMaj, AssociatedPair> getRansac3D() {
        return this.ransac3D;
    }

    public double getRatio3D() {
        return this.ratio3D;
    }

    public void setRatio3D(double ratio3D) {
        this.ratio3D = ratio3D;
    }

    public double getMaxRatioScore() {
        return this.maxRatioScore;
    }

    public void setMaxRatioScore(double maxRatioScore) {
        this.maxRatioScore = maxRatioScore;
    }

    public ConfigLength getMinimumInliers() {
        return this.minimumInliers;
    }

    public double getInlierErrorTol() {
        return this.inlierErrorTol;
    }

    public void setInlierErrorTol(double inlierErrorTol) {
        this.inlierErrorTol = inlierErrorTol;
    }
}

