/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.structure.expand;

import boofcv.abst.geo.Triangulate2ViewsMetricH;
import boofcv.abst.geo.bundle.SceneStructureMetric;
import boofcv.alg.distort.brown.RemoveBrownPtoN_F64;
import boofcv.alg.geo.robust.ModelMatcherMultiview;
import boofcv.alg.structure.PairwiseGraphUtils;
import boofcv.alg.structure.SceneWorkingGraph;
import boofcv.alg.structure.expand.EstimateViewUtils;
import boofcv.alg.structure.expand.MetricExpandByOneView;
import boofcv.factory.geo.ConfigPnP;
import boofcv.factory.geo.ConfigRansac;
import boofcv.factory.geo.ConfigTriangulation;
import boofcv.factory.geo.FactoryMultiView;
import boofcv.factory.geo.FactoryMultiViewRobust;
import boofcv.misc.BoofMiscOps;
import boofcv.struct.ConfigLength;
import boofcv.struct.calib.CameraPinhole;
import boofcv.struct.geo.AssociatedTriple;
import boofcv.struct.geo.Point2D3D;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point4D_F64;
import georegression.struct.se.Se3_F64;
import java.io.PrintStream;
import java.util.List;
import java.util.Set;
import org.ddogleg.struct.DogArray;
import org.ddogleg.struct.DogArray_I32;
import org.ddogleg.struct.VerbosePrint;
import org.jetbrains.annotations.Nullable;

public class EstimateViewKnownCalibration
implements VerbosePrint {
    PairwiseGraphUtils pairwiseUtils;
    SceneWorkingGraph workGraph;
    public double fractionBadFeaturesRecover = 0.05;
    public ConfigLength minimumInliers = ConfigLength.relative((double)0.5, (double)50.0);
    public final EstimateViewUtils estimateUtils = new EstimateViewUtils();
    public Triangulate2ViewsMetricH triangulate2;
    public ModelMatcherMultiview<Se3_F64, Point2D3D> ransacPnP;
    final DogArray<RemoveBrownPtoN_F64> listPixelToNorm = new DogArray(RemoveBrownPtoN_F64::new);
    final DogArray<Point2D3D> list2D3D = new DogArray(Point2D3D::new);
    public final DogArray_I32 inputPnP_to_inliersThreeView = new DogArray_I32();
    public final CameraPinhole pinhole = new CameraPinhole();
    final Point2D_F64 norm1 = new Point2D_F64();
    final Point2D_F64 norm2 = new Point2D_F64();
    final Point2D_F64 norm3 = new Point2D_F64();
    final Point4D_F64 X = new Point4D_F64();
    @Nullable
    PrintStream verbose;

    public EstimateViewKnownCalibration() {
        this.defaultConfiguration();
    }

    public void defaultConfiguration() {
        ConfigTriangulation configTriangulate = new ConfigTriangulation();
        ConfigPnP configPnP = new ConfigPnP();
        ConfigRansac configRansac = new ConfigRansac();
        configRansac.iterations = 500;
        configRansac.inlierThreshold = 1.5;
        configTriangulate.type = ConfigTriangulation.Type.GEOMETRIC;
        this.configure(configTriangulate, configPnP, configRansac);
    }

    public void configure(ConfigTriangulation configTriangulate, ConfigPnP configPnP, ConfigRansac configRansac) {
        this.triangulate2 = FactoryMultiView.triangulate2ViewMetricH((ConfigTriangulation)configTriangulate);
        this.ransacPnP = FactoryMultiViewRobust.pnpRansac((ConfigPnP)configPnP, (ConfigRansac)configRansac);
    }

    public boolean process(PairwiseGraphUtils pairwiseUtils, SceneWorkingGraph workGraph, MetricExpandByOneView.Solution solution) {
        this.pairwiseUtils = pairwiseUtils;
        this.workGraph = workGraph;
        solution.reset();
        this.estimateUtils.initialize(true, workGraph, pairwiseUtils);
        if (!this.estimateViewPose()) {
            return false;
        }
        if (!this.refineWithBundleAdjustment()) {
            if (this.verbose != null) {
                this.verbose.println("SBA failed");
            }
            return false;
        }
        if (!this.removedBadFeatures()) {
            if (this.verbose != null) {
                this.verbose.println("Too many bad features");
            }
            return false;
        }
        if (!this.checkEnoughRemainingInliers()) {
            return false;
        }
        this.estimateUtils.copyToSolution(pairwiseUtils, solution);
        return true;
    }

    boolean estimateViewPose() {
        this.triangulateForPnP();
        this.pinhole.fsetK(this.estimateUtils.camera3.f, this.estimateUtils.camera3.f, 0.0, 0.0, 0.0, 0, 0);
        this.ransacPnP.setIntrinsic(0, this.pinhole);
        if (!this.ransacPnP.process(this.list2D3D.toList())) {
            if (this.verbose != null) {
                this.verbose.println("PNP RANSAC failed");
            }
            return false;
        }
        this.estimateUtils.view1_to_target.setTo((Se3_F64)this.ransacPnP.getModelParameters());
        List inliersPnP = this.ransacPnP.getMatchSet();
        this.estimateUtils.usedThreeViewInliers.resize(inliersPnP.size());
        for (int inlierCnt = 0; inlierCnt < inliersPnP.size(); ++inlierCnt) {
            this.estimateUtils.usedThreeViewInliers.set(inlierCnt, this.inputPnP_to_inliersThreeView.get(this.ransacPnP.getInputIndex(inlierCnt)));
        }
        if (this.verbose != null) {
            Se3_F64 view_1_to_2 = this.estimateUtils.view1_to_view2;
            Se3_F64 view_1_to_3 = this.estimateUtils.view1_to_target;
            this.verbose.printf("inliersPNP.size=%d inliersTri.size=%d common.size=%d\n", inliersPnP.size(), this.pairwiseUtils.inliersThreeView.size, this.pairwiseUtils.commonIdx.size);
            this.verbose.printf("local   1_to_2 T=(%.2f %.2f %.2f)\n", view_1_to_2.T.x, view_1_to_2.T.y, view_1_to_2.T.z);
            this.verbose.printf("local   1_to_3 T=(%.2f %.2f %.2f)\n", view_1_to_3.T.x, view_1_to_3.T.y, view_1_to_3.T.z);
        }
        return true;
    }

    private void triangulateForPnP() {
        this.list2D3D.reset();
        this.inputPnP_to_inliersThreeView.reset();
        this.listPixelToNorm.resetResize(3);
        for (int tripleCnt = 0; tripleCnt < this.pairwiseUtils.inliersThreeView.size; ++tripleCnt) {
            AssociatedTriple triple = (AssociatedTriple)this.pairwiseUtils.inliersThreeView.get(tripleCnt);
            this.estimateUtils.normalize1.compute(triple.p1.x, triple.p1.y, this.norm1);
            this.estimateUtils.normalize2.compute(triple.p2.x, triple.p2.y, this.norm2);
            this.triangulate2.triangulate(this.norm1, this.norm2, this.estimateUtils.view1_to_view2, this.X);
            if (this.X.w * this.X.z <= 0.0) continue;
            this.inputPnP_to_inliersThreeView.add(tripleCnt);
            this.estimateUtils.normalize3.compute(triple.p3.x, triple.p3.y, this.norm3);
            ((Point2D3D)this.list2D3D.grow()).setTo(this.norm3.x, this.norm3.y, this.X.x / this.X.w, this.X.y / this.X.w, this.X.z / this.X.w);
        }
    }

    private boolean refineWithBundleAdjustment() {
        this.estimateUtils.configureSbaStructure(this.pairwiseUtils.inliersThreeView.toList());
        ((SceneStructureMetric.Motion)this.estimateUtils.metricSba.structure.motions.get((int)2)).known = false;
        return this.estimateUtils.performBundleAdjustment(this.verbose);
    }

    boolean removedBadFeatures() {
        EstimateViewUtils.RemoveResults results = this.estimateUtils.removedBadFeatures(this.pairwiseUtils, this.fractionBadFeaturesRecover, this.verbose);
        if (results == EstimateViewUtils.RemoveResults.FAILED) {
            return false;
        }
        if (results == EstimateViewUtils.RemoveResults.GOOD) {
            return true;
        }
        if (this.verbose != null) {
            this.verbose.println("Removed bad features. Optimizing again.");
        }
        if (!this.refineWithBundleAdjustment()) {
            return false;
        }
        return this.estimateUtils.verifyPhysicalConstraints(0.0, this.verbose);
    }

    private boolean checkEnoughRemainingInliers() {
        int numMatches = this.estimateUtils.usedThreeViewInliers.size();
        if (numMatches < this.minimumInliers.computeI((double)this.pairwiseUtils.commonIdx.size)) {
            if (this.verbose != null) {
                this.verbose.printf("Rejected: matches.size=%d / common.size=%d\n", numMatches, this.pairwiseUtils.commonIdx.size);
            }
            return false;
        }
        return true;
    }

    public void setVerbose(@Nullable PrintStream out, @Nullable Set<String> configuration) {
        this.verbose = BoofMiscOps.addPrefix((VerbosePrint)this, (PrintStream)out);
        BoofMiscOps.verboseChildren((PrintStream)this.verbose, configuration, (VerbosePrint[])new VerbosePrint[]{this.estimateUtils.checks, this.estimateUtils.metricSba});
    }
}

