/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.structure;

import boofcv.abst.geo.bundle.MetricBundleAdjustmentUtils;
import boofcv.abst.geo.bundle.SceneStructureCommon;
import boofcv.abst.geo.bundle.SceneStructureMetric;
import boofcv.alg.structure.LookUpSimilarImages;
import boofcv.alg.structure.PairwiseImageGraph;
import boofcv.alg.structure.RefineMetricWorkingGraph;
import boofcv.alg.structure.SceneWorkingGraph;
import boofcv.misc.BoofMiscOps;
import boofcv.struct.calib.CameraPinholeBrown;
import georegression.struct.se.Se3_F64;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.ddogleg.struct.DogArray_B;
import org.ddogleg.struct.DogArray_I32;
import org.ddogleg.struct.VerbosePrint;
import org.jetbrains.annotations.Nullable;

public class RefineMetricGraphSubset
implements VerbosePrint {
    RefineMetricWorkingGraph refiner = new RefineMetricWorkingGraph();
    SceneWorkingGraph subgraph = new SceneWorkingGraph();
    Map<String, SceneWorkingGraph.View> srcToCpy = new HashMap<String, SceneWorkingGraph.View>();
    DogArray_B viewsFixed = new DogArray_B();
    DogArray_B camerasFixed = new DogArray_B();
    final List<SceneWorkingGraph.View> srcViews = new ArrayList<SceneWorkingGraph.View>();
    Se3_F64 local_to_world = new Se3_F64();
    Se3_F64 world_to_local = new Se3_F64();
    double scaleLocalToWorld;
    @Nullable
    PrintStream verbose;
    List<CameraPinholeBrown> cameraPriors = new ArrayList<CameraPinholeBrown>();
    Se3_F64 tmp = new Se3_F64();

    public RefineMetricGraphSubset() {
        this.refiner.verboseViewInfo = false;
    }

    public void setSubset(SceneWorkingGraph src, List<SceneWorkingGraph.View> srcViews) {
        this.cameraPriors.clear();
        this.srcViews.clear();
        this.srcViews.addAll(srcViews);
        this.copySubGraph(src, srcViews);
        this.rescaleLocalCoordinateSystem();
        if (this.verbose != null) {
            this.verbose.printf("subviews.size=%d subgraph.size=%d scale=%.2e\n", srcViews.size(), this.subgraph.listViews.size(), this.scaleLocalToWorld);
        }
    }

    private void copySubGraph(SceneWorkingGraph src, List<SceneWorkingGraph.View> srcViews) {
        int listIdx;
        this.viewsFixed.reset().resize(srcViews.size(), false);
        this.srcToCpy.clear();
        this.subgraph.reset();
        for (listIdx = 0; listIdx < srcViews.size(); ++listIdx) {
            this.copyIntrinsicsExtrinsics(src, srcViews.get(listIdx));
        }
        this.camerasFixed.reset().resize(this.subgraph.cameras.size(), false);
        for (listIdx = 0; listIdx < srcViews.size(); ++listIdx) {
            SceneWorkingGraph.View srcView = srcViews.get(listIdx);
            BoofMiscOps.checkTrue((!srcView.inliers.isEmpty() ? 1 : 0) != 0, (String)"BUG no inliers");
            for (int infoIdx = 0; infoIdx < srcView.inliers.size; ++infoIdx) {
                this.copyViewAndInlierSet(src, srcView, infoIdx);
            }
        }
        BoofMiscOps.checkEq((int)this.cameraPriors.size(), (int)this.subgraph.listViews.size());
    }

    private void copyViewAndInlierSet(SceneWorkingGraph src, SceneWorkingGraph.View srcView, int infoIdx) {
        SceneWorkingGraph.View cpyView = Objects.requireNonNull(this.srcToCpy.get(srcView.pview.id));
        BoofMiscOps.checkTrue((!srcView.inliers.isEmpty() ? 1 : 0) != 0, (String)"BUG no inliers");
        SceneWorkingGraph.InlierInfo srcInfo = (SceneWorkingGraph.InlierInfo)srcView.inliers.get(infoIdx);
        SceneWorkingGraph.InlierInfo cpyInfo = (SceneWorkingGraph.InlierInfo)cpyView.inliers.grow();
        for (int infoViewsIdx = 0; infoViewsIdx < srcInfo.views.size; ++infoViewsIdx) {
            PairwiseImageGraph.View pview = (PairwiseImageGraph.View)srcInfo.views.get(infoViewsIdx);
            SceneWorkingGraph.View infoView = this.srcToCpy.get(pview.id);
            if (infoView == null) {
                this.copyIntrinsicsExtrinsics(src, src.lookupView(pview.id));
                this.viewsFixed.add(true);
                if (this.camerasFixed.size != this.subgraph.cameras.size()) {
                    this.camerasFixed.add(true);
                }
            }
            cpyInfo.views.add((Object)pview);
            cpyInfo.scoreGeometric = srcInfo.scoreGeometric;
            ((DogArray_I32)cpyInfo.observations.grow()).setTo((DogArray_I32)srcInfo.observations.get(infoViewsIdx));
        }
    }

    private void copyIntrinsicsExtrinsics(SceneWorkingGraph src, SceneWorkingGraph.View srcView) {
        SceneWorkingGraph.Camera srcCamera = src.getViewCamera(srcView);
        SceneWorkingGraph.Camera cpyCamera = (SceneWorkingGraph.Camera)this.subgraph.cameras.get(srcCamera.indexDB);
        if (cpyCamera == null) {
            cpyCamera = this.subgraph.addCameraCopy(srcCamera);
        }
        SceneWorkingGraph.View cpyView = this.subgraph.addView(srcView.pview, cpyCamera);
        cpyView.world_to_view.setTo(srcView.world_to_view);
        this.cameraPriors.add(cpyCamera.prior);
        BoofMiscOps.checkTrue((null == this.srcToCpy.put(srcView.pview.id, cpyView) ? 1 : 0) != 0);
    }

    void rescaleLocalCoordinateSystem() {
        int i;
        this.world_to_local.setTo(this.subgraph.listViews.get((int)0).world_to_view);
        this.world_to_local.invert(this.local_to_world);
        this.scaleLocalToWorld = 0.0;
        for (i = 0; i < this.subgraph.listViews.size(); ++i) {
            Se3_F64 world_to_view = this.subgraph.listViews.get((int)i).world_to_view;
            this.local_to_world.concat(world_to_view, this.tmp);
            world_to_view.setTo(this.tmp);
            this.scaleLocalToWorld = Math.max(this.scaleLocalToWorld, this.tmp.T.norm());
        }
        for (i = 0; i < this.subgraph.listViews.size(); ++i) {
            this.subgraph.listViews.get((int)i).world_to_view.T.divide(this.scaleLocalToWorld);
        }
    }

    public void setViewKnown(String id) {
        this.viewsFixed.set(Objects.requireNonNull(this.subgraph.views.get((Object)id)).index, true);
    }

    public boolean process(LookUpSimilarImages db) {
        if (!this.refiner.process(db, this.subgraph, this::markKnownParameters)) {
            return false;
        }
        for (int listIdx = 0; listIdx < this.srcViews.size(); ++listIdx) {
            SceneWorkingGraph.View srcView = this.srcViews.get(listIdx);
            SceneWorkingGraph.View cpyView = Objects.requireNonNull(this.srcToCpy.get(srcView.pview.id));
            if (this.viewsFixed.get(cpyView.index)) continue;
            this.localToGlobal(cpyView.world_to_view, srcView.world_to_view);
        }
        return true;
    }

    protected void localToGlobal(Se3_F64 cpy_to_view, Se3_F64 src_to_view) {
        this.tmp.setTo(cpy_to_view);
        this.tmp.T.scale(this.scaleLocalToWorld);
        this.world_to_local.concat(this.tmp, src_to_view);
    }

    protected void markKnownParameters(MetricBundleAdjustmentUtils utils) {
        BoofMiscOps.checkEq((int)this.camerasFixed.size, (int)utils.structure.cameras.size);
        for (int cameraIdx = 0; cameraIdx < this.camerasFixed.size; ++cameraIdx) {
            if (!this.viewsFixed.get(cameraIdx)) continue;
            ((SceneStructureCommon.Camera)utils.structure.cameras.get((int)cameraIdx)).known = true;
        }
        BoofMiscOps.checkEq((int)this.viewsFixed.size, (int)utils.structure.views.size);
        for (int viewIdx = 0; viewIdx < this.viewsFixed.size; ++viewIdx) {
            if (!this.viewsFixed.get(viewIdx)) continue;
            ((SceneStructureMetric.Motion)utils.structure.motions.get((int)viewIdx)).known = true;
        }
    }

    public void setVerbose(@Nullable PrintStream out, @Nullable Set<String> configuration) {
        this.verbose = BoofMiscOps.addPrefix((VerbosePrint)this, (PrintStream)out);
        BoofMiscOps.verboseChildren((PrintStream)out, configuration, (VerbosePrint[])new VerbosePrint[]{this.refiner});
    }

    public RefineMetricWorkingGraph getRefiner() {
        return this.refiner;
    }

    public SceneWorkingGraph getSubgraph() {
        return this.subgraph;
    }

    public Se3_F64 getLocal_to_world() {
        return this.local_to_world;
    }

    public Se3_F64 getWorld_to_local() {
        return this.world_to_local;
    }

    public double getScaleLocalToWorld() {
        return this.scaleLocalToWorld;
    }
}

