/*
 * Decompiled with CFR 0.152.
 */
package boofcv.factory.structure;

import boofcv.factory.geo.ConfigFundamental;
import boofcv.factory.geo.ConfigHomography;
import boofcv.factory.geo.ConfigRansac;
import boofcv.misc.BoofMiscOps;
import boofcv.struct.ConfigLength;
import boofcv.struct.Configuration;

public class ConfigEpipolarScore3D
implements Configuration {
    public final ConfigRansac ransacF = new ConfigRansac();
    public final ConfigFundamental fundamental = new ConfigFundamental();
    public Type type = Type.FUNDAMENTAL_ROTATION;
    public final ModelInliers typeInliers = new ModelInliers();
    public final FundamentalCompatible typeCompatible = new FundamentalCompatible();
    public final FundamentalRotation typeRotation = new FundamentalRotation();

    public ConfigEpipolarScore3D() {
        this.ransacF.iterations = 500;
        this.ransacF.inlierThreshold = 2.0;
        this.typeInliers.ransacH.iterations = 500;
        this.typeInliers.ransacH.inlierThreshold = 4.0;
        this.fundamental.errorModel = ConfigFundamental.ErrorModel.GEOMETRIC;
        this.fundamental.numResolve = 1;
    }

    public void checkValidity() {
        this.ransacF.checkValidity();
        this.fundamental.checkValidity();
        this.typeInliers.checkValidity();
        this.typeCompatible.checkValidity();
    }

    public ConfigEpipolarScore3D setTo(ConfigEpipolarScore3D src) {
        this.ransacF.setTo(src.ransacF);
        this.fundamental.setTo(src.fundamental);
        this.type = src.type;
        this.typeInliers.setTo(src.typeInliers);
        this.typeCompatible.setTo(src.typeCompatible);
        this.typeRotation.setTo(src.typeRotation);
        return this;
    }

    public static enum Type {
        MODEL_INLIERS,
        FUNDAMENTAL_COMPATIBLE,
        FUNDAMENTAL_ROTATION;

    }

    public static class ModelInliers
    implements Configuration {
        public final ConfigRansac ransacH = new ConfigRansac();
        public final ConfigHomography homography = new ConfigHomography();
        public final ConfigLength minimumInliers = ConfigLength.fixed((double)30.0);
        public double ratio3D = 1.5;
        public double maxRatioScore = 5.0;

        public void checkValidity() {
            BoofMiscOps.checkTrue((this.ratio3D > 0.0 ? 1 : 0) != 0);
            BoofMiscOps.checkTrue((this.maxRatioScore > 0.0 ? 1 : 0) != 0);
            this.ransacH.checkValidity();
            this.homography.checkValidity();
            this.minimumInliers.checkValidity();
        }

        public ModelInliers setTo(ModelInliers src) {
            this.ratio3D = src.ratio3D;
            this.maxRatioScore = src.maxRatioScore;
            this.ransacH.setTo(src.ransacH);
            this.homography.setTo(src.homography);
            this.minimumInliers.setTo(src.minimumInliers);
            return this;
        }
    }

    public static class FundamentalCompatible
    implements Configuration {
        public double ratio3D = 1.2;
        public double inlierErrorTol = 2.0;
        public double maxRatioScore = 10.0;
        public final ConfigLength minimumInliers = ConfigLength.relative((double)0.2, (double)40.0);

        public void checkValidity() {
            BoofMiscOps.checkTrue((this.inlierErrorTol >= 0.0 ? 1 : 0) != 0);
            BoofMiscOps.checkTrue((this.ratio3D > 0.0 ? 1 : 0) != 0);
            BoofMiscOps.checkTrue((this.maxRatioScore > 0.0 ? 1 : 0) != 0);
            this.minimumInliers.checkValidity();
        }

        public FundamentalCompatible setTo(FundamentalCompatible src) {
            this.ratio3D = src.ratio3D;
            this.inlierErrorTol = src.inlierErrorTol;
            this.maxRatioScore = src.maxRatioScore;
            this.minimumInliers.setTo(src.minimumInliers);
            return this;
        }
    }

    public static class FundamentalRotation
    implements Configuration {
        public double ratio3D = 1.2;
        public double inlierErrorTol = 1.5;
        public double maxRatioScore = 10.0;
        public final ConfigLength minimumInliers = ConfigLength.relative((double)0.2, (double)40.0);

        public void checkValidity() {
            BoofMiscOps.checkTrue((this.inlierErrorTol >= 0.0 ? 1 : 0) != 0);
            BoofMiscOps.checkTrue((this.ratio3D > 0.0 ? 1 : 0) != 0);
            BoofMiscOps.checkTrue((this.maxRatioScore > 0.0 ? 1 : 0) != 0);
            this.minimumInliers.checkValidity();
        }

        public FundamentalRotation setTo(FundamentalRotation src) {
            this.ratio3D = src.ratio3D;
            this.inlierErrorTol = src.inlierErrorTol;
            this.maxRatioScore = src.maxRatioScore;
            this.minimumInliers.setTo(src.minimumInliers);
            return this;
        }
    }
}

