/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.structure;

import boofcv.abst.geo.bundle.BundleAdjustmentCamera;
import boofcv.abst.geo.bundle.SceneStructureCommon;
import boofcv.abst.geo.bundle.SceneStructureMetric;
import boofcv.alg.mvs.StereoPairGraph;
import georegression.metric.UtilAngle;
import georegression.struct.GeoTuple2D_F64;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Vector3D_F64;
import georegression.struct.se.Se3_F64;
import gnu.trove.map.TIntIntMap;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntIntHashMap;
import java.io.PrintStream;
import java.util.Objects;
import java.util.Set;
import org.ddogleg.struct.DogArray;
import org.ddogleg.struct.DogArray_F64;
import org.ddogleg.struct.DogArray_I32;
import org.ddogleg.struct.VerbosePrint;
import org.ejml.data.DMatrixRMaj;
import org.jetbrains.annotations.Nullable;

public class GenerateStereoPairGraphFromScene
implements VerbosePrint {
    final StereoPairGraph stereoGraph = new StereoPairGraph();
    public double countSmootherParam = 10.0;
    public double minimumCommonFeaturesFrac = 0.5;
    public double targetDisparity = 50.0;
    final DogArray<View> views = new DogArray(View::new);
    final TIntIntMap pointMap = new TIntIntHashMap(500, 0.5f, -1, -1);
    final DogArray_F64 acuteAngles = new DogArray_F64();
    @Nullable
    PrintStream verbose;

    public void process(TIntObjectMap<String> viewIdx_to_imageId, SceneStructureMetric scene) {
        this.stereoGraph.reset();
        this.matchPointsToViews(scene);
        this.estimateRadiansToPixels(scene);
        this.createStereoGraph(viewIdx_to_imageId);
    }

    private void estimateRadiansToPixels(SceneStructureMetric scene) {
        double oneDegree = Math.sin(UtilAngle.degreeToRadian((double)5.0));
        Point2D_F64 pixelA = new Point2D_F64();
        Point2D_F64 pixelB = new Point2D_F64();
        for (int i = 0; i < scene.views.size; ++i) {
            SceneStructureMetric.View view = (SceneStructureMetric.View)scene.views.get(i);
            BundleAdjustmentCamera camera = Objects.requireNonNull(scene.getViewCamera((SceneStructureMetric.View)view).model);
            camera.project(0.0, 0.0, 1.0, pixelA);
            camera.project(oneDegree, 0.0, 1.0, pixelB);
            ((View)this.views.get((int)i)).radianToPixels = pixelA.distance((GeoTuple2D_F64)pixelB) / UtilAngle.degreeToRadian((double)5.0);
        }
    }

    protected void matchPointsToViews(SceneStructureMetric scene) {
        this.views.resize(scene.views.size);
        Se3_F64 world_to_view = new Se3_F64();
        Se3_F64 tmpSE = new Se3_F64();
        for (int pointIdx = 0; pointIdx < scene.points.size; ++pointIdx) {
            SceneStructureCommon.Point p = (SceneStructureCommon.Point)scene.points.get(pointIdx);
            for (int i = 0; i < p.views.size; ++i) {
                int viewIdxA = p.views.get(i);
                View viewA = (View)this.views.get(viewIdxA);
                viewA.pointIndexes.add(pointIdx);
                scene.getWorldToView((SceneStructureMetric.View)scene.views.get(viewIdxA), world_to_view, tmpSE);
                this.computePointingVector(world_to_view, p, scene.isHomogeneous(), (Vector3D_F64)viewA.pointing.grow());
                for (int j = i + 1; j < p.views.size; ++j) {
                    this.connect(viewIdxA, p.views.get(j));
                }
            }
        }
    }

    protected void computePointingVector(Se3_F64 world_to_view, SceneStructureCommon.Point p, boolean homogeneous, Vector3D_F64 pointing) {
        double n_z;
        double n_y;
        double x = p.coordinate[0];
        double y = p.coordinate[1];
        double z = p.coordinate[2];
        double w = homogeneous ? p.coordinate[3] : 1.0;
        pointing.x = x + world_to_view.T.x * w;
        pointing.y = y + world_to_view.T.y * w;
        pointing.z = z + world_to_view.T.z * w;
        pointing.normalize();
        if (!homogeneous) {
            return;
        }
        DMatrixRMaj R = world_to_view.R;
        double n_x = R.unsafe_get(0, 2);
        if (pointing.dot(n_x, n_y = R.unsafe_get(1, 2), n_z = R.unsafe_get(2, 2)) < 0.0) {
            pointing.scale(-1.0);
        }
    }

    protected void connect(int viewIdxA, int viewIdxB) {
        View viewA = (View)this.views.get(viewIdxA);
        View viewB = (View)this.views.get(viewIdxB);
        if (!viewA.connectedViews.contains(viewIdxB)) {
            viewA.connectedViews.add(viewIdxB);
        }
        if (!viewB.connectedViews.contains(viewIdxA)) {
            viewB.connectedViews.add(viewIdxA);
        }
    }

    protected void createStereoGraph(TIntObjectMap<String> viewToId) {
        int viewIdxA;
        int maxFeaturesInView = 0;
        for (viewIdxA = 0; viewIdxA < this.views.size; ++viewIdxA) {
            this.stereoGraph.addVertex((String)viewToId.get(viewIdxA), viewIdxA);
            maxFeaturesInView = Math.max(((View)this.views.get((int)viewIdxA)).pointing.size, maxFeaturesInView);
        }
        for (viewIdxA = 0; viewIdxA < this.views.size; ++viewIdxA) {
            View viewA = (View)this.views.get(viewIdxA);
            String nameA = (String)viewToId.get(viewIdxA);
            for (int i = 0; i < viewA.connectedViews.size; ++i) {
                int viewIdxB = viewA.connectedViews.get(i);
                if (viewIdxB <= viewIdxA) continue;
                View viewB = (View)this.views.get(viewIdxB);
                String nameB = (String)viewToId.get(viewIdxB);
                this.findCommonFeatureAngles(viewA, viewB);
                if ((double)this.acuteAngles.size < (double)Math.min(viewA.pointing.size, viewB.pointing.size) * this.minimumCommonFeaturesFrac) continue;
                this.acuteAngles.sort();
                double angle50 = this.acuteAngles.getFraction(0.5);
                double angle95 = this.acuteAngles.getFraction(0.95);
                double radianToPixels = Math.min(viewA.radianToPixels, viewB.radianToPixels);
                double qualityDisparity = Math.min(1.0, radianToPixels * (angle50 + angle95) / (2.0 * this.targetDisparity));
                double qualityCommon = (this.countSmootherParam + (double)this.acuteAngles.size) / (this.countSmootherParam + (double)maxFeaturesInView);
                double quality = qualityDisparity * qualityCommon;
                if (this.verbose != null) {
                    this.verbose.printf("Quality: %4s - %4s %.2f : disp=%.2f com=%.2f\n", nameA, nameB, quality, qualityDisparity, qualityCommon);
                }
                if (quality == 0.0) continue;
                this.stereoGraph.connect(nameA, nameB, quality);
            }
        }
    }

    protected void findCommonFeatureAngles(View viewA, View viewB) {
        this.pointMap.clear();
        this.acuteAngles.reset();
        viewA.pointIndexes.forIdx((idxA, pointIdx) -> this.pointMap.put(pointIdx, idxA));
        viewB.pointIndexes.forIdx((idxB, pointIdx) -> {
            int idxA = this.pointMap.get(pointIdx);
            if (idxA == -1) {
                return;
            }
            this.acuteAngles.add(((Vector3D_F64)viewA.pointing.get(idxA)).acute((Vector3D_F64)viewB.pointing.get(idxB)));
        });
    }

    public void setVerbose(@Nullable PrintStream out, @Nullable Set<String> set) {
        this.verbose = out;
    }

    public StereoPairGraph getStereoGraph() {
        return this.stereoGraph;
    }

    protected static class View {
        final DogArray_I32 pointIndexes = new DogArray_I32();
        final DogArray<Vector3D_F64> pointing = new DogArray(Vector3D_F64::new);
        final DogArray_I32 connectedViews = new DogArray_I32();
        double radianToPixels;

        protected View() {
        }

        public void reset() {
            this.pointIndexes.reset();
            this.pointing.reset();
            this.connectedViews.reset();
            this.radianToPixels = 0.0;
        }
    }
}

