/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.structure;

import boofcv.abst.geo.bundle.BundleAdjustment;
import boofcv.abst.geo.bundle.BundleAdjustmentCamera;
import boofcv.abst.geo.bundle.PruneStructureFromSceneMetric;
import boofcv.abst.geo.bundle.SceneObservations;
import boofcv.abst.geo.bundle.SceneStructure;
import boofcv.abst.geo.bundle.SceneStructureCommon;
import boofcv.abst.geo.bundle.SceneStructureMetric;
import boofcv.alg.geo.MultiViewOps;
import boofcv.alg.geo.PerspectiveOps;
import boofcv.alg.geo.bundle.BundleAdjustmentOps;
import boofcv.alg.geo.bundle.cameras.BundlePinholeSimplified;
import boofcv.alg.geo.robust.RansacProjective;
import boofcv.alg.geo.selfcalib.MetricCameraTriple;
import boofcv.factory.geo.ConfigBundleAdjustment;
import boofcv.factory.geo.ConfigPixelsToMetric;
import boofcv.factory.geo.ConfigRansac;
import boofcv.factory.geo.FactoryMultiView;
import boofcv.factory.geo.FactoryMultiViewRobust;
import boofcv.misc.BoofMiscOps;
import boofcv.misc.ConfigConverge;
import boofcv.struct.calib.CameraPinhole;
import boofcv.struct.calib.CameraPinholeBrown;
import boofcv.struct.calib.ElevateViewInfo;
import boofcv.struct.geo.AssociatedTriple;
import georegression.geometry.ConvertRotation3D_F64;
import georegression.struct.point.Point3D_F64;
import georegression.struct.point.Point4D_F64;
import georegression.struct.se.Se3_F64;
import georegression.struct.so.Rodrigues_F64;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.ddogleg.optimization.ConfigNonLinearLeastSquares;
import org.ddogleg.struct.DogArray;
import org.ddogleg.struct.VerbosePrint;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import org.jetbrains.annotations.Nullable;

public class ThreeViewEstimateMetricScene
implements VerbosePrint {
    public ConfigPixelsToMetric configSelfCalib = new ConfigPixelsToMetric();
    public ConfigRansac configRansac = new ConfigRansac();
    public ConfigBundleAdjustment configSBA = new ConfigBundleAdjustment();
    public ConfigConverge convergeSBA = new ConfigConverge(1.0E-6, 1.0E-6, 100);
    public boolean homogeneous = false;
    public int[] viewToCamera = new int[]{0, 0, 0};
    public double manualFocalLength = -1.0;
    public double pruneFraction = 0.7;
    public RansacProjective<MetricCameraTriple, AssociatedTriple> ransac;
    public List<AssociatedTriple> inliers;
    @Nullable
    private PrintStream verbose;
    public final DogArray<CameraPinholeBrown> listPinhole = new DogArray(CameraPinholeBrown::new, CameraPinholeBrown::reset);
    public final DogArray<Se3_F64> listWorldToView = new DogArray(Se3_F64::new, Se3_F64::reset);
    public BundleAdjustment<SceneStructureMetric> bundleAdjustment;
    private SceneStructureMetric structure;
    private SceneObservations observations;
    protected int width;
    protected int height;

    public ThreeViewEstimateMetricScene() {
        this.configRansac.iterations = 1000;
        this.configRansac.inlierThreshold = 4.0;
        this.configSBA.optimizer.type = ConfigNonLinearLeastSquares.Type.LEVENBERG_MARQUARDT;
        this.configSBA.optimizer.lm.dampeningInitial = 0.001;
        this.configSBA.optimizer.lm.hessianScaling = false;
    }

    public void declareAlgorithms() {
        this.ransac = FactoryMultiViewRobust.metricThreeViewRansac((ConfigPixelsToMetric)this.configSelfCalib, (ConfigRansac)this.configRansac);
        this.structure = new SceneStructureMetric(this.homogeneous);
        this.observations = new SceneObservations();
        this.bundleAdjustment = FactoryMultiView.bundleSparseMetric((ConfigBundleAdjustment)this.configSBA);
        this.bundleAdjustment.configure(this.convergeSBA.ftol, this.convergeSBA.gtol, this.convergeSBA.maxIterations);
    }

    public void initialize(int width, int height) {
        if (this.ransac == null) {
            this.declareAlgorithms();
        }
        this.width = width;
        this.height = height;
        for (int idx = 0; idx < 3; ++idx) {
            int camId = this.viewToCamera[idx];
            BoofMiscOps.checkTrue((camId <= idx ? 1 : 0) != 0, (String)"camID must be <= array index");
            BoofMiscOps.checkTrue((camId >= 0 ? 1 : 0) != 0, (String)"Camera must be from 0 to 2");
            this.ransac.setView(idx, new ElevateViewInfo(width, height, camId));
        }
    }

    public boolean process(List<AssociatedTriple> associated) {
        Objects.requireNonNull(this.ransac, "Did you call initialize?");
        if (!this.robustSelfCalibration(associated)) {
            return false;
        }
        this.setupMetricBundleAdjustment(this.inliers);
        this.findBestValidSolution(this.bundleAdjustment);
        if (!this.pruneOutliers(this.bundleAdjustment)) {
            return false;
        }
        this.saveSbaResults();
        return true;
    }

    private boolean robustSelfCalibration(List<AssociatedTriple> associated) {
        if (!this.ransac.process(associated)) {
            if (this.verbose != null) {
                this.verbose.println("RANSAC failed!");
            }
            return false;
        }
        this.inliers = this.ransac.getMatchSet();
        if (this.inliers.size() < associated.size() / 10) {
            if (this.verbose != null) {
                this.verbose.println("Too few inliers: " + this.inliers.size() + "/" + associated.size());
            }
            return false;
        }
        if (this.verbose != null) {
            this.verbose.println("Remaining after RANSAC " + this.inliers.size() + " / " + associated.size());
        }
        this.averageIntrinsicParameters((MetricCameraTriple)this.ransac.getModelParameters());
        this.listWorldToView.reset().resize(3);
        for (int i = 0; i < 3; ++i) {
            ((MetricCameraTriple)this.ransac.getModelParameters()).getView1ToIdx(i, (Se3_F64)this.listWorldToView.get(i));
        }
        return true;
    }

    private boolean pruneOutliers(BundleAdjustment<SceneStructureMetric> bundleAdjustment) {
        if (this.pruneFraction == 1.0) {
            return true;
        }
        if (this.verbose != null) {
            this.verbose.println("Pruning Outliers");
        }
        PruneStructureFromSceneMetric pruner = new PruneStructureFromSceneMetric(this.structure, this.observations);
        pruner.pruneObservationsByErrorRank(this.pruneFraction);
        pruner.pruneViews(10);
        pruner.pruneUnusedMotions();
        pruner.prunePoints(1);
        bundleAdjustment.setParameters((SceneStructure)this.structure, this.observations);
        double before = bundleAdjustment.getFitScore();
        if (this.convergeSBA.maxIterations > 0 && !bundleAdjustment.optimize((SceneStructure)this.structure)) {
            return false;
        }
        if (this.verbose != null) {
            int i;
            this.verbose.println("   before " + before + " after " + bundleAdjustment.getFitScore());
            this.verbose.println("\nCamera");
            for (i = 0; i < this.structure.cameras.size; ++i) {
                this.verbose.println("  " + Objects.requireNonNull(((SceneStructureCommon.Camera[])this.structure.cameras.data)[i].getModel()));
            }
            this.verbose.println("\nworldToView");
            for (i = 0; i < this.structure.views.size; ++i) {
                Se3_F64 se = this.structure.getParentToView(i);
                Rodrigues_F64 rod = ConvertRotation3D_F64.matrixToRodrigues((DMatrixRMaj)se.R, null);
                this.verbose.println("  T=" + se.T + "  R=" + rod);
            }
        }
        return true;
    }

    private void saveSbaResults() {
        int i;
        this.listPinhole.reset().resize(this.structure.cameras.size);
        for (i = 0; i < this.structure.cameras.size; ++i) {
            BundleAdjustmentOps.convert((BundleAdjustmentCamera)((SceneStructureCommon.Camera)this.structure.cameras.get((int)i)).model, null, (int)this.width, (int)this.height, (CameraPinholeBrown)((CameraPinholeBrown)this.listPinhole.get(i)));
        }
        this.listWorldToView.reset().resize(this.structure.views.size);
        for (i = 0; i < this.structure.views.size; ++i) {
            ((Se3_F64)this.listWorldToView.get(i)).setTo(this.structure.getParentToView(i));
        }
    }

    private void findBestValidSolution(BundleAdjustment<SceneStructureMetric> bundleAdjustment) {
        BundlePinholeSimplified c;
        int i;
        bundleAdjustment.configure(this.convergeSBA.ftol, this.convergeSBA.gtol, this.convergeSBA.maxIterations);
        bundleAdjustment.setParameters((SceneStructure)this.structure, this.observations);
        bundleAdjustment.optimize((SceneStructure)this.structure);
        if (this.checkBehindCamera(this.structure)) {
            if (this.verbose != null) {
                this.verbose.println("  #1 Points Behind. Flipping view");
            }
            ThreeViewEstimateMetricScene.flipAround(this.structure, this.observations);
            bundleAdjustment.setParameters((SceneStructure)this.structure, this.observations);
            bundleAdjustment.optimize((SceneStructure)this.structure);
        }
        double bestScore = bundleAdjustment.getFitScore();
        if (this.verbose != null) {
            this.verbose.println("First Pass: SBA score " + bestScore);
        }
        ArrayList<Se3_F64> bestPose = new ArrayList<Se3_F64>();
        ArrayList<BundlePinholeSimplified> bestCameras = new ArrayList<BundlePinholeSimplified>();
        for (i = 0; i < this.structure.cameras.size; ++i) {
            c = Objects.requireNonNull((BundlePinholeSimplified)((SceneStructureCommon.Camera[])this.structure.cameras.data)[i].getModel());
            bestCameras.add(c.copy());
        }
        for (i = 0; i < this.structure.views.size; ++i) {
            bestPose.add(this.structure.getParentToView(i).copy());
        }
        for (i = 0; i < this.structure.cameras.size; ++i) {
            c = Objects.requireNonNull((BundlePinholeSimplified)((SceneStructureCommon.Camera[])this.structure.cameras.data)[i].getModel());
            c.f = ((CameraPinholeBrown)this.listPinhole.get((int)i)).fx;
            c.k2 = 0.0;
            c.k1 = 0.0;
        }
        for (i = 1; i < this.structure.views.size; ++i) {
            CommonOps_DDRM.transpose((DMatrixRMaj)this.structure.getParentToView((int)i).R);
        }
        MultiViewOps.triangulatePoints((SceneStructureMetric)this.structure, (SceneObservations)this.observations);
        bundleAdjustment.setParameters((SceneStructure)this.structure, this.observations);
        bundleAdjustment.optimize((SceneStructure)this.structure);
        if (this.checkBehindCamera(this.structure)) {
            if (this.verbose != null) {
                this.verbose.println("  #2 Points Behind. Flipping view");
            }
            ThreeViewEstimateMetricScene.flipAround(this.structure, this.observations);
            bundleAdjustment.setParameters((SceneStructure)this.structure, this.observations);
            bundleAdjustment.optimize((SceneStructure)this.structure);
        }
        if (this.verbose != null) {
            this.verbose.println(" First Pass / Transpose(R) = " + bestScore + " / " + bundleAdjustment.getFitScore());
        }
        if (bundleAdjustment.getFitScore() > bestScore) {
            if (this.verbose != null) {
                this.verbose.println("  recomputing old structure");
            }
            for (i = 0; i < this.structure.cameras.size; ++i) {
                c = Objects.requireNonNull((BundlePinholeSimplified)((SceneStructureCommon.Camera[])this.structure.cameras.data)[i].getModel());
                c.setTo((BundlePinholeSimplified)bestCameras.get(i));
            }
            for (i = 0; i < this.structure.views.size; ++i) {
                this.structure.getParentToView(i).setTo((Se3_F64)bestPose.get(i));
            }
            MultiViewOps.triangulatePoints((SceneStructureMetric)this.structure, (SceneObservations)this.observations);
            bundleAdjustment.setParameters((SceneStructure)this.structure, this.observations);
            bundleAdjustment.optimize((SceneStructure)this.structure);
            if (this.verbose != null) {
                this.verbose.println("  score after reverting = " + bundleAdjustment.getFitScore() + "  original " + bestScore);
            }
        }
    }

    private void setupMetricBundleAdjustment(List<AssociatedTriple> inliers) {
        int i;
        this.structure.initialize(this.listPinhole.size(), 3, inliers.size());
        this.observations.initialize(3);
        for (i = 0; i < this.listPinhole.size(); ++i) {
            CameraPinhole cp = (CameraPinhole)this.listPinhole.get(i);
            BundlePinholeSimplified bp = new BundlePinholeSimplified();
            bp.f = cp.fx;
            this.structure.setCamera(i, false, (BundleAdjustmentCamera)bp);
        }
        for (i = 0; i < 3; ++i) {
            this.structure.setView(i, this.viewToCamera[i], i == 0, (Se3_F64)this.listWorldToView.get(i));
        }
        for (i = 0; i < inliers.size(); ++i) {
            AssociatedTriple t = inliers.get(i);
            this.observations.getView(0).add(i, (float)t.p1.x, (float)t.p1.y);
            this.observations.getView(1).add(i, (float)t.p2.x, (float)t.p2.y);
            this.observations.getView(2).add(i, (float)t.p3.x, (float)t.p3.y);
            this.structure.connectPointToView(i, 0);
            this.structure.connectPointToView(i, 1);
            this.structure.connectPointToView(i, 2);
        }
        MultiViewOps.triangulatePoints((SceneStructureMetric)this.structure, (SceneObservations)this.observations);
    }

    private void averageIntrinsicParameters(MetricCameraTriple results) {
        int count;
        this.listPinhole.reset();
        int total = 0;
        for (int target = 0; target < 3 && total < 3; total += count, ++target) {
            CameraPinhole ave = (CameraPinhole)this.listPinhole.grow();
            count = 0;
            for (int i = 0; i < this.viewToCamera.length; ++i) {
                if (this.viewToCamera[i] != target) continue;
                CameraPinhole a = results.getIntrinsics(i);
                ave.fx += a.fx;
                ave.fy += a.fy;
                ave.cx += a.cx;
                ave.cy += a.cy;
                ++count;
            }
            ave.fx /= (double)count;
            ave.fy /= (double)count;
            ave.cx /= (double)count;
            ave.cy /= (double)count;
        }
    }

    private boolean checkBehindCamera(SceneStructureMetric structure) {
        int totalBehind = 0;
        if (this.homogeneous) {
            Point4D_F64 X = new Point4D_F64();
            for (int i = 0; i < structure.points.size; ++i) {
                ((SceneStructureCommon.Point[])structure.points.data)[i].get(X);
                if (!PerspectiveOps.isBehindCamera((Point4D_F64)X)) continue;
                ++totalBehind;
            }
        } else {
            Point3D_F64 X = new Point3D_F64();
            for (int i = 0; i < structure.points.size; ++i) {
                ((SceneStructureCommon.Point[])structure.points.data)[i].get(X);
                if (!(X.z < 0.0)) continue;
                ++totalBehind;
            }
        }
        if (this.verbose != null) {
            this.verbose.println("points behind " + totalBehind + " / " + structure.points.size);
        }
        return totalBehind > structure.points.size / 2;
    }

    private static void flipAround(SceneStructureMetric structure, SceneObservations observations) {
        for (int i = 1; i < structure.views.size; ++i) {
            Se3_F64 w2v = structure.getParentToView(i);
            w2v.setTo(w2v.invert(null));
        }
        MultiViewOps.triangulatePoints((SceneStructureMetric)structure, (SceneObservations)observations);
    }

    public void setVerbose(@Nullable PrintStream out, @Nullable Set<String> configuration) {
        this.verbose = BoofMiscOps.addPrefix((VerbosePrint)this, (PrintStream)out);
    }

    public SceneStructureMetric getStructure() {
        return this.structure;
    }

    public SceneObservations getObservations() {
        return this.observations;
    }
}

