/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.sfm.d3.direct;

import boofcv.abst.filter.derivative.ImageGradient;
import boofcv.abst.sfm.ImagePixelTo3D;
import boofcv.alg.InputSanityCheck;
import boofcv.alg.filter.derivative.DerivativeType;
import boofcv.alg.interpolate.InterpolatePixelS;
import boofcv.alg.interpolate.InterpolationType;
import boofcv.alg.sfm.d3.direct.FeatureSpatialDiversity_F32;
import boofcv.core.image.FactoryGImageMultiBand;
import boofcv.core.image.GImageMultiBand;
import boofcv.core.image.border.BorderType;
import boofcv.factory.filter.derivative.FactoryDerivative;
import boofcv.factory.interpolate.FactoryInterpolation;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageType;
import boofcv.struct.image.Planar;
import georegression.struct.point.Point2D_F32;
import georegression.struct.point.Point3D_F32;
import georegression.struct.se.Se3_F32;
import georegression.transform.se.SePointOps_F32;
import georegression.transform.twist.TwistCoordinate_F32;
import georegression.transform.twist.TwistOps_F32;
import org.ddogleg.struct.FastQueue;
import org.ejml.data.DMatrixRMaj;
import org.ejml.data.Matrix;
import org.ejml.dense.row.factory.LinearSolverFactory_DDRM;
import org.ejml.interfaces.linsol.LinearSolver;

public class VisOdomDirectColorDepth<I extends ImageGray<I>, D extends ImageGray<D>> {
    private ImageType<Planar<I>> imageType;
    private ImageType<Planar<D>> derivType;
    private LinearSolver<DMatrixRMaj> solver;
    private DMatrixRMaj A = new DMatrixRMaj(1, 6);
    private DMatrixRMaj y = new DMatrixRMaj(1, 1);
    private DMatrixRMaj twistMatrix = new DMatrixRMaj(6, 1);
    private ImageGradient<Planar<I>, Planar<D>> computeD;
    private InterpolatePixelS<I> interpI;
    private InterpolatePixelS<D> interpDX;
    private InterpolatePixelS<D> interpDY;
    private GImageMultiBand wrapI;
    Planar<D> derivX;
    Planar<D> derivY;
    FastQueue<Pixel> keypixels;
    private Se3_F32 keyToCurrent = new Se3_F32();
    Se3_F32 motionTwist = new Se3_F32();
    private Se3_F32 tmp = new Se3_F32();
    private float fx;
    private float fy;
    private float cx;
    private float cy;
    private float convergeTol = 1.0E-6f;
    private int maxIterations = 10;
    private float errorOptical;
    private int inboundsPixels = 0;
    Point3D_F32 S = new Point3D_F32();
    private TwistCoordinate_F32 twist = new TwistCoordinate_F32();
    FeatureSpatialDiversity_F32 diversity = new FeatureSpatialDiversity_F32();

    public VisOdomDirectColorDepth(final int numBands, Class<I> imageType, Class<D> derivType) {
        this.imageType = ImageType.pl((int)numBands, imageType);
        this.derivType = ImageType.pl((int)numBands, derivType);
        this.wrapI = FactoryGImageMultiBand.create(this.imageType);
        this.setInterpolation(0.0, 0.0, 0.0, 0.0, InterpolationType.BILINEAR);
        this.derivX = (Planar)this.derivType.createImage(1, 1);
        this.derivY = (Planar)this.derivType.createImage(1, 1);
        this.keypixels = new FastQueue<Pixel>(Pixel.class, true){

            protected Pixel createInstance() {
                return new Pixel(numBands);
            }
        };
        this.computeD = FactoryDerivative.gradient((DerivativeType)DerivativeType.THREE, this.imageType, this.derivType);
    }

    public void setCameraParameters(float fx, float fy, float cx, float cy, int width, int height) {
        this.fx = fx;
        this.fy = fy;
        this.cx = cx;
        this.cy = cy;
        this.derivX.reshape(width, height);
        this.derivY.reshape(width, height);
        int N = width * height * this.imageType.getNumBands();
        this.A.reshape(N, 6);
        this.y.reshape(N, 1);
    }

    public void setInterpolation(double inputMin, double inputMax, double derivMin, double derivMax, InterpolationType type) {
        this.interpI = FactoryInterpolation.createPixelS((double)inputMin, (double)inputMax, (InterpolationType)type, (BorderType)BorderType.EXTENDED, (Class)this.imageType.getImageClass());
        this.interpDX = FactoryInterpolation.createPixelS((double)derivMin, (double)derivMax, (InterpolationType)type, (BorderType)BorderType.EXTENDED, (Class)this.derivType.getImageClass());
        this.interpDY = FactoryInterpolation.createPixelS((double)derivMin, (double)derivMax, (InterpolationType)type, (BorderType)BorderType.EXTENDED, (Class)this.derivType.getImageClass());
    }

    public void setConvergence(float convergenceTol, int maxIterations) {
        this.convergeTol = convergenceTol;
        this.maxIterations = maxIterations;
    }

    void setKeyFrame(Planar<I> input, ImagePixelTo3D pixelTo3D) {
        InputSanityCheck.checkSameShape(this.derivX, input);
        this.wrapI.wrap(input);
        this.keypixels.reset();
        for (int y = 0; y < input.height; ++y) {
            for (int x = 0; x < input.width; ++x) {
                if (!pixelTo3D.process(x, y)) continue;
                float P_x = (float)pixelTo3D.getX();
                float P_y = (float)pixelTo3D.getY();
                float P_z = (float)pixelTo3D.getZ();
                float P_w = (float)pixelTo3D.getW();
                if (P_w <= 0.0f) continue;
                Pixel p = (Pixel)this.keypixels.grow();
                p.valid = true;
                this.wrapI.get(x, y, p.bands);
                p.x = x;
                p.y = y;
                p.p3.set(P_x / P_w, P_y / P_w, P_z / P_w);
            }
        }
    }

    public double computeFeatureDiversity(Se3_F32 keyToCurrent) {
        this.diversity.reset();
        for (int i = 0; i < this.keypixels.size(); ++i) {
            Pixel p = ((Pixel[])this.keypixels.data)[i];
            if (!p.valid) continue;
            SePointOps_F32.transform((Se3_F32)keyToCurrent, (Point3D_F32)p.p3, (Point3D_F32)this.S);
            this.diversity.addPoint(this.S.x, this.S.y, this.S.z);
        }
        this.diversity.process();
        return this.diversity.getSpread();
    }

    public boolean estimateMotion(Planar<I> input, Se3_F32 hintKeyToInput) {
        InputSanityCheck.checkSameShape(this.derivX, input);
        this.initMotion(input);
        this.keyToCurrent.set(hintKeyToInput);
        boolean foundSolution = false;
        float previousError = Float.MAX_VALUE;
        for (int i = 0; i < this.maxIterations; ++i) {
            this.constructLinearSystem(input, this.keyToCurrent);
            if (!this.solveSystem() || Math.abs(previousError - this.errorOptical) / previousError < this.convergeTol) break;
            previousError = this.errorOptical;
            this.keyToCurrent.concat(this.motionTwist, this.tmp);
            this.keyToCurrent.set(this.tmp);
            foundSolution = true;
        }
        return foundSolution;
    }

    void initMotion(Planar<I> input) {
        if (this.solver == null) {
            this.solver = LinearSolverFactory_DDRM.qr((int)(input.width * input.height * input.getNumBands()), (int)6);
        }
        this.computeD.process(input, this.derivX, this.derivY);
    }

    void constructLinearSystem(Planar<I> input, Se3_F32 g) {
        int numBands = this.imageType.getNumBands();
        this.inboundsPixels = 0;
        for (int i = 0; i < this.keypixels.size(); ++i) {
            Pixel p = ((Pixel[])this.keypixels.data)[i];
            SePointOps_F32.transform((Se3_F32)g, (Point3D_F32)p.p3, (Point3D_F32)this.S);
            if (this.S.z <= 0.0f) {
                p.valid = false;
                continue;
            }
            p.proj.x = this.S.x / this.S.z * this.fx + this.cx;
            p.proj.y = this.S.y / this.S.z * this.fy + this.cy;
            if (p.proj.x < 0.0f || p.proj.x > (float)(input.width - 1) || p.proj.y < 0.0f || p.proj.y > (float)(input.height - 1)) {
                p.valid = false;
                continue;
            }
            p.valid = true;
            ++this.inboundsPixels;
            float ZZ = this.S.z * this.S.z;
            p.dP11 = this.fx / this.S.z;
            p.dP13 = -this.S.x * this.fx / ZZ;
            p.dP22 = this.fy / this.S.z;
            p.dP23 = -this.S.y * this.fy / ZZ;
        }
        this.errorOptical = 0.0f;
        int row = 0;
        for (int band = 0; band < numBands; ++band) {
            this.interpDX.setImage((ImageBase)this.derivX.getBand(band));
            this.interpDY.setImage((ImageBase)this.derivY.getBand(band));
            this.interpI.setImage((ImageBase)input.getBand(band));
            for (int i = 0; i < this.keypixels.size(); ++i) {
                Pixel p = ((Pixel[])this.keypixels.data)[i];
                if (!p.valid) continue;
                SePointOps_F32.transform((Se3_F32)g, (Point3D_F32)p.p3, (Point3D_F32)this.S);
                float current = this.interpI.get(p.proj.x, p.proj.y);
                float dx = this.interpDX.get(p.proj.x, p.proj.y);
                float dy = this.interpDY.get(p.proj.x, p.proj.y);
                float b1 = dx * p.dP11;
                float b2 = dy * p.dP22;
                float b3 = dx * p.dP13 + dy * p.dP23;
                int indexA = row * 6;
                this.A.data[indexA++] = -b2 * this.S.z + b3 * this.S.y;
                this.A.data[indexA++] = b1 * this.S.z - b3 * this.S.x;
                this.A.data[indexA++] = -b1 * this.S.y + b2 * this.S.x;
                this.A.data[indexA++] = b1;
                this.A.data[indexA++] = b2;
                this.A.data[indexA] = b3;
                float error = -(current - p.bands[band]);
                this.y.data[row] = error;
                this.errorOptical += Math.abs(error);
                ++row;
            }
        }
        this.errorOptical /= (float)row;
        this.A.numRows = row;
        this.y.numRows = row;
    }

    boolean solveSystem() {
        if (!this.solver.setA((Matrix)this.A)) {
            return false;
        }
        this.solver.solve((Matrix)this.y, (Matrix)this.twistMatrix);
        this.twist.set((float)this.twistMatrix.data[0], (float)this.twistMatrix.data[1], (float)this.twistMatrix.data[2], (float)this.twistMatrix.data[3], (float)this.twistMatrix.data[4], (float)this.twistMatrix.data[5]);
        TwistOps_F32.exponential((TwistCoordinate_F32)this.twist, (float)1.0f, (Se3_F32)this.motionTwist);
        return true;
    }

    public float getErrorOptical() {
        return this.errorOptical;
    }

    public int getInboundsPixels() {
        return this.inboundsPixels;
    }

    public int getKeyframePixels() {
        return this.keypixels.size;
    }

    public Se3_F32 getKeyToCurrent() {
        return this.keyToCurrent;
    }

    public ImageType<Planar<I>> getImageType() {
        return this.imageType;
    }

    public ImageType<Planar<D>> getDerivType() {
        return this.derivType;
    }

    static class Pixel {
        float[] bands;
        int x;
        int y;
        Point3D_F32 p3 = new Point3D_F32();
        Point2D_F32 proj = new Point2D_F32();
        boolean valid;
        float dP11;
        float dP13;
        float dP22;
        float dP23;

        public Pixel(int numBands) {
            this.bands = new float[numBands];
        }
    }
}

