/*
 * Decompiled with CFR 0.152.
 */
package boofcv.factory.sfm;

import boofcv.alg.interpolate.InterpolatePixelS;
import boofcv.alg.interpolate.InterpolationType;
import boofcv.alg.sfm.overhead.CreateSyntheticOverheadView;
import boofcv.alg.sfm.overhead.CreateSyntheticOverheadViewPL;
import boofcv.alg.sfm.overhead.CreateSyntheticOverheadViewS;
import boofcv.core.image.border.BorderType;
import boofcv.factory.interpolate.FactoryInterpolation;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageType;

public class FactorySfmMisc {
    public static <T extends ImageBase<T>> CreateSyntheticOverheadView<T> createOverhead(ImageType<T> imageType) {
        Class classType = imageType.getImageClass();
        switch (imageType.getFamily()) {
            case GRAY: {
                InterpolatePixelS interp = FactoryInterpolation.bilinearPixelS((Class)classType, (BorderType)BorderType.EXTENDED);
                return new CreateSyntheticOverheadViewS(interp);
            }
            case PLANAR: {
                return new CreateSyntheticOverheadViewPL(InterpolationType.BILINEAR, imageType.getNumBands(), classType);
            }
        }
        throw new IllegalArgumentException(imageType.getFamily() + " is not supported");
    }
}

