/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.sfm;

import boofcv.alg.distort.ImageDistort;
import boofcv.alg.geo.PerspectiveOps;
import boofcv.alg.geo.RectifyImageOps;
import boofcv.alg.geo.rectify.RectifyCalibrated;
import boofcv.core.image.GeneralizedImageOps;
import boofcv.core.image.border.BorderType;
import boofcv.struct.calib.CameraPinhole;
import boofcv.struct.calib.CameraPinholeRadial;
import boofcv.struct.calib.StereoParameters;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageType;
import georegression.geometry.GeometryMath_F64;
import georegression.struct.GeoTuple3D_F64;
import georegression.struct.point.Point3D_F64;
import georegression.struct.se.Se3_F64;
import org.ejml.data.DMatrixRMaj;
import org.ejml.data.FMatrixRMaj;
import org.ejml.ops.ConvertMatrixData;

public class StereoProcessingBase<T extends ImageGray<T>> {
    private ImageDistort<T, T> distortLeftRect;
    private ImageDistort<T, T> distortRightRect;
    private T imageLeftInput;
    private T imageRightInput;
    protected T imageLeftRect;
    protected T imageRightRect;
    protected DMatrixRMaj rect1;
    protected DMatrixRMaj rect2;
    protected DMatrixRMaj rectK;
    protected DMatrixRMaj rectR;
    protected Point3D_F64 pointRect = new Point3D_F64();
    protected double baseline;
    protected double cx;
    protected double cy;
    protected double fx;
    protected double fy;

    public StereoProcessingBase(Class<T> imageType) {
        this.imageLeftRect = GeneralizedImageOps.createSingleBand(imageType, (int)1, (int)1);
        this.imageRightRect = GeneralizedImageOps.createSingleBand(imageType, (int)1, (int)1);
    }

    public void setCalibration(StereoParameters stereoParam) {
        CameraPinholeRadial left = stereoParam.getLeft();
        CameraPinholeRadial right = stereoParam.getRight();
        this.imageLeftRect.reshape(left.getWidth(), left.getHeight());
        this.imageRightRect.reshape(right.getWidth(), right.getHeight());
        RectifyCalibrated rectifyAlg = RectifyImageOps.createCalibrated();
        Se3_F64 leftToRight = stereoParam.getRightToLeft().invert(null);
        DMatrixRMaj K1 = PerspectiveOps.calibrationMatrix((CameraPinhole)left, (DMatrixRMaj)null);
        DMatrixRMaj K2 = PerspectiveOps.calibrationMatrix((CameraPinhole)right, (DMatrixRMaj)null);
        rectifyAlg.process(K1, new Se3_F64(), K2, leftToRight);
        this.rect1 = rectifyAlg.getRect1();
        this.rect2 = rectifyAlg.getRect2();
        this.rectK = rectifyAlg.getCalibrationMatrix();
        this.rectR = rectifyAlg.getRectifiedRotation();
        FMatrixRMaj rect1_F32 = new FMatrixRMaj(3, 3);
        FMatrixRMaj rect2_F32 = new FMatrixRMaj(3, 3);
        ConvertMatrixData.convert((DMatrixRMaj)this.rect1, (FMatrixRMaj)rect1_F32);
        ConvertMatrixData.convert((DMatrixRMaj)this.rect2, (FMatrixRMaj)rect2_F32);
        ImageType imageType = this.imageLeftRect.getImageType();
        this.distortLeftRect = RectifyImageOps.rectifyImage((CameraPinholeRadial)stereoParam.left, (FMatrixRMaj)rect1_F32, (BorderType)BorderType.SKIP, (ImageType)imageType);
        this.distortRightRect = RectifyImageOps.rectifyImage((CameraPinholeRadial)stereoParam.right, (FMatrixRMaj)rect2_F32, (BorderType)BorderType.SKIP, (ImageType)imageType);
        this.baseline = stereoParam.getBaseline();
        this.fx = this.rectK.get(0, 0);
        this.fy = this.rectK.get(1, 1);
        this.cx = this.rectK.get(0, 2);
        this.cy = this.rectK.get(1, 2);
    }

    public void computeHomo3D(double x, double y, Point3D_F64 pointLeft) {
        this.pointRect.z = this.baseline * this.fx;
        this.pointRect.x = this.pointRect.z * (x - this.cx) / this.fx;
        this.pointRect.y = this.pointRect.z * (y - this.cy) / this.fy;
        GeometryMath_F64.multTran((DMatrixRMaj)this.rectR, (GeoTuple3D_F64)this.pointRect, (GeoTuple3D_F64)pointLeft);
    }

    public void setImages(T leftImage, T rightImage) {
        this.imageLeftInput = leftImage;
        this.imageRightInput = rightImage;
        this.distortLeftRect.apply(this.imageLeftInput, this.imageLeftRect);
        this.distortRightRect.apply(this.imageRightInput, this.imageRightRect);
    }

    public void initialize() {
    }

    public T getImageLeftRect() {
        return this.imageLeftRect;
    }

    public T getImageRightRect() {
        return this.imageRightRect;
    }

    public DMatrixRMaj getRectK() {
        return this.rectK;
    }

    public DMatrixRMaj getRect1() {
        return this.rect1;
    }

    public DMatrixRMaj getRect2() {
        return this.rect2;
    }
}

