/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.sfm.overhead;

import boofcv.alg.distort.LensDistortionOps;
import boofcv.misc.BoofMiscOps;
import boofcv.struct.calib.CameraModel;
import boofcv.struct.calib.CameraPinholeRadial;
import boofcv.struct.distort.Point2Transform2_F64;
import boofcv.struct.image.ImageBase;
import georegression.struct.point.Point2D_F32;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point3D_F64;
import georegression.struct.se.Se3_F64;
import georegression.transform.se.SePointOps_F64;
import org.ddogleg.struct.FastQueue;

public abstract class CreateSyntheticOverheadView<T extends ImageBase<T>> {
    protected int overheadWidth;
    protected int overheadHeight;
    protected Point2D_F32[] mapPixels;
    private FastQueue<Point2D_F32> points = new FastQueue(Point2D_F32.class, true);

    public void configure(CameraPinholeRadial intrinsic, Se3_F64 planeToCamera, double centerX, double centerY, double cellSize, int overheadWidth, int overheadHeight) {
        this.overheadWidth = overheadWidth;
        this.overheadHeight = overheadHeight;
        Point2Transform2_F64 normToPixel = LensDistortionOps.narrow((CameraModel)intrinsic).distort_F64(false, true);
        int overheadPixels = overheadHeight * overheadWidth;
        if (this.mapPixels == null || this.mapPixels.length < overheadPixels) {
            this.mapPixels = new Point2D_F32[overheadPixels];
        }
        this.points.reset();
        Point2D_F64 pixel = new Point2D_F64();
        Point3D_F64 pt_plane = new Point3D_F64();
        Point3D_F64 pt_cam = new Point3D_F64();
        int indexOut = 0;
        for (int i = 0; i < overheadHeight; ++i) {
            pt_plane.x = -((double)i * cellSize - centerY);
            int j = 0;
            while (j < overheadWidth) {
                pt_plane.z = (double)j * cellSize - centerX;
                SePointOps_F64.transform((Se3_F64)planeToCamera, (Point3D_F64)pt_plane, (Point3D_F64)pt_cam);
                if (pt_cam.z > 0.0) {
                    normToPixel.compute(pt_cam.x / pt_cam.z, pt_cam.y / pt_cam.z, pixel);
                    float x = (float)pixel.x;
                    float y = (float)pixel.y;
                    if (BoofMiscOps.checkInside((int)intrinsic.width, (int)intrinsic.height, (float)x, (float)y)) {
                        Point2D_F32 p = (Point2D_F32)this.points.grow();
                        p.set(x, y);
                        this.mapPixels[indexOut] = p;
                    } else {
                        this.mapPixels[indexOut] = null;
                    }
                }
                ++j;
                ++indexOut;
            }
        }
    }

    public Point2D_F32 getOverheadToPixel(int x, int y) {
        return this.mapPixels[y * this.overheadWidth + x];
    }

    public abstract void process(T var1, T var2);
}

