/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.sfm.d2;

import boofcv.abst.feature.tracker.PointTrack;
import java.util.List;

public class PruneCloseTracks {
    int scale;
    int imgWidth;
    int imgHeight;
    PointTrack[] pairImage;

    public PruneCloseTracks(int scale, int imgWidth, int imgHeight) {
        this.scale = scale;
        this.resize(imgWidth, imgHeight);
    }

    public void resize(int imgWidth, int imgHeight) {
        this.imgWidth = imgWidth;
        this.imgHeight = imgHeight;
        int w = imgWidth / this.scale + 1;
        int h = imgHeight / this.scale + 1;
        if (this.pairImage == null || this.pairImage.length < w * h) {
            this.pairImage = new PointTrack[w * h];
        }
    }

    public void process(List<PointTrack> tracks, List<PointTrack> dropTracks) {
        int i;
        int w = this.imgWidth / this.scale;
        int h = this.imgHeight / this.scale;
        int l = w * h;
        for (i = 0; i < l; ++i) {
            this.pairImage[i] = null;
        }
        for (i = 0; i < tracks.size(); ++i) {
            PointTrack p = tracks.get(i);
            int y = (int)(p.y / (double)this.scale);
            int x = (int)(p.x / (double)this.scale);
            int index = y * w + x;
            if (this.pairImage[index] == null) {
                this.pairImage[index] = p;
                continue;
            }
            dropTracks.add(p);
        }
    }
}

