/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.sfm.overhead;

import boofcv.alg.interpolate.InterpolatePixelS;
import boofcv.alg.interpolate.InterpolationType;
import boofcv.alg.sfm.overhead.CreateSyntheticOverheadView;
import boofcv.core.image.FactoryGImageGray;
import boofcv.core.image.GImageGray;
import boofcv.core.image.border.BorderType;
import boofcv.factory.interpolate.FactoryInterpolation;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.Planar;
import georegression.struct.point.Point2D_F32;

public class CreateSyntheticOverheadViewPL<T extends ImageGray<T>>
extends CreateSyntheticOverheadView<Planar<T>> {
    private InterpolatePixelS<T>[] interp;
    private GImageGray[] output;

    public CreateSyntheticOverheadViewPL(InterpolatePixelS<T>[] interp) {
        this.interp = interp;
        this.output = new GImageGray[interp.length];
    }

    public CreateSyntheticOverheadViewPL(InterpolationType type, int numBands, Class<T> imageType) {
        this.interp = new InterpolatePixelS[numBands];
        for (int i = 0; i < numBands; ++i) {
            this.interp[i] = FactoryInterpolation.createPixelS((double)0.0, (double)255.0, (InterpolationType)type, (BorderType)BorderType.EXTENDED, imageType);
        }
        this.output = new GImageGray[this.interp.length];
    }

    @Override
    public void process(Planar<T> input, Planar<T> output) {
        int N = input.getNumBands();
        for (int i = 0; i < N; ++i) {
            this.output[i] = FactoryGImageGray.wrap((ImageGray)output.getBand(i), (GImageGray)this.output[i]);
            this.interp[i].setImage((ImageBase)input.getBand(i));
        }
        int indexMap = 0;
        for (int i = 0; i < output.height; ++i) {
            int indexOut = output.startIndex + i * output.stride;
            int j = 0;
            while (j < output.width) {
                Point2D_F32 p = this.mapPixels[indexMap];
                if (p != null) {
                    for (int k = 0; k < N; ++k) {
                        this.output[k].set(indexOut, this.interp[k].get(p.x, p.y));
                    }
                }
                ++j;
                ++indexOut;
                ++indexMap;
            }
        }
    }
}

