/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo.pose;

import boofcv.alg.geo.DistanceFromModelMultiView;
import boofcv.alg.geo.NormalizedToPixelError;
import boofcv.struct.calib.CameraPinhole;
import boofcv.struct.calib.StereoParameters;
import boofcv.struct.sfm.Stereo2D3D;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point3D_F64;
import georegression.struct.se.Se3_F64;
import georegression.transform.se.SePointOps_F64;
import java.util.List;

public class PnPStereoDistanceReprojectionSq
implements DistanceFromModelMultiView<Se3_F64, Stereo2D3D> {
    private Se3_F64 worldToLeft;
    private Se3_F64 leftToRight;
    private Point3D_F64 X = new Point3D_F64();
    private NormalizedToPixelError leftPixelError;
    private NormalizedToPixelError rightPixelError;

    public void setLeftToRight(Se3_F64 leftToRight) {
        this.leftToRight = leftToRight.copy();
    }

    public void setModel(Se3_F64 worldToLeft) {
        this.worldToLeft = worldToLeft;
    }

    public double computeDistance(Stereo2D3D pt) {
        SePointOps_F64.transform((Se3_F64)this.worldToLeft, (Point3D_F64)pt.location, (Point3D_F64)this.X);
        if (this.X.z <= 0.0) {
            return Double.MAX_VALUE;
        }
        Point2D_F64 p = pt.leftObs;
        double errorLeft = this.leftPixelError.errorSq(this.X.x / this.X.z, this.X.y / this.X.z, p.x, p.y);
        SePointOps_F64.transform((Se3_F64)this.leftToRight, (Point3D_F64)this.X, (Point3D_F64)this.X);
        if (this.X.z <= 0.0) {
            return Double.MAX_VALUE;
        }
        p = pt.rightObs;
        double errorRight = this.rightPixelError.errorSq(this.X.x / this.X.z, this.X.y / this.X.z, p.x, p.y);
        return errorLeft + errorRight;
    }

    public void computeDistance(List<Stereo2D3D> observations, double[] distance) {
        for (int i = 0; i < observations.size(); ++i) {
            distance[i] = this.computeDistance(observations.get(i));
        }
    }

    public Class<Stereo2D3D> getPointType() {
        return Stereo2D3D.class;
    }

    public Class<Se3_F64> getModelType() {
        return Se3_F64.class;
    }

    public void setIntrinsic(int view, CameraPinhole intrinsic) {
        if (view == 0) {
            this.leftPixelError = new NormalizedToPixelError(intrinsic.fx, intrinsic.fy, intrinsic.skew);
        } else if (view == 1) {
            this.rightPixelError = new NormalizedToPixelError(intrinsic.fx, intrinsic.fy, intrinsic.skew);
        } else {
            throw new IllegalArgumentException("View must be 0 or 1");
        }
    }

    public int getNumberOfViews() {
        return 2;
    }

    public void setStereoParameters(StereoParameters param) {
        this.setLeftToRight(param.rightToLeft.invert(null));
        this.setIntrinsic(0, (CameraPinhole)param.left);
        this.setIntrinsic(1, (CameraPinhole)param.right);
    }
}

