/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.sfm.structure;

import boofcv.alg.sfm.structure.PairwiseImageGraph;
import boofcv.struct.feature.AssociatedIndex;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point3D_F64;
import georegression.struct.se.Se3_F64;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.ddogleg.struct.FastQueue;
import org.ddogleg.struct.GrowQueue_I32;
import org.ejml.data.DMatrixRMaj;

public class MetricSceneGraph {
    public List<View> nodes = new ArrayList<View>();
    public List<Motion> edges = new ArrayList<Motion>();
    public List<Feature3D> features3D = new ArrayList<Feature3D>();
    public Map<String, PairwiseImageGraph.Camera> cameras;

    public MetricSceneGraph(PairwiseImageGraph pairwise) {
        int i;
        this.cameras = pairwise.cameras;
        for (String key : this.cameras.keySet()) {
            if (this.cameras.get((Object)key).pixelToNorm != null) continue;
            throw new IllegalArgumentException("All cameras must be calibrated");
        }
        for (i = 0; i < pairwise.nodes.size(); ++i) {
            this.nodes.add(new View());
        }
        for (i = 0; i < pairwise.edges.size(); ++i) {
            this.edges.add(new Motion());
        }
        for (i = 0; i < pairwise.nodes.size(); ++i) {
            PairwiseImageGraph.View pv = pairwise.nodes.get(i);
            View v = this.nodes.get(i);
            v.camera = pv.camera;
            v.observationNorm = pv.observationNorm;
            v.observationPixels = pv.observationPixels;
            v.index = pv.index;
            v.features3D = new Feature3D[v.observationNorm.size];
            for (int j = 0; j < pv.connections.size(); ++j) {
                PairwiseImageGraph.Motion pm = pv.connections.get(j);
                if (pm.viewDst.index != v.index && pm.viewSrc.index != v.index) {
                    throw new RuntimeException("Invalid input");
                }
                v.connections.add(this.edges.get(pm.index));
            }
        }
        for (i = 0; i < pairwise.edges.size(); ++i) {
            PairwiseImageGraph.Motion pm = pairwise.edges.get(i);
            Motion m = this.edges.get(i);
            m.index = pm.index;
            m.associated = pm.associated;
            m.viewSrc = this.nodes.get(pm.viewSrc.index);
            m.viewDst = this.nodes.get(pm.viewDst.index);
            m.F = pm.F;
        }
    }

    public void sanityCheck() {
        for (View v : this.nodes) {
            for (Motion m : v.connections) {
                if (m.viewDst == v || m.viewSrc == v) continue;
                throw new RuntimeException("Not member of connection");
            }
        }
        for (Motion m : this.edges) {
            if (m.viewDst == m.destination(m.viewSrc)) continue;
            throw new RuntimeException("Unexpected result");
        }
    }

    public static class Feature3D {
        public Point3D_F64 worldPt = new Point3D_F64();
        public double triangulationAngle;
        public GrowQueue_I32 obsIdx = new GrowQueue_I32();
        public List<View> views = new ArrayList<View>();
        public int mark = -1;
    }

    public static class Motion {
        public Se3_F64 a_to_b = new Se3_F64();
        public List<Feature3D> stereoTriangulations = new ArrayList<Feature3D>();
        public double triangulationAngle;
        public int index;
        public DMatrixRMaj F;
        public List<AssociatedIndex> associated;
        public View viewSrc;
        public View viewDst;

        public double scoreTriangulation() {
            return (double)this.associated.size() * this.triangulationAngle;
        }

        public Se3_F64 motionSrcToDst(View src) {
            if (src == this.viewSrc) {
                return this.a_to_b.copy();
            }
            if (src == this.viewDst) {
                return this.a_to_b.invert(null);
            }
            throw new RuntimeException("BUG!");
        }

        public View destination(View src) {
            if (src == this.viewSrc) {
                return this.viewDst;
            }
            if (src == this.viewDst) {
                return this.viewSrc;
            }
            throw new RuntimeException("BUG!");
        }
    }

    static enum ViewState {
        UNPROCESSED,
        PENDING,
        PROCESSED;

    }

    public static class View {
        public Se3_F64 viewToWorld = new Se3_F64();
        public ViewState state = ViewState.UNPROCESSED;
        public List<Motion> connections = new ArrayList<Motion>();
        public FastQueue<Point2D_F64> observationPixels;
        public FastQueue<Point2D_F64> observationNorm;
        public Feature3D[] features3D;
        public PairwiseImageGraph.Camera camera;
        public int index;
    }
}

