/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.mvs;

import boofcv.abst.geo.bundle.BundleAdjustmentCamera;
import boofcv.abst.geo.bundle.SceneStructureCommon;
import boofcv.abst.geo.bundle.SceneStructureMetric;
import boofcv.alg.distort.brown.LensDistortionBrown;
import boofcv.alg.geo.bundle.BundleAdjustmentOps;
import boofcv.alg.mvs.ColorizeCloudFromImage;
import boofcv.alg.mvs.MultiViewStereoFromKnownSceneStructure;
import boofcv.alg.mvs.ScenePointsSetIterator;
import boofcv.core.image.LookUpColorRgb;
import boofcv.misc.BoofLambdas;
import boofcv.misc.BoofMiscOps;
import boofcv.misc.LookUpImages;
import boofcv.struct.calib.CameraPinholeBrown;
import boofcv.struct.distort.Point2Transform2_F64;
import boofcv.struct.geo.PointIndex4D_F64;
import boofcv.struct.image.ImageBase;
import georegression.struct.se.Se3_F64;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.ddogleg.struct.DogArray;
import org.ddogleg.struct.DogArray_I32;

public class ColorizeMultiViewStereoResults<T extends ImageBase<T>> {
    final ColorizeCloudFromImage<T> colorizer;
    final LookUpImages lookupImages;
    final T image;
    Se3_F64 world_to_view = new Se3_F64();
    Se3_F64 tmp = new Se3_F64();
    CameraPinholeBrown intrinsic = new CameraPinholeBrown();

    public ColorizeMultiViewStereoResults(LookUpColorRgb<T> colorLookup, LookUpImages lookupImages) {
        this.colorizer = new ColorizeCloudFromImage<T>(colorLookup);
        this.lookupImages = lookupImages;
        this.image = this.colorizer.getColorLookup().getImageType().createImage(1, 1);
    }

    public void processMvsCloud(SceneStructureMetric scene, MultiViewStereoFromKnownSceneStructure<?> mvs, BoofLambdas.IndexRgbConsumer indexColor) {
        List<MultiViewStereoFromKnownSceneStructure.ViewInfo> centers = mvs.getListCenters();
        DogArray cloud = mvs.getDisparityCloud().getCloud();
        for (int centerIdx = 0; centerIdx < centers.size(); ++centerIdx) {
            MultiViewStereoFromKnownSceneStructure.ViewInfo center = centers.get(centerIdx);
            if (!this.lookupImages.loadImage(center.relations.id, this.image)) {
                throw new RuntimeException("Couldn't find image: " + center.relations.id);
            }
            int idx0 = mvs.getDisparityCloud().viewPointIdx.get(centerIdx);
            int idx1 = mvs.getDisparityCloud().viewPointIdx.get(centerIdx + 1);
            BundleAdjustmentOps.convert((BundleAdjustmentCamera)scene.getViewCamera((SceneStructureMetric.View)center.metric).model, (int)((ImageBase)this.image).width, (int)((ImageBase)this.image).height, (CameraPinholeBrown)this.intrinsic);
            Point2Transform2_F64 norm_to_pixel = new LensDistortionBrown(this.intrinsic).distort_F64(false, true);
            scene.getWorldToView(center.metric, this.world_to_view, this.tmp);
            this.colorizer.process3(this.image, cloud.toList(), idx0, idx1, this.world_to_view, norm_to_pixel, indexColor);
        }
    }

    public void processScenePoints(SceneStructureMetric scene, BoofLambdas.IndexToString indexToId, BoofLambdas.IndexRgbConsumer indexColor) {
        ArrayList<DogArray_I32> lookupPointsByView = new ArrayList<DogArray_I32>();
        for (int i = 0; i < scene.views.size; ++i) {
            lookupPointsByView.add(new DogArray_I32());
        }
        for (int pointIdx = 0; pointIdx < scene.points.size; ++pointIdx) {
            SceneStructureCommon.Point p = (SceneStructureCommon.Point)scene.points.get(pointIdx);
            if (p.views.isEmpty()) continue;
            ((DogArray_I32)lookupPointsByView.get(p.views.get(0))).add(pointIdx);
        }
        ScenePointsSetIterator iterator = new ScenePointsSetIterator(new PointIndex4D_F64());
        Se3_F64 world_to_view = new Se3_F64();
        for (int viewIdx = 0; viewIdx < lookupPointsByView.size(); ++viewIdx) {
            BoofMiscOps.checkTrue((boolean)this.lookupImages.loadImage(indexToId.process(viewIdx), this.image), (String)"Failed to load image");
            iterator.initialize((SceneStructureCommon)scene, (DogArray_I32)lookupPointsByView.get(viewIdx));
            SceneStructureMetric.View v = (SceneStructureMetric.View)scene.views.get(viewIdx);
            BundleAdjustmentOps.convert((BundleAdjustmentCamera)scene.getViewCamera((SceneStructureMetric.View)v).model, (int)((ImageBase)this.image).width, (int)((ImageBase)this.image).height, (CameraPinholeBrown)this.intrinsic);
            Point2Transform2_F64 norm_to_pixel = new LensDistortionBrown(this.intrinsic).distort_F64(false, true);
            scene.getWorldToView(v, world_to_view, this.tmp);
            this.colorizer.process4(this.image, (Iterator<PointIndex4D_F64>)((Object)iterator), world_to_view, norm_to_pixel, indexColor);
        }
    }

    public ColorizeCloudFromImage<T> getColorizer() {
        return this.colorizer;
    }

    public LookUpImages getLookupImages() {
        return this.lookupImages;
    }
}

