/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.sfm.d3;

import boofcv.abst.tracker.PointTrack;
import boofcv.abst.tracker.PointTracker;
import boofcv.alg.sfm.overhead.CameraPlaneProjection;
import boofcv.factory.distort.LensDistortionFactory;
import boofcv.struct.calib.CameraModel;
import boofcv.struct.calib.CameraPinholeBrown;
import boofcv.struct.distort.Point2Transform2_F64;
import boofcv.struct.image.ImageBase;
import boofcv.struct.sfm.PlanePtPixel;
import georegression.geometry.GeometryMath_F64;
import georegression.metric.UtilAngle;
import georegression.struct.GeoTuple2D_F64;
import georegression.struct.GeoTuple3D_F64;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Vector3D_F64;
import georegression.struct.se.Se2_F64;
import georegression.struct.se.Se3_F64;
import georegression.transform.se.SePointOps_F64;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.ddogleg.fitting.modelset.ModelMatcher;
import org.ddogleg.struct.DogArray;
import org.ddogleg.struct.DogArray_F64;
import org.ejml.data.DMatrixRMaj;

public class VisOdomMonoPlaneInfinity<T extends ImageBase<T>> {
    private final ModelMatcher<Se2_F64, PlanePtPixel> planeMotion;
    private final DogArray<PlanePtPixel> planeSamples = new DogArray(PlanePtPixel::new);
    private final int thresholdAdd;
    private final int thresholdRetire;
    private final double thresholdPixelError;
    private boolean strictFar = false;
    private double thresholdFarAngleError;
    private Se3_F64 planeToCamera;
    private final Se3_F64 cameraToPlane = new Se3_F64();
    private final CameraPlaneProjection planeProjection = new CameraPlaneProjection();
    private final PointTracker<T> tracker;
    private Point2Transform2_F64 normToPixel;
    private Point2Transform2_F64 pixelToNorm;
    private final List<PointTrack> tracksFar = new ArrayList<PointTrack>();
    private final List<PointTrack> tracksOnPlane = new ArrayList<PointTrack>();
    private final Point2D_F64 n = new Point2D_F64();
    private final Point2D_F64 pixel = new Point2D_F64();
    private final Vector3D_F64 pointing = new Vector3D_F64();
    private final Vector3D_F64 pointingAdj = new Vector3D_F64();
    private final Point2D_F64 groundCurr = new Point2D_F64();
    private final Se2_F64 keyToWorld = new Se2_F64();
    private final Se2_F64 currToKey = new Se2_F64();
    private final Se2_F64 currToWorld = new Se2_F64();
    private final Se3_F64 currPlaneToWorld3D = new Se3_F64();
    private final Se3_F64 worldToCurrPlane3D = new Se3_F64();
    private final Se3_F64 worldToCurrCam3D = new Se3_F64();
    private final Se2_F64 temp = new Se2_F64();
    private final DogArray_F64 farAngles = new DogArray_F64();
    private final DogArray_F64 farAnglesCopy = new DogArray_F64();
    private double farAngle;
    private int farInlierCount;
    private Se2_F64 closeMotionKeyToCurr;
    private int closeInlierCount;
    private boolean first = true;

    public VisOdomMonoPlaneInfinity(int thresholdAdd, int thresholdRetire, double thresholdPixelError, ModelMatcher<Se2_F64, PlanePtPixel> planeMotion, PointTracker<T> tracker) {
        this.thresholdAdd = thresholdAdd;
        this.thresholdRetire = thresholdRetire;
        this.thresholdPixelError = thresholdPixelError;
        this.planeMotion = planeMotion;
        this.tracker = tracker;
    }

    public void setIntrinsic(CameraPinholeBrown intrinsic) {
        this.planeProjection.setIntrinsic(intrinsic);
        this.normToPixel = LensDistortionFactory.narrow((CameraModel)intrinsic).distort_F64(false, true);
        this.pixelToNorm = LensDistortionFactory.narrow((CameraModel)intrinsic).undistort_F64(true, false);
        this.thresholdFarAngleError = Math.atan2(this.thresholdPixelError, intrinsic.fx);
    }

    public void setExtrinsic(Se3_F64 planeToCamera) {
        this.planeToCamera = planeToCamera;
        planeToCamera.invert(this.cameraToPlane);
        this.planeProjection.setPlaneToCamera(planeToCamera, true);
    }

    public void reset() {
        this.first = true;
        this.tracker.reset();
        this.keyToWorld.reset();
        this.currToKey.reset();
        this.currToWorld.reset();
        this.worldToCurrCam3D.reset();
    }

    public boolean process(T image) {
        this.tracker.process(image);
        if (this.first) {
            this.addNewTracks();
            this.first = false;
        } else {
            this.sortTracksForEstimation();
            this.estimateFar();
            if (!this.estimateClose()) {
                return false;
            }
            this.fuseEstimates();
            this.dropUnusedTracks();
            if (this.thresholdAdd <= 0 || this.closeInlierCount < this.thresholdAdd) {
                this.changeCurrToReference();
                this.addNewTracks();
            }
        }
        return true;
    }

    private void addNewTracks() {
        this.tracker.spawnTracks();
        List spawned = this.tracker.getNewTracks(null);
        for (PointTrack t : spawned) {
            VoTrack p = (VoTrack)t.getCookie();
            if (p == null) {
                p = new VoTrack();
                t.cookie = p;
            }
            this.pixelToNorm.compute(t.pixel.x, t.pixel.y, this.n);
            if (this.planeProjection.normalToPlane(this.n.x, this.n.y, p.ground)) {
                p.onPlane = true;
            } else {
                this.pointing.setTo(this.n.x, this.n.y, 1.0);
                GeometryMath_F64.mult((DMatrixRMaj)this.cameraToPlane.getR(), (GeoTuple3D_F64)this.pointing, (GeoTuple3D_F64)this.pointing);
                this.pointing.normalize();
                double normXZ = Math.sqrt(this.pointing.x * this.pointing.x + this.pointing.z * this.pointing.z);
                p.pointingY = this.pointing.y / normXZ;
                p.ground.x = this.pointing.z;
                p.ground.y = -this.pointing.x;
                p.ground.x /= normXZ;
                p.ground.y /= normXZ;
                p.onPlane = false;
            }
            p.lastInlier = this.tracker.getFrameID();
        }
    }

    private int dropUnusedTracks() {
        List all = this.tracker.getAllTracks(null);
        int num = 0;
        long frameID = this.tracker.getFrameID();
        for (PointTrack t : all) {
            VoTrack p = (VoTrack)t.getCookie();
            if (frameID - p.lastInlier <= (long)this.thresholdRetire) continue;
            this.tracker.dropTrack(t);
            ++num;
        }
        return num;
    }

    private void sortTracksForEstimation() {
        this.planeSamples.reset();
        this.farAngles.reset();
        this.tracksOnPlane.clear();
        this.tracksFar.clear();
        List active = this.tracker.getActiveTracks(null);
        for (PointTrack t : active) {
            boolean allGood;
            VoTrack p = (VoTrack)t.getCookie();
            this.pixelToNorm.compute(t.pixel.x, t.pixel.y, this.n);
            this.pointing.setTo(this.n.x, this.n.y, 1.0);
            GeometryMath_F64.mult((DMatrixRMaj)this.cameraToPlane.getR(), (GeoTuple3D_F64)this.pointing, (GeoTuple3D_F64)this.pointing);
            this.pointing.normalize();
            if (p.onPlane) {
                if (!(this.pointing.y > 0.0)) continue;
                PlanePtPixel ppp = (PlanePtPixel)this.planeSamples.grow();
                ppp.normalizedCurr.setTo(this.n);
                ppp.planeKey.setTo(p.ground);
                this.tracksOnPlane.add(t);
                continue;
            }
            boolean bl = allGood = this.pointing.y < 0.0;
            if (this.strictFar) {
                allGood = this.isRotationFromAxisY(t, this.pointing);
            }
            if (!allGood) continue;
            this.computeAngleOfRotation(t, this.pointing);
            this.tracksFar.add(t);
        }
    }

    protected boolean isRotationFromAxisY(PointTrack t, Vector3D_F64 pointing) {
        VoTrack p = (VoTrack)t.getCookie();
        double normXZ = Math.sqrt(pointing.x * pointing.x + pointing.z * pointing.z);
        this.pointingAdj.setTo(pointing.x / normXZ, p.pointingY, pointing.z / normXZ);
        GeometryMath_F64.multTran((DMatrixRMaj)this.cameraToPlane.getR(), (GeoTuple3D_F64)this.pointingAdj, (GeoTuple3D_F64)this.pointingAdj);
        this.n.x = this.pointingAdj.x / this.pointingAdj.z;
        this.n.y = this.pointingAdj.y / this.pointingAdj.z;
        this.normToPixel.compute(this.n.x, this.n.y, this.pixel);
        double error = this.pixel.distance2((GeoTuple2D_F64)t.pixel);
        return error < this.thresholdPixelError * this.thresholdPixelError;
    }

    private void computeAngleOfRotation(PointTrack t, Vector3D_F64 pointingPlane) {
        VoTrack p = (VoTrack)t.getCookie();
        this.groundCurr.x = pointingPlane.z;
        this.groundCurr.y = -pointingPlane.x;
        double norm = this.groundCurr.norm();
        this.groundCurr.x /= norm;
        this.groundCurr.y /= norm;
        double dot = this.groundCurr.x * p.ground.x + this.groundCurr.y * p.ground.y;
        if (dot > 1.0) {
            dot = 1.0;
        }
        double angle = Math.acos(dot);
        if (this.groundCurr.x * p.ground.y - this.groundCurr.y * p.ground.x > 0.0) {
            angle = -angle;
        }
        this.farAngles.add(angle);
    }

    private void estimateFar() {
        this.farInlierCount = 0;
        if (this.farAngles.size == 0) {
            return;
        }
        this.farAnglesCopy.reset();
        this.farAnglesCopy.addAll(this.farAngles);
        this.farAngle = VisOdomMonoPlaneInfinity.maximizeCountInSpread(this.farAnglesCopy.data, this.farAngles.size, 2.0 * this.thresholdFarAngleError);
        for (int i = 0; i < this.tracksFar.size(); ++i) {
            PointTrack t = this.tracksFar.get(i);
            VoTrack p = (VoTrack)t.getCookie();
            if (!(UtilAngle.dist((double)this.farAngles.get(i), (double)this.farAngle) <= this.thresholdFarAngleError)) continue;
            p.lastInlier = this.tracker.getFrameID();
            ++this.farInlierCount;
        }
    }

    private boolean estimateClose() {
        if (!this.planeMotion.process(this.planeSamples.toList())) {
            return false;
        }
        this.closeMotionKeyToCurr = (Se2_F64)this.planeMotion.getModelParameters();
        this.closeInlierCount = this.planeMotion.getMatchSet().size();
        for (int i = 0; i < this.closeInlierCount; ++i) {
            int index = this.planeMotion.getInputIndex(i);
            VoTrack p = (VoTrack)this.tracksOnPlane.get(index).getCookie();
            p.lastInlier = this.tracker.getFrameID();
        }
        return true;
    }

    private void fuseEstimates() {
        double x = this.closeMotionKeyToCurr.c * (double)this.closeInlierCount + Math.cos(this.farAngle) * (double)this.farInlierCount;
        double y = this.closeMotionKeyToCurr.s * (double)this.closeInlierCount + Math.sin(this.farAngle) * (double)this.farInlierCount;
        this.closeMotionKeyToCurr.setYaw(Math.atan2(y, x));
        this.closeMotionKeyToCurr.invert(this.currToKey);
    }

    private void changeCurrToReference() {
        Se2_F64 keyToCurr = this.currToKey.invert(null);
        List all = this.tracker.getAllTracks(null);
        for (PointTrack t : all) {
            VoTrack p = (VoTrack)t.getCookie();
            if (p.onPlane) {
                SePointOps_F64.transform((Se2_F64)keyToCurr, (Point2D_F64)p.ground, (Point2D_F64)p.ground);
                continue;
            }
            GeometryMath_F64.rotate((double)keyToCurr.c, (double)keyToCurr.s, (GeoTuple2D_F64)p.ground, (GeoTuple2D_F64)p.ground);
        }
        this.concatMotion();
    }

    public long getFrameID() {
        return this.tracker.getFrameID();
    }

    private void concatMotion() {
        this.currToKey.concat(this.keyToWorld, this.temp);
        this.keyToWorld.setTo(this.temp);
        this.currToKey.reset();
    }

    public Se2_F64 getCurrToWorld2D() {
        this.currToKey.concat(this.keyToWorld, this.currToWorld);
        return this.currToWorld;
    }

    public Se3_F64 getWorldToCurr3D() {
        Se2_F64 currToWorld = this.getCurrToWorld2D();
        this.currPlaneToWorld3D.getT().setTo(-currToWorld.T.y, 0.0, currToWorld.T.x);
        DMatrixRMaj R = this.currPlaneToWorld3D.getR();
        R.unsafe_set(0, 0, currToWorld.c);
        R.unsafe_set(0, 2, -currToWorld.s);
        R.unsafe_set(1, 1, 1.0);
        R.unsafe_set(2, 0, currToWorld.s);
        R.unsafe_set(2, 2, currToWorld.c);
        this.currPlaneToWorld3D.invert(this.worldToCurrPlane3D);
        this.worldToCurrPlane3D.concat(this.planeToCamera, this.worldToCurrCam3D);
        return this.worldToCurrCam3D;
    }

    public static double maximizeCountInSpread(double[] data, int size, double maxSpread) {
        double s;
        int length;
        if (size <= 0) {
            return 0.0;
        }
        Arrays.sort(data, 0, size);
        for (length = 0; length < size && !((s = UtilAngle.dist((double)data[0], (double)data[length])) > maxSpread); ++length) {
        }
        int bestStart = 0;
        int bestLength = length;
        for (int start = 1; start < size && length < size; ++start) {
            double s2;
            --length;
            while (length < size && !((s2 = UtilAngle.dist((double)data[start], (double)data[(start + length) % size])) > maxSpread)) {
                ++length;
            }
            if (length <= bestLength) continue;
            bestLength = length;
            bestStart = start;
        }
        return data[(bestStart + bestLength / 2) % size];
    }

    public PointTracker<T> getTracker() {
        return this.tracker;
    }

    public boolean isStrictFar() {
        return this.strictFar;
    }

    public void setStrictFar(boolean strictFar) {
        this.strictFar = strictFar;
    }

    public static class VoTrack {
        double pointingY;
        public Point2D_F64 ground = new Point2D_F64();
        public long lastInlier;
        public boolean onPlane;
    }
}

