/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.sfm.d3;

import boofcv.abst.sfm.AccessPointTracks3D;
import boofcv.abst.sfm.d3.StereoVisualOdometry;
import boofcv.abst.tracker.PointTrack;
import boofcv.alg.geo.DistanceFromModelMultiView;
import boofcv.alg.sfm.StereoSparse3D;
import boofcv.alg.sfm.d3.VisOdomMonoDepthPnP;
import boofcv.struct.calib.CameraPinhole;
import boofcv.struct.calib.StereoParameters;
import boofcv.struct.geo.Point2D3D;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageType;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point3D_F64;
import georegression.struct.point.Point4D_F64;
import georegression.struct.se.Se3_F64;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class WrapVisOdomMonoStereoDepthPnP<T extends ImageGray<T>>
implements StereoVisualOdometry<T>,
AccessPointTracks3D {
    VisOdomMonoDepthPnP<T> alg;
    StereoSparse3D<T> stereo;
    DistanceFromModelMultiView<Se3_F64, Point2D3D> distance;
    Class<T> imageType;
    boolean success;
    List<PointTrack> active = new ArrayList<PointTrack>();

    public WrapVisOdomMonoStereoDepthPnP(VisOdomMonoDepthPnP<T> alg, StereoSparse3D<T> stereo, DistanceFromModelMultiView<Se3_F64, Point2D3D> distance, Class<T> imageType) {
        this.alg = alg;
        this.stereo = stereo;
        this.distance = distance;
        this.imageType = imageType;
    }

    @Override
    public boolean getTrackWorld3D(int index, Point3D_F64 world) {
        Point4D_F64 p = ((VisOdomMonoDepthPnP.Track)this.alg.getVisibleTracks().get((int)index)).worldLoc;
        world.setTo(p.x / p.w, p.y / p.w, p.z / p.w);
        return true;
    }

    @Override
    public int getTotalTracks() {
        return this.alg.getVisibleTracks().size();
    }

    @Override
    public long getTrackId(int index) {
        return ((VisOdomMonoDepthPnP.Track)this.alg.getVisibleTracks().get((int)index)).id;
    }

    @Override
    public void getTrackPixel(int index, Point2D_F64 pixel) {
        PointTrack track = Objects.requireNonNull(((VisOdomMonoDepthPnP.Track)this.alg.getVisibleTracks().get((int)index)).visualTrack);
        pixel.setTo(track.pixel);
    }

    @Override
    public List<Point2D_F64> getAllTracks(@Nullable List<Point2D_F64> storage) {
        throw new RuntimeException("Not supported any more");
    }

    @Override
    public boolean isTrackInlier(int index) {
        return this.alg.getInlierTracks().contains(this.alg.getVisibleTracks().get(index));
    }

    @Override
    public boolean isTrackNew(int index) {
        VisOdomMonoDepthPnP.Track track = (VisOdomMonoDepthPnP.Track)this.alg.getVisibleTracks().get(index);
        return Objects.requireNonNull(track.visualTrack).spawnFrameID == this.alg.getFrameID();
    }

    @Override
    public void setCalibration(StereoParameters parameters) {
        this.stereo.setCalibration(parameters);
        this.alg.setCamera(parameters.left);
        this.distance.setIntrinsic(0, (CameraPinhole)parameters.left);
    }

    @Override
    public boolean process(T leftImage, T rightImage) {
        this.stereo.setImages(leftImage, rightImage);
        this.success = this.alg.process(leftImage);
        this.active.clear();
        this.alg.getTracker().getActiveTracks(this.active);
        return this.success;
    }

    @Override
    public ImageType<T> getImageType() {
        return ImageType.single(this.imageType);
    }

    @Override
    public void reset() {
        this.alg.reset();
    }

    @Override
    public boolean isFault() {
        return !this.success;
    }

    @Override
    public Se3_F64 getCameraToWorld() {
        return this.alg.getCurrentToWorld();
    }

    @Override
    public long getFrameID() {
        return this.alg.getFrameID();
    }

    public VisOdomMonoDepthPnP<T> getAlgorithm() {
        return this.alg;
    }

    public void setVerbose(@Nullable PrintStream out, @Nullable Set<String> configuration) {
        this.alg.setVerbose(out, configuration);
    }
}

