/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.sfm.d3;

import boofcv.abst.feature.associate.AssociateDescription2D;
import boofcv.abst.feature.associate.AssociateDescriptionSets2D;
import boofcv.abst.feature.detdesc.DetectDescribePoint;
import boofcv.abst.geo.Triangulate2ViewsMetric;
import boofcv.abst.geo.TriangulateNViewsMetric;
import boofcv.abst.geo.bundle.MetricBundleAdjustmentUtils;
import boofcv.abst.geo.bundle.SceneObservations;
import boofcv.abst.geo.bundle.SceneStructureCommon;
import boofcv.abst.geo.bundle.SceneStructureMetric;
import boofcv.alg.descriptor.UtilFeature;
import boofcv.factory.distort.LensDistortionFactory;
import boofcv.factory.geo.ConfigTriangulation;
import boofcv.factory.geo.FactoryMultiView;
import boofcv.misc.BoofMiscOps;
import boofcv.misc.ConfigConverge;
import boofcv.struct.calib.CameraModel;
import boofcv.struct.calib.StereoParameters;
import boofcv.struct.distort.Point2Transform2_F64;
import boofcv.struct.feature.AssociatedIndex;
import boofcv.struct.feature.TupleDesc;
import boofcv.struct.image.ImageGray;
import boofcv.struct.sfm.Stereo2D3D;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point3D_F64;
import georegression.struct.se.Se3_F64;
import georegression.transform.se.SePointOps_F64;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.ddogleg.fitting.modelset.ModelFitter;
import org.ddogleg.fitting.modelset.ModelMatcher;
import org.ddogleg.struct.DogArray;
import org.ddogleg.struct.DogArray_I32;
import org.ddogleg.struct.FastAccess;
import org.ddogleg.struct.VerbosePrint;
import org.jetbrains.annotations.Nullable;

public class VisOdomStereoQuadPnP<T extends ImageGray<T>, TD extends TupleDesc<TD>>
implements VerbosePrint {
    private final Triangulate2ViewsMetric triangulate;
    private final TriangulateNViewsMetric triangulateN;
    private final ModelMatcher<Se3_F64, Stereo2D3D> matcher;
    @Nullable
    private final ModelFitter<Se3_F64, Stereo2D3D> modelRefiner;
    private final DogArray<Stereo2D3D> modelFitData = new DogArray(10, Stereo2D3D::new);
    private final MetricBundleAdjustmentUtils bundle = new MetricBundleAdjustmentUtils();
    private final DetectDescribePoint<T, TD> detector;
    private final AssociateDescriptionSets2D<TD> assocF2F;
    private final AssociateDescription2D<TD> assocL2R;
    private final DogArray<TrackQuad> trackQuads = new DogArray(TrackQuad::new, TrackQuad::reset);
    private ImageInfo featsLeft0;
    private ImageInfo featsLeft1;
    private ImageInfo featsRight0;
    private ImageInfo featsRight1;
    private final QuadMatches matches = new QuadMatches();
    private final Se3_F64 left_to_right = new Se3_F64();
    private final Se3_F64 right_to_left = new Se3_F64();
    private final StereoParameters stereoParameters = new StereoParameters();
    private Point2Transform2_F64 leftPixelToNorm;
    private Point2Transform2_F64 rightPixelToNorm;
    private final Se3_F64 curr_to_key = new Se3_F64();
    private final Se3_F64 left_to_world = new Se3_F64();
    private long frameID = -1L;
    private long totalTracks;
    private final DogArray_I32 keyToTrackIdx = new DogArray_I32();
    @Nullable
    protected PrintStream profileOut;
    @Nullable
    protected PrintStream verbose;
    private final Se3_F64 prevLeft_to_world = new Se3_F64();
    private final Point2D_F64 normLeft = new Point2D_F64();
    private final Point2D_F64 normRight = new Point2D_F64();
    private final Point3D_F64 X3 = new Point3D_F64();
    private final DogArray<Point2D_F64> listNorm = new DogArray(Point2D_F64::new);
    private final DogArray<Se3_F64> listWorldToView = new DogArray(Se3_F64::new);
    private final List<TrackQuad> inliers = new ArrayList<TrackQuad>();
    private final List<TrackQuad> consistentTracks = new ArrayList<TrackQuad>();
    private final Se3_F64 found = new Se3_F64();

    public VisOdomStereoQuadPnP(DetectDescribePoint<T, TD> detector, AssociateDescription2D<TD> assocF2F, AssociateDescription2D<TD> assocL2R, Triangulate2ViewsMetric triangulate, ModelMatcher<Se3_F64, Stereo2D3D> matcher, @Nullable ModelFitter<Se3_F64, Stereo2D3D> modelRefiner) {
        this.bundle.structure.setHomogenous(false);
        this.bundle.configConverge.setTo(new ConfigConverge(1.0E-5, 1.0E-5, 4));
        this.detector = detector;
        this.assocF2F = new AssociateDescriptionSets2D(assocF2F);
        this.assocL2R = assocL2R;
        this.triangulate = triangulate;
        this.matcher = matcher;
        this.modelRefiner = modelRefiner;
        this.featsLeft0 = new ImageInfo();
        this.featsLeft1 = new ImageInfo();
        this.featsRight0 = new ImageInfo();
        this.featsRight1 = new ImageInfo();
        this.triangulateN = FactoryMultiView.triangulateNViewMetric((ConfigTriangulation)ConfigTriangulation.GEOMETRIC());
        this.assocF2F.initializeSets(detector.getNumberOfSets());
        this.listNorm.resize(4);
        this.listWorldToView.resize(4);
    }

    public void setCalibration(StereoParameters param) {
        this.stereoParameters.setTo(param);
        this.right_to_left.setTo(param.right_to_left);
        this.right_to_left.invert(this.left_to_right);
        this.leftPixelToNorm = LensDistortionFactory.narrow((CameraModel)param.left).undistort_F64(true, false);
        this.rightPixelToNorm = LensDistortionFactory.narrow((CameraModel)param.right).undistort_F64(true, false);
    }

    public void reset() {
        this.featsLeft0.reset();
        this.featsLeft1.reset();
        this.featsRight0.reset();
        this.featsRight1.reset();
        this.matches.reset();
        this.curr_to_key.reset();
        this.left_to_world.reset();
        this.frameID = -1L;
        this.totalTracks = 0L;
        this.trackQuads.reset();
    }

    public boolean process(T left, T right) {
        if (this.frameID == -1L) {
            this.assocF2F.initializeAssociator(((ImageGray)left).width, ((ImageGray)left).height);
        }
        ++this.frameID;
        long time0 = System.nanoTime();
        this.detectFeatures(left, right);
        long time1 = System.nanoTime();
        this.associateL2R();
        if (this.frameID == 0L) {
            if (this.verbose != null) {
                this.verbose.println("first frame");
            }
            this.keyToTrackIdx.resize(this.featsLeft1.locationPixels.size);
            this.keyToTrackIdx.fill(-1);
        } else {
            long time2 = System.nanoTime();
            this.associateF2F();
            long time3 = System.nanoTime();
            this.cyclicConsistency();
            this.putConsistentTracksIntoList();
            long time4 = System.nanoTime();
            if (!this.robustMotionEstimate()) {
                if (this.verbose != null) {
                    this.verbose.println("Failed to estimate motion");
                }
                this.abortTrackingResetKeyFrame();
                return false;
            }
            Se3_F64 key_to_curr = (Se3_F64)this.matcher.getModelParameters();
            this.refineMotionEstimate(key_to_curr);
            this.triangulateWithFourCameras(key_to_curr);
            long time5 = System.nanoTime();
            this.performBundleAdjustment(key_to_curr);
            long time6 = System.nanoTime();
            this.performTrackMaintenance(key_to_curr);
            key_to_curr.invert(this.curr_to_key);
            this.prevLeft_to_world.setTo(this.left_to_world);
            this.curr_to_key.concat(this.prevLeft_to_world, this.left_to_world);
            long time7 = System.nanoTime();
            if (this.profileOut != null) {
                double milliDet = (double)(time1 - time0) * 1.0E-6;
                double milliL2R = (double)(time2 - time1) * 1.0E-6;
                double milliF2F = (double)(time3 - time2) * 1.0E-6;
                double milliCyc = (double)(time4 - time3) * 1.0E-6;
                double milliEst = (double)(time5 - time4) * 1.0E-6;
                double milliBun = (double)(time6 - time5) * 1.0E-6;
                double milliMnt = (double)(time7 - time6) * 1.0E-6;
                this.profileOut.printf("TIME: Det %5.1f L2R %5.1f F2F %5.1f Cyc %5.1f Est %5.1f Bun %5.1f Mnt %5.1f Total: %5.1f\n", milliDet, milliL2R, milliF2F, milliCyc, milliEst, milliBun, milliMnt, (double)(time7 - time0) * 1.0E-6);
            }
        }
        if (this.verbose != null && this.frameID != 0L) {
            int leftDetections = this.featsLeft1.locationPixels.size;
            int inliers = this.matcher.getMatchSet().size();
            int matchesL2R = this.assocL2R.getMatches().size;
            this.verbose.printf("Viso: Det: %4d L2R: %4d, Quad: %4d Inliers: %d\n", leftDetections, matchesL2R, this.trackQuads.size, inliers);
        }
        return true;
    }

    private void abortTrackingResetKeyFrame() {
        this.swapFeatureFrames();
        this.matches.swap();
    }

    private void putConsistentTracksIntoList() {
        this.consistentTracks.clear();
        for (int i = 0; i < this.trackQuads.size; ++i) {
            if (((TrackQuad)this.trackQuads.get((int)i)).leftCurrIndex == -1) continue;
            this.consistentTracks.add((TrackQuad)this.trackQuads.get(i));
        }
    }

    private void triangulateWithFourCameras(Se3_F64 key_to_curr) {
        ((Se3_F64)this.listWorldToView.get(0)).reset();
        ((Se3_F64)this.listWorldToView.get(1)).setTo(this.left_to_right);
        ((Se3_F64)this.listWorldToView.get(2)).setTo(key_to_curr);
        key_to_curr.concat(this.left_to_right, (Se3_F64)this.listWorldToView.get(3));
        for (int quadIdx = 0; quadIdx < this.consistentTracks.size(); ++quadIdx) {
            TrackQuad q = this.consistentTracks.get(quadIdx);
            this.leftPixelToNorm.compute(q.v0.x, q.v0.y, (Point2D_F64)this.listNorm.get(0));
            this.rightPixelToNorm.compute(q.v1.x, q.v1.y, (Point2D_F64)this.listNorm.get(1));
            this.leftPixelToNorm.compute(q.v2.x, q.v2.y, (Point2D_F64)this.listNorm.get(2));
            this.rightPixelToNorm.compute(q.v3.x, q.v3.y, (Point2D_F64)this.listNorm.get(3));
            if (!this.triangulateN.triangulate(this.listNorm.toList(), this.listWorldToView.toList(), this.X3)) {
                q.leftCurrIndex = -1;
                continue;
            }
            if (this.X3.z <= 0.0) {
                q.leftCurrIndex = -1;
                continue;
            }
            q.X.setTo(this.X3);
        }
    }

    private void performTrackMaintenance(Se3_F64 key_to_curr) {
        TrackQuad quad;
        int quadIdx;
        for (quadIdx = this.trackQuads.size - 1; quadIdx >= 0; --quadIdx) {
            quad = (TrackQuad)this.trackQuads.get(quadIdx);
            if (quad.leftCurrIndex == -1) {
                this.trackQuads.removeSwap(quadIdx);
                continue;
            }
            SePointOps_F64.transform((Se3_F64)key_to_curr, (Point3D_F64)quad.X, (Point3D_F64)quad.X);
            if (!(quad.X.z <= 0.0)) continue;
            this.trackQuads.removeSwap(quadIdx);
        }
        this.keyToTrackIdx.resize(this.featsLeft1.locationPixels.size);
        this.keyToTrackIdx.fill(-1);
        quadIdx = 0;
        while (quadIdx < this.trackQuads.size) {
            quad = (TrackQuad)this.trackQuads.get(quadIdx);
            this.keyToTrackIdx.data[quad.leftCurrIndex] = quadIdx++;
        }
    }

    private void detectFeatures(T left, T right) {
        this.swapFeatureFrames();
        this.featsLeft1.reset();
        this.featsRight1.reset();
        this.describeImage(left, this.featsLeft1);
        this.describeImage(right, this.featsRight1);
    }

    private void swapFeatureFrames() {
        ImageInfo tmp = this.featsLeft1;
        this.featsLeft1 = this.featsLeft0;
        this.featsLeft0 = tmp;
        tmp = this.featsRight1;
        this.featsRight1 = this.featsRight0;
        this.featsRight0 = tmp;
    }

    private void associateL2R() {
        this.matches.swap();
        this.matches.match2to3.reset();
        DogArray<Point2D_F64> leftLoc = this.featsLeft1.locationPixels;
        DogArray<Point2D_F64> rightLoc = this.featsRight1.locationPixels;
        this.assocL2R.setSource(leftLoc, this.featsLeft1.description);
        this.assocL2R.setDestination(rightLoc, this.featsRight1.description);
        this.assocL2R.associate();
        FastAccess found = this.assocL2R.getMatches();
        this.setMatches(this.matches.match2to3, (FastAccess<AssociatedIndex>)found, leftLoc.size);
    }

    private void associateF2F() {
        UtilFeature.setSource(this.featsLeft0.description, (DogArray_I32)this.featsLeft0.sets, this.featsLeft0.locationPixels, this.assocF2F);
        UtilFeature.setDestination(this.featsLeft1.description, (DogArray_I32)this.featsLeft1.sets, this.featsLeft1.locationPixels, this.assocF2F);
        this.assocF2F.associate();
        this.setMatches(this.matches.match0to2, (FastAccess<AssociatedIndex>)this.assocF2F.getMatches(), this.featsLeft0.locationPixels.size);
        UtilFeature.setSource(this.featsRight0.description, (DogArray_I32)this.featsRight0.sets, this.featsRight0.locationPixels, this.assocF2F);
        UtilFeature.setDestination(this.featsRight1.description, (DogArray_I32)this.featsRight1.sets, this.featsRight1.locationPixels, this.assocF2F);
        this.assocF2F.associate();
        this.setMatches(this.matches.match1to3, (FastAccess<AssociatedIndex>)this.assocF2F.getMatches(), this.featsRight0.locationPixels.size);
    }

    private void cyclicConsistency() {
        for (int i = 0; i < this.trackQuads.size; ++i) {
            ((TrackQuad)this.trackQuads.get((int)i)).leftCurrIndex = -1;
        }
        DogArray<Point2D_F64> obs0 = this.featsLeft0.locationPixels;
        DogArray<Point2D_F64> obs1 = this.featsRight0.locationPixels;
        DogArray<Point2D_F64> obs2 = this.featsLeft1.locationPixels;
        DogArray<Point2D_F64> obs3 = this.featsRight1.locationPixels;
        if (this.matches.match0to1.size != this.matches.match0to2.size) {
            throw new RuntimeException("Failed sanity check");
        }
        for (int indexIn0 = 0; indexIn0 < this.matches.match0to1.size; ++indexIn0) {
            TrackQuad quad;
            int indexIn1 = this.matches.match0to1.data[indexIn0];
            int indexIn2 = this.matches.match0to2.data[indexIn0];
            if (indexIn1 < 0 || indexIn2 < 0) continue;
            int indexIn3a = this.matches.match1to3.data[indexIn1];
            int indexIn3b = this.matches.match2to3.data[indexIn2];
            if (indexIn3a < 0 || indexIn3b < 0 || indexIn3a != indexIn3b) continue;
            int trackIdx = this.keyToTrackIdx.get(indexIn0);
            if (trackIdx == -1) {
                quad = (TrackQuad)this.trackQuads.grow();
                ++this.totalTracks;
                quad.id = quad.id;
                quad.firstSceneFrameID = this.frameID;
            } else {
                quad = (TrackQuad)this.trackQuads.get(trackIdx);
                quad.inlier = false;
            }
            quad.v0 = (Point2D_F64)obs0.get(indexIn0);
            quad.v1 = (Point2D_F64)obs1.get(indexIn1);
            quad.v2 = (Point2D_F64)obs2.get(indexIn2);
            quad.v3 = (Point2D_F64)obs3.get(indexIn3a);
            if (trackIdx == -1 && !this.triangulateTrackTwoViews(quad)) continue;
            quad.leftCurrIndex = indexIn2;
        }
    }

    private boolean triangulateTrackTwoViews(TrackQuad quad) {
        this.leftPixelToNorm.compute(quad.v0.x, quad.v0.y, this.normLeft);
        this.rightPixelToNorm.compute(quad.v1.x, quad.v1.y, this.normRight);
        boolean success = this.triangulate.triangulate(this.normLeft, this.normRight, this.left_to_right, quad.X);
        success &= !Double.isInfinite(quad.X.normSq());
        if (!(success &= quad.X.z > 0.0)) {
            this.trackQuads.removeTail();
            return false;
        }
        return true;
    }

    private void setMatches(DogArray_I32 matches, FastAccess<AssociatedIndex> found, int sizeSrc) {
        int j;
        matches.resize(sizeSrc);
        for (j = 0; j < sizeSrc; ++j) {
            matches.data[j] = -1;
        }
        for (j = 0; j < found.size; ++j) {
            AssociatedIndex a = (AssociatedIndex)found.get(j);
            matches.data[a.src] = a.dst;
        }
    }

    private void describeImage(T image, ImageInfo info) {
        this.detector.detect(image);
        DogArray<Point2D_F64> l = info.locationPixels;
        DogArray d = info.description;
        l.resize(this.detector.getNumberOfFeatures());
        d.resize(this.detector.getNumberOfFeatures());
        info.sets.resize(this.detector.getNumberOfFeatures());
        for (int i = 0; i < this.detector.getNumberOfFeatures(); ++i) {
            ((Point2D_F64[])l.data)[i].setTo(this.detector.getLocation(i));
            ((TupleDesc[])d.data)[i].setTo(this.detector.getDescription(i));
            info.sets.data[i] = this.detector.getSet(i);
        }
    }

    private boolean robustMotionEstimate() {
        this.modelFitData.reset();
        for (int i = 0; i < this.consistentTracks.size(); ++i) {
            TrackQuad quad = this.consistentTracks.get(i);
            Stereo2D3D data = (Stereo2D3D)this.modelFitData.grow();
            this.leftPixelToNorm.compute(quad.v2.x, quad.v2.y, data.leftObs);
            this.rightPixelToNorm.compute(quad.v3.x, quad.v3.y, data.rightObs);
            data.location.setTo(quad.X);
        }
        if (!this.matcher.process(this.modelFitData.toList())) {
            return false;
        }
        int numInliers = this.matcher.getMatchSet().size();
        for (int i = 0; i < numInliers; ++i) {
            this.consistentTracks.get((int)this.matcher.getInputIndex((int)i)).inlier = true;
        }
        return true;
    }

    private void refineMotionEstimate(Se3_F64 key_to_curr) {
        if (this.modelRefiner != null && this.modelRefiner.fitModel(this.matcher.getMatchSet(), (Object)key_to_curr, (Object)this.found)) {
            key_to_curr.setTo(this.found);
        }
    }

    private void performBundleAdjustment(Se3_F64 key_to_curr) {
        TrackQuad t;
        int trackIdx;
        if (this.bundle.configConverge.maxIterations <= 0) {
            return;
        }
        this.inliers.clear();
        for (int trackIdx2 = 0; trackIdx2 < this.consistentTracks.size(); ++trackIdx2) {
            TrackQuad t2 = this.consistentTracks.get(trackIdx2);
            if (t2.leftCurrIndex == -1 || !t2.inlier) continue;
            this.inliers.add(t2);
        }
        SceneStructureMetric structure = this.bundle.getStructure();
        SceneObservations observations = this.bundle.getObservations();
        observations.initialize(4);
        structure.initialize(2, 4, this.inliers.size());
        int baseline = structure.addMotion(true, this.left_to_right);
        structure.setCamera(0, true, this.stereoParameters.left);
        structure.setCamera(1, true, this.stereoParameters.right);
        structure.setView(0, 0, true, (Se3_F64)this.listWorldToView.get(0));
        structure.setView(1, 1, baseline, 0);
        structure.setView(2, 0, false, (Se3_F64)this.listWorldToView.get(2));
        structure.setView(3, 1, baseline, 2);
        for (trackIdx = 0; trackIdx < this.inliers.size(); ++trackIdx) {
            t = this.inliers.get(trackIdx);
            Point3D_F64 X = t.X;
            structure.setPoint(trackIdx, X.x, X.y, X.z);
            observations.getView(0).add(trackIdx, (float)t.v0.x, (float)t.v0.y);
            observations.getView(1).add(trackIdx, (float)t.v1.x, (float)t.v1.y);
            observations.getView(2).add(trackIdx, (float)t.v2.x, (float)t.v2.y);
            observations.getView(3).add(trackIdx, (float)t.v3.x, (float)t.v3.y);
        }
        if (!this.bundle.process()) {
            return;
        }
        for (trackIdx = 0; trackIdx < this.inliers.size(); ++trackIdx) {
            t = this.inliers.get(trackIdx);
            ((SceneStructureCommon.Point)structure.points.get(trackIdx)).get(t.X);
        }
        key_to_curr.setTo(structure.getParentToView(2));
    }

    public Se3_F64 getLeftToWorld() {
        return this.left_to_world;
    }

    public void setVerbose(@Nullable PrintStream out, @Nullable Set<String> configuration) {
        this.verbose = BoofMiscOps.addPrefix((VerbosePrint)this, (PrintStream)out);
        BoofMiscOps.verboseChildren((PrintStream)this.verbose, configuration, (VerbosePrint[])new VerbosePrint[]{this.bundle});
        this.profileOut = null;
        if (configuration == null) {
            return;
        }
        if (configuration.contains("runtime")) {
            this.profileOut = this.verbose;
        }
    }

    public ModelMatcher<Se3_F64, Stereo2D3D> getMatcher() {
        return this.matcher;
    }

    public MetricBundleAdjustmentUtils getBundle() {
        return this.bundle;
    }

    public DogArray<TrackQuad> getTrackQuads() {
        return this.trackQuads;
    }

    public long getFrameID() {
        return this.frameID;
    }

    @Nullable
    public PrintStream getProfileOut() {
        return this.profileOut;
    }

    public void setProfileOut(@Nullable PrintStream profileOut) {
        this.profileOut = profileOut;
    }

    @Nullable
    public PrintStream getVerbose() {
        return this.verbose;
    }

    public static class QuadMatches {
        DogArray_I32 match0to1 = new DogArray_I32(10);
        DogArray_I32 match0to2 = new DogArray_I32(10);
        DogArray_I32 match2to3 = new DogArray_I32(10);
        DogArray_I32 match1to3 = new DogArray_I32(10);

        public void swap() {
            DogArray_I32 tmp = this.match2to3;
            this.match2to3 = this.match0to1;
            this.match0to1 = tmp;
        }

        public void reset() {
            this.match0to1.reset();
            this.match0to2.reset();
            this.match2to3.reset();
            this.match1to3.reset();
        }
    }

    public class ImageInfo {
        DogArray<TD> description = new DogArray(() -> VisOdomStereoQuadPnP.this.detector.createDescription());
        DogArray_I32 sets = new DogArray_I32();
        DogArray<Point2D_F64> locationPixels = new DogArray(Point2D_F64::new);

        public void reset() {
            this.locationPixels.reset();
            this.description.reset();
            this.sets.reset();
        }
    }

    public static class TrackQuad {
        public long id;
        public int leftCurrIndex;
        public long firstSceneFrameID;
        public Point3D_F64 X = new Point3D_F64();
        public Point2D_F64 v0;
        public Point2D_F64 v1;
        public Point2D_F64 v2;
        public Point2D_F64 v3;
        public boolean inlier;

        public void reset() {
            this.X.setTo(0.0, 0.0, 0.0);
            this.v3 = null;
            this.v2 = null;
            this.v1 = null;
            this.v0 = null;
            this.inlier = false;
            this.id = -1L;
            this.leftCurrIndex = -1;
            this.firstSceneFrameID = -1L;
        }
    }
}

