/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.sfm.d2;

import boofcv.abst.sfm.AccessPointTracks;
import boofcv.abst.sfm.d2.ImageMotion2D;
import boofcv.abst.tracker.PointTrack;
import boofcv.alg.sfm.d2.AssociatedPairTrack;
import boofcv.alg.sfm.d2.ImageMotionPtkSmartRespawn;
import boofcv.struct.image.ImageBase;
import georegression.struct.InvertibleTransform;
import georegression.struct.point.Point2D_F64;
import java.util.ArrayList;
import java.util.List;
import org.ddogleg.struct.DogArray_B;
import org.jetbrains.annotations.Nullable;

public class WrapImageMotionPtkSmartRespawn<T extends ImageBase<T>, IT extends InvertibleTransform<IT>>
implements ImageMotion2D<T, IT>,
AccessPointTracks {
    ImageMotionPtkSmartRespawn<T, IT> alg;
    boolean first = true;
    List<Point2D_F64> allTracks = new ArrayList<Point2D_F64>();
    boolean inliersMarked = false;
    DogArray_B inliers = new DogArray_B(10);

    public WrapImageMotionPtkSmartRespawn(ImageMotionPtkSmartRespawn<T, IT> alg) {
        this.alg = alg;
    }

    @Override
    public boolean process(T input) {
        this.inliersMarked = false;
        boolean ret = this.alg.process(input);
        if (this.first) {
            this.alg.getMotion().changeKeyFrame();
            this.alg.getMotion().resetTransforms();
            this.first = false;
            return true;
        }
        return ret;
    }

    @Override
    public void reset() {
        this.first = true;
        this.alg.getMotion().reset();
    }

    @Override
    public void setToFirst() {
        this.alg.getMotion().changeKeyFrame();
        this.alg.getMotion().resetTransforms();
    }

    @Override
    public long getFrameID() {
        return this.alg.getMotion().getFrameID();
    }

    @Override
    public IT getFirstToCurrent() {
        return this.alg.getMotion().getWorldToCurr();
    }

    @Override
    public Class<IT> getTransformType() {
        return this.alg.getMotion().getModelType();
    }

    @Override
    public int getTotalTracks() {
        this.checkInitialize();
        return this.allTracks.size();
    }

    @Override
    public long getTrackId(int index) {
        return 0L;
    }

    @Override
    public void getTrackPixel(int index, Point2D_F64 pixel) {
        pixel.setTo(this.allTracks.get(index));
    }

    private void checkInitialize() {
        if (!this.inliersMarked) {
            this.inliersMarked = true;
            List active = this.alg.getMotion().getTracker().getActiveTracks(null);
            this.allTracks.clear();
            long tick = this.getFrameID();
            this.inliers.resize(active.size());
            for (int i = 0; i < active.size(); ++i) {
                PointTrack t = (PointTrack)active.get(i);
                AssociatedPairTrack info = (AssociatedPairTrack)((Object)t.getCookie());
                this.allTracks.add(t.pixel);
                this.inliers.data[i] = info.lastUsed == tick;
            }
        }
    }

    @Override
    public List<Point2D_F64> getAllTracks(@Nullable List<Point2D_F64> storage) {
        if (storage == null) {
            storage = new ArrayList<Point2D_F64>();
        } else {
            storage.clear();
        }
        this.checkInitialize();
        storage.addAll(this.allTracks);
        return storage;
    }

    @Override
    public boolean isTrackInlier(int index) {
        this.checkInitialize();
        return this.inliers.data[index];
    }

    @Override
    public boolean isTrackNew(int index) {
        return false;
    }
}

