/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.sfm.d3;

import boofcv.abst.sfm.DepthSparse3D_to_PixelTo3D;
import boofcv.abst.sfm.d3.DepthVisualOdometry;
import boofcv.alg.distort.AdjustmentType;
import boofcv.alg.distort.ImageDistort;
import boofcv.alg.distort.LensDistortionOps;
import boofcv.alg.distort.LensDistortionOps_F32;
import boofcv.alg.distort.PixelTransformCached_F32;
import boofcv.alg.sfm.DepthSparse3D;
import boofcv.alg.sfm.d3.direct.PyramidDirectColorDepth;
import boofcv.core.image.ConvertImageFilter;
import boofcv.factory.distort.LensDistortionFactory;
import boofcv.struct.border.BorderType;
import boofcv.struct.calib.CameraModel;
import boofcv.struct.calib.CameraPinhole;
import boofcv.struct.calib.CameraPinholeBrown;
import boofcv.struct.distort.PixelTransform;
import boofcv.struct.distort.Point2Transform2_F32;
import boofcv.struct.distort.SequencePoint2Transform2_F32;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageType;
import boofcv.struct.image.Planar;
import georegression.struct.ConvertFloatType;
import georegression.struct.point.Point2D_F32;
import georegression.struct.se.Se3_F32;
import georegression.struct.se.Se3_F64;
import java.io.PrintStream;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class PyramidDirectColorDepth_to_DepthVisualOdometry<T extends ImageBase<T>, Depth extends ImageGray<Depth>>
implements DepthVisualOdometry<T, Depth> {
    ImageType<T> inputType;
    Class<Depth> depthType;
    ImageType<Planar> algType;
    DepthSparse3D<Depth> sparse3D;
    DepthSparse3D_to_PixelTo3D<Depth> wrapSparse3D;
    ConvertImageFilter convertInput;
    Planar inputConverted;
    PyramidDirectColorDepth alg;
    ImageDistort<Planar, Planar> adjustImage;
    Planar undistorted;
    CameraPinhole paramAdjusted = new CameraPinhole();
    Se3_F32 worldToCurrent = new Se3_F32();
    Se3_F64 w2c_64 = new Se3_F64();

    public PyramidDirectColorDepth_to_DepthVisualOdometry(DepthSparse3D<Depth> sparse3D, PyramidDirectColorDepth alg, Class<Depth> depthType) {
        this.sparse3D = sparse3D;
        this.alg = alg;
        this.inputType = alg.getInputType();
        this.depthType = depthType;
        this.algType = alg.getInputType();
        this.undistorted = (Planar)this.algType.createImage(1, 1);
        this.wrapSparse3D = new DepthSparse3D_to_PixelTo3D<Depth>(sparse3D);
    }

    public PyramidDirectColorDepth_to_DepthVisualOdometry(DepthSparse3D<Depth> sparse3D, ConvertImageFilter<T, ?> convertImage, PyramidDirectColorDepth alg, Class<Depth> depthType) {
        this.sparse3D = sparse3D;
        this.alg = alg;
        this.inputType = convertImage.getInputType();
        this.algType = convertImage.getOutputType();
        this.depthType = depthType;
        this.convertInput = convertImage;
        this.inputConverted = (Planar)this.algType.createImage(1, 1);
        this.undistorted = (Planar)this.algType.createImage(1, 1);
        this.wrapSparse3D = new DepthSparse3D_to_PixelTo3D<Depth>(sparse3D);
    }

    @Override
    public void reset() {
        this.alg.reset();
    }

    @Override
    public boolean isFault() {
        return this.alg.isFatalError();
    }

    @Override
    public Se3_F64 getCameraToWorld() {
        this.alg.worldToCurrent().invert(this.worldToCurrent);
        ConvertFloatType.convert((Se3_F32)this.worldToCurrent, (Se3_F64)this.w2c_64);
        return this.w2c_64;
    }

    @Override
    public long getFrameID() {
        return this.alg.getFrameID();
    }

    @Override
    public void setCalibration(CameraPinholeBrown paramVisual, Point2Transform2_F32 visToDepth) {
        CameraPinhole desired = new CameraPinhole((CameraPinhole)paramVisual);
        desired.skew = 0.0;
        this.adjustImage = LensDistortionOps.changeCameraModel((AdjustmentType)AdjustmentType.EXPAND, (BorderType)BorderType.ZERO, (CameraPinhole)paramVisual, (CameraPinhole)desired, (CameraPinhole)this.paramAdjusted, this.algType);
        Point2Transform2_F32 desiredToOriginal = LensDistortionOps_F32.transformChangeModel((AdjustmentType)AdjustmentType.EXPAND, (CameraPinhole)paramVisual, (CameraPinhole)desired, (boolean)false, null);
        SequencePoint2Transform2_F32 adjustedToDepth = new SequencePoint2Transform2_F32(new Point2Transform2_F32[]{desiredToOriginal, visToDepth});
        PixelTransformCached_F32 pixelAdjToDepth = new PixelTransformCached_F32(this.paramAdjusted.width, this.paramAdjusted.height, (Point2Transform2_F32)adjustedToDepth);
        this.sparse3D.configure(LensDistortionFactory.narrow((CameraModel)this.paramAdjusted), (PixelTransform<Point2D_F32>)pixelAdjToDepth);
        this.undistorted.reshape(this.paramAdjusted.width, this.paramAdjusted.height);
        if (this.convertInput != null) {
            this.inputConverted.reshape(this.paramAdjusted.width, this.paramAdjusted.height);
        }
        this.alg.setCameraParameters((float)this.paramAdjusted.fx, (float)this.paramAdjusted.fy, (float)this.paramAdjusted.cx, (float)this.paramAdjusted.cy, this.paramAdjusted.width, this.paramAdjusted.height);
    }

    @Override
    public boolean process(T visual, Depth depth) {
        if (this.convertInput != null) {
            this.convertInput.process(visual, (ImageBase)this.inputConverted);
            this.adjustImage.apply((ImageBase)this.inputConverted, (ImageBase)this.undistorted);
        } else {
            this.adjustImage.apply((ImageBase)((Planar)visual), (ImageBase)this.undistorted);
        }
        this.sparse3D.setDepthImage(depth);
        return this.alg.process(this.undistorted, this.wrapSparse3D);
    }

    public double getFractionInBounds() {
        return this.alg.getFractionInBounds();
    }

    @Override
    public ImageType<T> getVisualType() {
        return this.inputType;
    }

    @Override
    public Class<Depth> getDepthType() {
        return this.depthType;
    }

    public Planar getUndistorted() {
        return this.undistorted;
    }

    public void setVerbose(@Nullable PrintStream out, @Nullable Set<String> configuration) {
    }
}

