/*
 * Decompiled with CFR 0.152.
 */
package boofcv.gui;

import boofcv.struct.ConfigLength;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.NumberFormat;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JFormattedTextField;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class JConfigLength
extends JPanel
implements PropertyChangeListener,
ActionListener,
ChangeListener {
    JCheckBox toggleFixed = new JCheckBox();
    JSpinner spinnerFraction = new JSpinner(new SpinnerNumberModel(0.1, 0.0, 1.0, 0.01));
    JFormattedTextField textLength;
    boolean integerMode;
    boolean modeRelative = true;
    ConfigLength valueFraction = new ConfigLength(1.0, 0.1);
    ConfigLength valueFixed = new ConfigLength(1.0, -1.0);
    Listener listener;
    double minimumLength = -1.7976931348623157E308;
    double maximumLength = Double.MAX_VALUE;

    public JConfigLength(Listener listener, boolean integerMode) {
        this.setLayout(new BoxLayout(this, 0));
        this.listener = listener;
        this.integerMode = integerMode;
        this.textLength = integerMode ? new JFormattedTextField(NumberFormat.getIntegerInstance()) : new JFormattedTextField(NumberFormat.getNumberInstance());
        this.toggleFixed.setSelected(this.modeRelative);
        this.toggleFixed.addActionListener(this);
        this.toggleFixed.setMaximumSize(this.toggleFixed.getPreferredSize());
        this.spinnerFraction.setValue(this.valueFraction.fraction);
        JFormattedTextField jftf = ((JSpinner.DefaultEditor)this.spinnerFraction.getEditor()).getTextField();
        jftf.setColumns(3);
        this.spinnerFraction.addChangeListener(this);
        this.textLength.setValue(this.valueFraction.length);
        this.textLength.setColumns(4);
        this.textLength.addPropertyChangeListener("value", this);
        this.add(this.toggleFixed);
        this.add(this.spinnerFraction);
        this.add(this.textLength);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (enabled) {
            this.toggleFixed.setEnabled(true);
            if (this.modeRelative) {
                this.toggleFixed.setEnabled(true);
            }
            this.textLength.setEnabled(true);
        } else {
            this.toggleFixed.setEnabled(false);
            this.spinnerFraction.setEnabled(false);
            this.textLength.setEnabled(false);
        }
    }

    public void setLengthBounds(double min, double max) {
        this.minimumLength = min;
        this.maximumLength = max;
    }

    public void setValue(ConfigLength v) {
        this.handleModeChange(v.isRelative(), false);
        this.updateValues(v.fraction, v.length);
    }

    private void updateValues(double fraction, double length) {
        this.spinnerFraction.removeChangeListener(this);
        this.textLength.removePropertyChangeListener("value", this);
        if (this.modeRelative) {
            this.valueFraction.fraction = fraction;
            this.valueFraction.length = length;
            this.spinnerFraction.setEnabled(true);
            this.spinnerFraction.setValue(fraction);
        } else {
            this.valueFixed.length = length;
            this.spinnerFraction.setEnabled(false);
            this.spinnerFraction.setValue(0);
        }
        if (this.integerMode) {
            this.textLength.setValue((int)length);
        } else {
            this.textLength.setValue(length);
        }
        this.spinnerFraction.addChangeListener(this);
        this.textLength.addPropertyChangeListener("value", this);
    }

    private void handleModeChange(boolean relative, boolean updateValues) {
        if (this.modeRelative == relative) {
            return;
        }
        this.modeRelative = relative;
        this.toggleFixed.removeActionListener(this);
        this.toggleFixed.setSelected(relative);
        this.toggleFixed.addActionListener(this);
        if (updateValues) {
            if (this.modeRelative) {
                this.updateValues(this.valueFraction.fraction, this.valueFraction.length);
            } else {
                this.updateValues(this.valueFixed.fraction, this.valueFixed.length);
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        boolean boundsIssue;
        double l = ((Number)this.textLength.getValue()).doubleValue();
        boolean bl = boundsIssue = l < this.minimumLength || l > this.maximumLength;
        if (boundsIssue) {
            l = Math.min(this.maximumLength, Math.max(this.minimumLength, l));
        }
        if (this.modeRelative) {
            this.valueFraction.length = l;
        } else {
            this.valueFixed.length = l;
        }
        if (boundsIssue) {
            this.textLength.removePropertyChangeListener("value", this);
            if (this.integerMode) {
                this.textLength.setValue((int)l);
            } else {
                this.textLength.setValue(l);
            }
            this.textLength.addPropertyChangeListener("value", this);
        }
        this.notifyListener();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.toggleFixed) {
            this.handleModeChange(this.toggleFixed.isSelected(), true);
            this.notifyListener();
        }
    }

    public ConfigLength getValue() {
        if (this.modeRelative) {
            return this.valueFraction;
        }
        return this.valueFixed;
    }

    public void notifyListener() {
        if (this.modeRelative) {
            this.listener.changeConfigLength(this, this.valueFraction.fraction, this.valueFraction.length);
        } else {
            this.listener.changeConfigLength(this, -1.0, this.valueFixed.length);
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (e.getSource() == this.spinnerFraction && this.modeRelative) {
            this.valueFraction.fraction = ((Number)this.spinnerFraction.getValue()).doubleValue();
            this.notifyListener();
        }
    }

    public static interface Listener {
        public void changeConfigLength(JConfigLength var1, double var2, double var4);
    }
}

