/*
 * Decompiled with CFR 0.152.
 */
package boofcv.gui.calibration;

import boofcv.abst.geo.calibration.ImageResults;
import boofcv.alg.geo.calibration.CalibrationObservation;
import boofcv.alg.geo.calibration.Zhang99AllParam;
import boofcv.gui.BoofSwingUtil;
import boofcv.gui.StandardAlgConfigPanel;
import boofcv.gui.ViewedImageInfoPanel;
import boofcv.gui.calibration.DisplayCalibrationPanel;
import boofcv.io.image.UtilImageIO;
import boofcv.struct.calib.CameraModel;
import java.awt.BorderLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionListener;

public abstract class CalibratedPlanarPanel<CM extends CameraModel>
extends JPanel
implements ListSelectionListener,
ItemListener,
ChangeListener {
    JCheckBox checkPoints;
    JCheckBox checkErrors;
    JCheckBox checkUndistorted;
    JCheckBox checkAll;
    JCheckBox checkNumbers;
    JCheckBox checkOrder;
    JSpinner selectErrorScale;
    JTextArea meanError;
    JTextArea maxError;
    boolean showPoints = false;
    boolean showErrors = true;
    boolean showUndistorted = false;
    boolean showAll = false;
    boolean showNumbers = false;
    boolean showOrder = true;
    int errorScale = 20;
    ViewedImageInfoPanel viewInfo = new ViewedImageInfoPanel();
    public DisplayCalibrationPanel<CM> mainView;
    JList imageList;
    protected List<String> imagePaths = new ArrayList<String>();
    protected List<CalibrationObservation> features = new ArrayList<CalibrationObservation>();
    protected List<ImageResults> results = new ArrayList<ImageResults>();
    protected int selectedImage;
    Vector<String> imageNames = new Vector();

    public CalibratedPlanarPanel() {
        super(new BorderLayout());
        this.meanError = this.createErrorComponent(1);
        this.maxError = this.createErrorComponent(1);
    }

    public void setObservations(List<CalibrationObservation> features) {
        this.features = features;
    }

    public void setResults(List<ImageResults> results) {
        this.results = results;
        this.setSelected(this.selectedImage);
    }

    public void showImageProcessed(final BufferedImage image) {
        BoofSwingUtil.invokeNowOrLater(new Runnable(){

            @Override
            public void run() {
                CalibratedPlanarPanel.this.mainView.setBufferedImage(image);
                double zoom = BoofSwingUtil.selectZoomToShowAll(CalibratedPlanarPanel.this.mainView, image.getWidth(), image.getHeight());
                CalibratedPlanarPanel.this.mainView.setScale(zoom);
                CalibratedPlanarPanel.this.mainView.repaint();
            }
        });
    }

    public void addImage(File filePath) {
        this.imagePaths.add(filePath.getPath());
        this.imageNames.add(filePath.getName());
        BoofSwingUtil.invokeNowOrLater(new Runnable(){

            @Override
            public void run() {
                CalibratedPlanarPanel.this.imageList.removeListSelectionListener(CalibratedPlanarPanel.this);
                CalibratedPlanarPanel.this.imageList.setListData(CalibratedPlanarPanel.this.imageNames);
                if (CalibratedPlanarPanel.this.imageNames.size() == 1) {
                    CalibratedPlanarPanel.this.imageList.addListSelectionListener(CalibratedPlanarPanel.this);
                    CalibratedPlanarPanel.this.imageList.setSelectedIndex(0);
                    CalibratedPlanarPanel.this.validate();
                } else {
                    CalibratedPlanarPanel.this.imageList.setSelectedIndex(CalibratedPlanarPanel.this.selectedImage);
                    CalibratedPlanarPanel.this.imageList.addListSelectionListener(CalibratedPlanarPanel.this);
                }
            }
        });
    }

    public void setImages(List<File> imageFiles) {
        for (File f : imageFiles) {
            this.addImage(f);
        }
    }

    public void setImagesFailed(List<File> imageFiles) {
        for (File file : imageFiles) {
        }
    }

    protected void setSelected(int selected) {
        BoofSwingUtil.checkGuiThread();
        long start = System.currentTimeMillis();
        BufferedImage image = UtilImageIO.loadImage((String)this.imagePaths.get(selected));
        if (image == null) {
            throw new RuntimeException("Couldn't load image!");
        }
        long stop = System.currentTimeMillis();
        System.out.println("Time to load image " + (stop - start) + " (ms)");
        if (selected < this.features.size()) {
            this.mainView.setResults(this.features.get(selected), this.results.get(selected), this.features);
        }
        this.mainView.setBufferedImage(image);
        double zoom = BoofSwingUtil.selectZoomToShowAll(this.mainView, image.getWidth(), image.getHeight());
        this.mainView.setScale(zoom);
        this.mainView.repaint();
        this.selectedImage = selected;
        this.viewInfo.setImageSize(image.getWidth(), image.getHeight());
        if (this.results != null) {
            this.updateResultsGUI();
        }
    }

    protected abstract void updateResultsGUI();

    public abstract void setCalibration(Zhang99AllParam var1);

    public abstract void setCorrection(CM var1);

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() == this.checkPoints) {
            this.showPoints = this.checkPoints.isSelected();
        } else if (e.getSource() == this.checkErrors) {
            this.showErrors = this.checkErrors.isSelected();
        } else if (e.getSource() == this.checkAll) {
            this.showAll = this.checkAll.isSelected();
        } else if (e.getSource() == this.checkUndistorted) {
            this.showUndistorted = this.checkUndistorted.isSelected();
        } else if (e.getSource() == this.checkNumbers) {
            this.showNumbers = this.checkNumbers.isSelected();
        } else if (e.getSource() == this.checkOrder) {
            this.showOrder = this.checkOrder.isSelected();
        }
        this.mainView.setDisplay(this.showPoints, this.showErrors, this.showUndistorted, this.showAll, this.showNumbers, this.showOrder, this.errorScale);
        this.mainView.repaint();
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (e.getSource() == this.selectErrorScale) {
            this.errorScale = ((Number)this.selectErrorScale.getValue()).intValue();
        }
        this.mainView.setDisplay(this.showPoints, this.showErrors, this.showUndistorted, this.showAll, this.showNumbers, this.showOrder, this.errorScale);
        this.mainView.repaint();
    }

    JTextArea createErrorComponent(int numRows) {
        JTextArea comp = new JTextArea(numRows, 6);
        comp.setMaximumSize(comp.getPreferredSize());
        comp.setEditable(false);
        comp.setBorder(BorderFactory.createEmptyBorder(0, 0, 4, 0));
        return comp;
    }

    class RightPanel
    extends StandardAlgConfigPanel {
        public RightPanel() {
            CalibratedPlanarPanel.this.checkPoints = new JCheckBox("Show Points");
            CalibratedPlanarPanel.this.checkPoints.setSelected(CalibratedPlanarPanel.this.showPoints);
            CalibratedPlanarPanel.this.checkPoints.addItemListener(CalibratedPlanarPanel.this);
            CalibratedPlanarPanel.this.checkErrors = new JCheckBox("Show Errors");
            CalibratedPlanarPanel.this.checkErrors.setSelected(CalibratedPlanarPanel.this.showErrors);
            CalibratedPlanarPanel.this.checkErrors.addItemListener(CalibratedPlanarPanel.this);
            CalibratedPlanarPanel.this.checkAll = new JCheckBox("All Points");
            CalibratedPlanarPanel.this.checkAll.setSelected(CalibratedPlanarPanel.this.showAll);
            CalibratedPlanarPanel.this.checkAll.addItemListener(CalibratedPlanarPanel.this);
            CalibratedPlanarPanel.this.checkUndistorted = new JCheckBox("Undistort");
            CalibratedPlanarPanel.this.checkUndistorted.setSelected(CalibratedPlanarPanel.this.showUndistorted);
            CalibratedPlanarPanel.this.checkUndistorted.addItemListener(CalibratedPlanarPanel.this);
            CalibratedPlanarPanel.this.checkUndistorted.setEnabled(false);
            CalibratedPlanarPanel.this.checkNumbers = new JCheckBox("Numbers");
            CalibratedPlanarPanel.this.checkNumbers.setSelected(CalibratedPlanarPanel.this.showNumbers);
            CalibratedPlanarPanel.this.checkNumbers.addItemListener(CalibratedPlanarPanel.this);
            CalibratedPlanarPanel.this.checkOrder = new JCheckBox("Order");
            CalibratedPlanarPanel.this.checkOrder.setSelected(CalibratedPlanarPanel.this.showOrder);
            CalibratedPlanarPanel.this.checkOrder.addItemListener(CalibratedPlanarPanel.this);
            CalibratedPlanarPanel.this.selectErrorScale = new JSpinner(new SpinnerNumberModel(CalibratedPlanarPanel.this.errorScale, 1, 100, 5));
            CalibratedPlanarPanel.this.selectErrorScale.addChangeListener(CalibratedPlanarPanel.this);
            CalibratedPlanarPanel.this.selectErrorScale.setMaximumSize(CalibratedPlanarPanel.this.selectErrorScale.getPreferredSize());
            this.add(CalibratedPlanarPanel.this.viewInfo);
            RightPanel.addAlignLeft(CalibratedPlanarPanel.this.checkPoints, this);
            RightPanel.addAlignLeft(CalibratedPlanarPanel.this.checkErrors, this);
            RightPanel.addAlignLeft(CalibratedPlanarPanel.this.checkAll, this);
            RightPanel.addAlignLeft(CalibratedPlanarPanel.this.checkUndistorted, this);
            RightPanel.addAlignLeft(CalibratedPlanarPanel.this.checkNumbers, this);
            RightPanel.addAlignLeft(CalibratedPlanarPanel.this.checkOrder, this);
            RightPanel.addLabeled(CalibratedPlanarPanel.this.selectErrorScale, "Error Scale", this);
        }
    }
}

