/*
 * Decompiled with CFR 0.152.
 */
package boofcv.gui;

import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.io.File;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.prefs.Preferences;
import javax.imageio.ImageIO;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFormattedTextField;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.text.NumberFormatter;

public class BoofSwingUtil {
    public static final String KEY_RECENT_FILES = "RecentFiles";
    public static final String KEY_PREVIOUS_SELECTION = "PreviouslySelected";
    public static final double MIN_ZOOM = 0.01;
    public static final double MAX_ZOOM = 50.0;

    public static File saveFileChooser(Component parent, FileTypes ... filters) {
        return BoofSwingUtil.fileChooser(parent, false, new File(".").getPath(), filters);
    }

    public static File openFileChooser(Component parent, FileTypes ... filters) {
        return BoofSwingUtil.openFileChooser(parent, new File(".").getPath(), filters);
    }

    public static File openFileChooser(Component parent, String defaultPath, FileTypes ... filters) {
        return BoofSwingUtil.fileChooser(parent, true, defaultPath, filters);
    }

    public static File fileChooser(Component parent, boolean openFile, String defaultPath, FileTypes ... filters) {
        int returnVal;
        Preferences prefs = parent == null ? Preferences.userRoot() : Preferences.userRoot().node(parent.getClass().getSimpleName());
        String previousPath = prefs.get(KEY_PREVIOUS_SELECTION, defaultPath);
        JFileChooser chooser = new JFileChooser(previousPath);
        chooser.setSelectedFile(new File(previousPath));
        for (FileTypes t : filters) {
            FileNameExtensionFilter ff;
            switch (t) {
                case IMAGES: {
                    ff = new FileNameExtensionFilter("Images", ImageIO.getReaderFileSuffixes());
                    break;
                }
                case VIDEOS: {
                    ff = new FileNameExtensionFilter("Videos", "mpg", "mp4", "mov", "avi", "wmv");
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown file type");
                }
            }
            chooser.addChoosableFileFilter(ff);
        }
        if (filters.length > 0) {
            chooser.setFileFilter(chooser.getChoosableFileFilters()[1]);
        }
        File selected = null;
        int n = returnVal = openFile ? chooser.showOpenDialog(parent) : chooser.showSaveDialog(parent);
        if (returnVal == 0) {
            selected = chooser.getSelectedFile();
            prefs.put(KEY_PREVIOUS_SELECTION, selected.getPath());
        }
        return selected;
    }

    public static List<String> getListOfRecentFiles(Component parent) {
        Preferences prefs = Preferences.userRoot().node(parent.getClass().getSimpleName());
        String encodedString = prefs.get(KEY_RECENT_FILES, "");
        String[] fileNames = encodedString.split("\n");
        ArrayList<String> output = new ArrayList<String>();
        for (String f : fileNames) {
            output.add(f);
        }
        return output;
    }

    public static void addToRecentFiles(Component parent, String filePath) {
        List<String> files = BoofSwingUtil.getListOfRecentFiles(parent);
        files.remove(filePath);
        if (files.size() >= 10) {
            files.remove(9);
        }
        files.add(0, filePath);
        String encoded = "";
        for (int i = 0; i < files.size(); ++i) {
            encoded = encoded + files.get(i);
            if (i >= files.size() - 1) continue;
            encoded = encoded + "\n";
        }
        Preferences prefs = Preferences.userRoot().node(parent.getClass().getSimpleName());
        prefs.put(KEY_RECENT_FILES, encoded);
    }

    public static void invokeNowOrLater(Runnable r) {
        if (SwingUtilities.isEventDispatchThread()) {
            r.run();
        } else {
            SwingUtilities.invokeLater(r);
        }
    }

    public static void checkGuiThread() {
        if (!SwingUtilities.isEventDispatchThread()) {
            throw new RuntimeException("Must be run in UI thread");
        }
    }

    public static double selectZoomToShowAll(JComponent panel, int width, int height) {
        double scale;
        int w = panel.getWidth();
        int h = panel.getHeight();
        if (w == 0) {
            w = panel.getPreferredSize().width;
            h = panel.getPreferredSize().height;
        }
        if ((scale = Math.max((double)width / (double)w, (double)height / (double)h)) > 1.0) {
            return 1.0 / scale;
        }
        return 1.0;
    }

    public static JFormattedTextField createTextField(int current, int min, int max) {
        NumberFormat format = NumberFormat.getInstance();
        NumberFormatter formatter = new NumberFormatter(format);
        formatter.setValueClass(Integer.class);
        formatter.setMinimum(Integer.valueOf(min));
        formatter.setMaximum(Integer.valueOf(max));
        formatter.setAllowsInvalid(true);
        JFormattedTextField field = new JFormattedTextField(formatter);
        field.setHorizontalAlignment(4);
        field.setValue(current);
        return field;
    }

    public static JFormattedTextField createTextField(double current, double min, double max) {
        NumberFormat format = NumberFormat.getInstance();
        NumberFormatter formatter = new NumberFormatter(format);
        formatter.setValueClass(Double.class);
        if (!Double.isNaN(min)) {
            formatter.setMinimum(Double.valueOf(min));
        }
        if (!Double.isNaN(max)) {
            formatter.setMaximum(Double.valueOf(max));
        }
        formatter.setAllowsInvalid(true);
        JFormattedTextField field = new JFormattedTextField(formatter);
        field.setHorizontalAlignment(4);
        field.setValue(current);
        return field;
    }

    public static void setMenuItemKeys(JMenuItem menu, int mnmonic, int accelerator) {
        menu.setMnemonic(mnmonic);
        menu.setAccelerator(KeyStroke.getKeyStroke(accelerator, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
    }

    public static void warningDialog(Component component, Exception e) {
        JOptionPane.showMessageDialog(component, e.getMessage());
    }

    public static void antialiasing(Graphics2D g2) {
        g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
    }

    public static enum FileTypes {
        IMAGES,
        VIDEOS;

    }
}

