/*
 * Decompiled with CFR 0.152.
 */
package boofcv.gui;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Line2D;
import javax.swing.JPanel;

public class PlotXyPanel
extends JPanel {
    public double[] valuesY = new double[0];
    public double minY;
    public double maxY;
    public double scaleX = 1.0;
    public double offsetX = 0.0;
    protected Line2D.Double line = new Line2D.Double();

    public PlotXyPanel(double[] valuesY, double minY, double maxY) {
        this.setBackground(Color.WHITE);
        this.valuesY = (double[])valuesY.clone();
        this.minY = minY;
        this.maxY = maxY;
    }

    public PlotXyPanel() {
        this.setBackground(Color.WHITE);
    }

    @Override
    public void paintComponent(Graphics g) {
        int i;
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setColor(Color.BLACK);
        g2.setStroke(new BasicStroke(1.0f));
        double h = this.getHeight() - 1;
        double rangeY = this.maxY - this.minY;
        double mh = h * 0.1;
        g2.setColor(Color.LIGHT_GRAY);
        for (i = 0; i < this.valuesY.length; ++i) {
            double y = this.valuesY[i];
            double pixelY = h * (1.0 - (y - this.minY) / rangeY);
            double pixelX = this.scaleX * ((double)i - this.offsetX);
            this.line.setLine(pixelX, pixelY - mh, pixelX, pixelY + mh);
            g2.draw(this.line);
        }
        g2.setColor(Color.BLACK);
        for (i = 1; i < this.valuesY.length; ++i) {
            double y0 = this.valuesY[i - 1];
            double y1 = this.valuesY[i];
            double pixelY0 = h * (1.0 - (y0 - this.minY) / rangeY);
            double pixelY1 = h * (1.0 - (y1 - this.minY) / rangeY);
            double x0 = this.scaleX * ((double)(i - 1) - this.offsetX);
            double x1 = this.scaleX * ((double)i - this.offsetX);
            this.line.setLine(x0, pixelY0, x1, pixelY1);
            g2.draw(this.line);
        }
    }

    public void setScaleX(double scale) {
        this.scaleX = scale;
    }
}

