/*
 * Decompiled with CFR 0.152.
 */
package boofcv.gui.d3;

import georegression.metric.UtilAngle;
import georegression.struct.point.Vector3D_F64;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Line2D;
import javax.swing.JPanel;

public class Orientation3D
extends JPanel {
    double yaw;
    double tilt;
    int a = 6;
    int b = 40;
    Line2D.Double line = new Line2D.Double();

    public Orientation3D() {
        this.setPreferredSize(new Dimension(this.a + this.b + this.a + 25, this.a + this.b + this.a));
        this.setMaximumSize(this.getPreferredSize());
        this.setMinimumSize(this.getPreferredSize());
    }

    public void setVector(Vector3D_F64 v) {
        this.yaw = Math.atan2(v.x, v.z);
        this.tilt = UtilAngle.atanSafe((double)(-v.y), (double)Math.abs(v.z));
    }

    public void setTilt(double tilt) {
        this.tilt = tilt;
    }

    public void setYaw(double yaw) {
        this.yaw = yaw;
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setColor(Color.BLACK);
        g2.setStroke(new BasicStroke(5.0f));
        g2.drawOval(this.a, this.a, this.b, this.b);
        this.drawMark(this.a + this.b / 2, this.a, 5.0, true, g2);
        this.drawMark(this.a + this.b / 2, this.a + this.b, 5.0, true, g2);
        this.drawMark(this.a, this.a + this.b / 2, 5.0, false, g2);
        this.drawMark(this.a + this.b, this.a + this.b / 2, 5.0, false, g2);
        this.drawNeedle(this.a + this.b / 2, this.a + this.b / 2, this.b / 2 + 2, this.yaw, g2);
        this.drawTiltBar(this.a + this.b + 20, g2);
    }

    private void drawTiltBar(int xc, Graphics2D g2) {
        g2.setStroke(new BasicStroke(3.0f));
        g2.setColor(Color.BLACK);
        g2.drawLine(xc, this.a, xc, this.a + this.b);
        g2.drawLine(xc - 3, this.a, xc + 3, this.a);
        g2.drawLine(xc - 3, this.a + this.b, xc + 3, this.a + this.b);
        g2.drawLine(xc - 3, this.a + this.b / 2, xc + 3, this.a + this.b / 2);
        g2.setColor(Color.RED);
        g2.setStroke(new BasicStroke(5.0f));
        int y = (int)((double)(this.a + this.b / 2) - (double)this.b / 2.0 * this.tilt / 1.5707963267948966);
        g2.drawLine(xc - 4, y, xc + 4, y);
    }

    private void drawNeedle(double xc, double yc, int r, double yaw, Graphics2D g2) {
        g2.setColor(Color.RED);
        double lx = (double)r * Math.cos(yaw);
        double ly = (double)r * Math.sin(yaw);
        this.line.setLine(xc, yc, xc + lx, yc + ly);
        g2.draw(this.line);
    }

    private void drawMark(double xc, double yc, double r, boolean vertical, Graphics2D g2) {
        if (vertical) {
            this.line.setLine(xc, yc - r, xc, yc + r);
        } else {
            this.line.setLine(xc - r, yc, xc + r, yc);
        }
        g2.draw(this.line);
    }
}

