/*
 * Decompiled with CFR 0.152.
 */
package boofcv.gui.image;

import boofcv.alg.misc.GImageStatistics;
import boofcv.gui.image.ImageGridPanel;
import boofcv.gui.image.ImagePanel;
import boofcv.gui.image.ScaleOptions;
import boofcv.gui.image.VisualizeImageData;
import boofcv.io.image.ConvertBufferedImage;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageGray;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class ShowImages {
    public static void showDialog(BufferedImage img) {
        ImageIcon icon = new ImageIcon();
        icon.setImage(img);
        JOptionPane.showMessageDialog(null, icon);
    }

    public static ImageGridPanel showGrid(int numColumns, String title, BufferedImage ... images) {
        JFrame frame = new JFrame(title);
        int numRows = images.length / numColumns + images.length % numColumns;
        ImageGridPanel panel = new ImageGridPanel(numRows, numColumns, images);
        frame.add((Component)panel, "Center");
        frame.pack();
        frame.setVisible(true);
        return panel;
    }

    public static ImagePanel showWindow(BufferedImage img, String title) {
        return ShowImages.showWindow(img, title, false);
    }

    public static ImagePanel showWindow(BufferedImage img, String title, boolean closeOnExit) {
        JFrame frame = new JFrame(title);
        ImagePanel panel = new ImagePanel(img);
        panel.setScaling(ScaleOptions.DOWN);
        Rectangle monitorBounds = frame.getGraphicsConfiguration().getBounds();
        if (monitorBounds.width < img.getWidth() || monitorBounds.height < img.getHeight()) {
            double scale = Math.min((double)monitorBounds.width / (double)img.getWidth(), (double)monitorBounds.height / (double)img.getHeight());
            int width = (int)(scale * (double)img.getWidth());
            int height = (int)(scale * (double)img.getHeight());
            panel.setPreferredSize(new Dimension(width, height));
        }
        frame.add((Component)panel, "Center");
        frame.pack();
        frame.setLocationByPlatform(true);
        frame.setVisible(true);
        if (closeOnExit) {
            frame.setDefaultCloseOperation(3);
        }
        return panel;
    }

    public static ImagePanel showWindow(ImageBase img, String title) {
        BufferedImage buff = ConvertBufferedImage.convertTo((ImageBase)img, null, (boolean)true);
        return ShowImages.showWindow(buff, title);
    }

    public static JFrame showWindow(JComponent component, String title) {
        return ShowImages.showWindow(component, title, false);
    }

    public static JFrame showWindow(JComponent component, String title, final boolean closeOnExit) {
        final JFrame frame = new JFrame(title);
        frame.add((Component)component, "Center");
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                frame.pack();
                frame.setVisible(true);
                if (closeOnExit) {
                    frame.setDefaultCloseOperation(3);
                }
            }
        });
        return frame;
    }

    public static ImagePanel showWindow(ImageGray img, String title, boolean showMagnitude) {
        double max = GImageStatistics.maxAbs((ImageBase)img);
        BufferedImage buff = showMagnitude ? VisualizeImageData.grayMagnitude(img, null, max) : VisualizeImageData.colorizeSign(img, null, max);
        return ShowImages.showWindow(buff, title);
    }
}

