/*
 * Decompiled with CFR 0.152.
 */
package boofcv.gui.tracker;

import boofcv.struct.feature.NccFeature;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import javax.swing.JPanel;

public class TldTemplatePanel
extends JPanel {
    int featureWidth;
    int scale = 2;
    List<BufferedImage> templates = new ArrayList<BufferedImage>();
    Stack<BufferedImage> unused = new Stack();

    public TldTemplatePanel(int featureWidth) {
        this.featureWidth = featureWidth;
        this.setAutoscrolls(true);
        this.setPreferredSize(new Dimension(featureWidth * this.scale, 30));
        this.setMinimumSize(this.getPreferredSize());
    }

    public synchronized void update(List<NccFeature> features, boolean gray) {
        this.unused.addAll(this.templates);
        this.templates.clear();
        for (NccFeature f : features) {
            int rgb;
            BufferedImage img = this.unused.isEmpty() ? new BufferedImage(this.featureWidth, this.featureWidth, 1) : this.unused.pop();
            this.templates.add(img);
            int index = 0;
            if (gray) {
                for (int y = 0; y < this.featureWidth; ++y) {
                    for (int x = 0; x < this.featureWidth; ++x) {
                        int v = (int)(f.value[index++] + f.mean);
                        rgb = v << 16 | v << 8 | v;
                        img.setRGB(x, y, rgb);
                    }
                }
                continue;
            }
            double maxAbs = 0.0;
            for (int i = 0; i < f.value.length; ++i) {
                double v = Math.abs(f.value[i]);
                if (!(v > maxAbs)) continue;
                maxAbs = v;
            }
            if (maxAbs == 0.0) continue;
            for (int y = 0; y < this.featureWidth; ++y) {
                for (int x = 0; x < this.featureWidth; ++x) {
                    int v;
                    rgb = (v = (int)(255.0 * f.value[index++] / maxAbs)) < 0 ? -v : v << 16;
                    img.setRGB(x, y, rgb);
                }
            }
        }
        this.setPreferredSize(new Dimension(this.featureWidth * this.scale, this.featureWidth * features.size() * this.scale));
        this.setMinimumSize(this.getPreferredSize());
        this.revalidate();
    }

    @Override
    protected synchronized void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        g2.scale(this.scale, this.scale);
        for (int i = 0; i < this.templates.size(); ++i) {
            int y = i * this.featureWidth;
            g2.drawImage(this.templates.get(i), 0, y, this.featureWidth, this.featureWidth, null);
        }
    }
}

