/*
 * Decompiled with CFR 0.152.
 */
package boofcv.gui.calibration;

import boofcv.gui.calibration.StereoImageSet;
import boofcv.io.image.UtilImageIO;
import boofcv.misc.BoofMiscOps;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.List;

public class StereoImageSetList
implements StereoImageSet {
    List<String> left;
    List<String> right;
    int selected;

    public StereoImageSetList(List<String> left, List<String> right) {
        BoofMiscOps.checkEq((int)left.size(), (int)right.size());
        this.left = left;
        this.right = right;
    }

    @Override
    public void setSelected(int index) {
        this.selected = index;
    }

    @Override
    public int size() {
        return this.left.size();
    }

    @Override
    public String getLeftName() {
        return new File(this.left.get(this.selected)).getName();
    }

    @Override
    public String getRightName() {
        return new File(this.right.get(this.selected)).getName();
    }

    @Override
    public BufferedImage loadLeft() {
        BufferedImage image = UtilImageIO.loadImage((String)this.left.get(this.selected));
        BoofMiscOps.checkTrue((image != null ? 1 : 0) != 0);
        return image;
    }

    @Override
    public BufferedImage loadRight() {
        BufferedImage image = UtilImageIO.loadImage((String)this.right.get(this.selected));
        BoofMiscOps.checkTrue((image != null ? 1 : 0) != 0);
        return image;
    }
}

