/*
 * Decompiled with CFR 0.152.
 */
package boofcv.gui.controls;

import boofcv.abst.geo.calibration.CalibrateMonoPlanar;
import boofcv.gui.StandardAlgConfigPanel;
import boofcv.gui.controls.ControlPanelPinhole;
import boofcv.gui.controls.JCheckBoxValue;
import boofcv.gui.controls.JSpinnerNumber;
import boofcv.struct.calib.CameraModelType;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JComboBox;
import javax.swing.JPanel;

public class CalibrationModelPanel
extends StandardAlgConfigPanel
implements ActionListener {
    JComboBox<CameraModelType> comboType;
    JPanel panelTarget = new JPanel();
    public CameraModelType selected = CameraModelType.BROWN;
    public final ControlPanelPinhole pinhole = new ControlPanelPinhole(this::updateParameters);
    public final UniversalPanel universal = new UniversalPanel(this::updateParameters);
    public final KannalaBrandtPanel kannalaBrandt = new KannalaBrandtPanel();
    public Listener listener = () -> {};

    public CalibrationModelPanel() {
        this.setBorder(BorderFactory.createEmptyBorder());
        this.comboType = new JComboBox<CameraModelType>(CameraModelType.values());
        this.comboType.addActionListener(this);
        this.comboType.setMaximumSize(this.comboType.getPreferredSize());
        this.panelTarget.setLayout(new BorderLayout());
        this.panelTarget.setPreferredSize(new Dimension(250, 100));
        this.panelTarget.setMaximumSize(this.panelTarget.getPreferredSize());
        this.changeTargetPanel();
        this.addLabeled(this.comboType, "Model Type");
        this.add(Box.createRigidArea(new Dimension(10, 10)));
        this.addAlignCenter(this.panelTarget);
    }

    public void setToBrown(boolean skew, int numRadial, boolean tangential) {
        this.comboType.setSelectedIndex(CameraModelType.BROWN.ordinal());
        this.pinhole.skew.check.setSelected(skew);
        this.pinhole.numRadial.spinner.setValue(numRadial);
        this.pinhole.tangential.check.setSelected(tangential);
    }

    public void setToUniversal(boolean skew, int numRadial, boolean tangential) {
        this.comboType.setSelectedIndex(CameraModelType.UNIVERSAL.ordinal());
        this.universal.skew.check.setSelected(skew);
        this.universal.numRadial.spinner.setValue(numRadial);
        this.universal.tangential.check.setSelected(tangential);
    }

    public void setToKannalaBrandt(boolean skew, int numSymmetric, int numAsymmetric) {
        this.comboType.setSelectedIndex(CameraModelType.KANNALA_BRANDT.ordinal());
        this.kannalaBrandt.skew.check.setSelected(skew);
        this.kannalaBrandt.numSymmetric.spinner.setValue(numSymmetric);
        this.kannalaBrandt.numAsymmetric.spinner.setValue(numAsymmetric);
    }

    public void configureCalibrator(CalibrateMonoPlanar calibrator) {
        switch (this.selected) {
            case BROWN: {
                calibrator.configurePinhole(this.pinhole.skew.value, this.pinhole.numRadial.value.intValue(), this.pinhole.tangential.value);
                break;
            }
            case UNIVERSAL: {
                calibrator.configureUniversalOmni(this.universal.skew.value, this.universal.numRadial.value.intValue(), this.universal.tangential.value);
                break;
            }
            case KANNALA_BRANDT: {
                calibrator.configureKannalaBrandt(this.kannalaBrandt.skew.value, this.kannalaBrandt.numSymmetric.vint(), this.kannalaBrandt.numAsymmetric.vint());
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.comboType) {
            this.selected = (CameraModelType)this.comboType.getSelectedItem();
            this.changeTargetPanel();
            this.updateParameters();
        }
    }

    public void updateParameters() {
        this.changeTargetPanel();
        this.listener.changed();
    }

    private void changeTargetPanel() {
        StandardAlgConfigPanel standardAlgConfigPanel;
        switch (this.selected) {
            case BROWN: {
                standardAlgConfigPanel = this.pinhole;
                break;
            }
            case UNIVERSAL: {
                standardAlgConfigPanel = this.universal;
                break;
            }
            case KANNALA_BRANDT: {
                standardAlgConfigPanel = this.kannalaBrandt;
                break;
            }
            default: {
                throw new RuntimeException("Unknown");
            }
        }
        StandardAlgConfigPanel p = standardAlgConfigPanel;
        this.panelTarget.removeAll();
        this.panelTarget.add("Center", p);
        this.panelTarget.validate();
        this.panelTarget.repaint();
    }

    private class UniversalPanel
    extends StandardAlgConfigPanel {
        public final JSpinnerNumber numRadial = this.spinnerWrap(2, 0, 10, 1).tt("Number of radial distortion terms");
        public final JCheckBoxValue tangential = this.checkboxWrap("Tangential", false).tt("Include tangential distortion");
        public final JCheckBoxValue skew = this.checkboxWrap("Zero Skew", true).tt("Include skew in camera model. Rarely needed.");
        public Runnable parametersUpdated = () -> {};

        public UniversalPanel() {
            this.setBorder(BorderFactory.createEmptyBorder());
            this.addLabeled(this.numRadial.spinner, "Radial");
            this.addAlignLeft(this.tangential.check);
            this.addAlignLeft(this.skew.check);
        }

        public UniversalPanel(Runnable parametersUpdated) {
            this();
            this.parametersUpdated = parametersUpdated;
        }

        @Override
        public void controlChanged(Object source) {
            this.parametersUpdated.run();
        }
    }

    public class KannalaBrandtPanel
    extends StandardAlgConfigPanel {
        public final JSpinnerNumber numSymmetric = this.spinnerWrap(5, 0, 10, 1).tt("Number of symmetric terms");
        public final JSpinnerNumber numAsymmetric = this.spinnerWrap(0, 0, 10, 1).tt("Number of asymmetric terms. Typically not used.");
        public final JCheckBoxValue skew = this.checkboxWrap("Zero Skew", true).tt("Include skew in camera model. Rarely needed.");

        public KannalaBrandtPanel() {
            this.setBorder(BorderFactory.createEmptyBorder());
            this.addLabeled(this.numSymmetric.spinner, "Symmetric");
            this.addLabeled(this.numAsymmetric.spinner, "Asymmetric");
            this.addAlignLeft(this.skew.check);
        }

        @Override
        public void controlChanged(Object source) {
            CalibrationModelPanel.this.updateParameters();
        }
    }

    @FunctionalInterface
    public static interface Listener {
        public void changed();
    }
}

