/*
 * Decompiled with CFR 0.152.
 */
package boofcv.gui.controls;

import boofcv.abst.feature.describe.ConfigTemplateDescribe;
import boofcv.abst.tracker.ConfigTrackerHybrid;
import boofcv.abst.tracker.PointTracker;
import boofcv.alg.tracker.klt.ConfigPKlt;
import boofcv.factory.feature.associate.ConfigAssociate;
import boofcv.factory.feature.describe.ConfigDescribeRegion;
import boofcv.factory.feature.detdesc.ConfigDetectDescribe;
import boofcv.factory.feature.detect.interest.ConfigDetectInterestPoint;
import boofcv.factory.tracker.ConfigPointTracker;
import boofcv.factory.tracker.FactoryPointTracker;
import boofcv.gui.StandardAlgConfigPanel;
import boofcv.gui.controls.ControlPanelDetDescAssocBase;
import boofcv.gui.controls.ControlPanelPointTrackerKlt;
import boofcv.gui.controls.JConfigLength;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageType;
import boofcv.struct.pyramid.ConfigDiscreteLevels;
import java.awt.BorderLayout;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.Nullable;

public class ControlPanelHybridTracker
extends ControlPanelDetDescAssocBase {
    Listener listener;
    int selectedSelection = 0;
    JComboBox<String> spinnerSelection = this.combo(this.selectedSelection, "KLT", "Detect", "Describe", "Associate");
    public ControlPanelPointTrackerKlt controlKlt;
    protected ConfigPKlt configKlt = new ConfigPKlt();
    protected ConfigTrackerHybrid configHybrid = new ConfigTrackerHybrid();
    private ControlTracker controlTracker;
    private JPanel controlPanel = new JPanel(new BorderLayout());
    private JPanel ddaPanel = new JPanel();

    public ControlPanelHybridTracker(Listener listener) {
        this.listener = listener;
        this.ddaPanel.setLayout(new BoxLayout(this.ddaPanel, 1));
        this.configKlt.toleranceFB = 3.0;
        this.configKlt.pruneClose = true;
        this.configKlt.templateRadius = 3;
        this.configKlt.pyramidLevels = ConfigDiscreteLevels.levels((int)4);
        this.configAssociate.greedy.scoreRatioThreshold = 0.75;
        this.configDetDesc.detectPoint.general.threshold = 100.0f;
        this.configDetDesc.detectPoint.general.radius = 4;
        this.configDetDesc.detectPoint.shiTomasi.radius = 4;
        this.configDetDesc.describeTemplate.type = ConfigTemplateDescribe.Type.NCC;
        this.configDetDesc.typeDetector = ConfigDetectInterestPoint.Type.POINT;
        this.configDetDesc.typeDescribe = ConfigDescribeRegion.Type.TEMPLATE;
    }

    public ControlPanelHybridTracker(Listener listener, @Nullable ConfigTrackerHybrid configHybrid, @Nullable ConfigPKlt configKlt, @Nullable ConfigDetectDescribe configDetDesc, @Nullable ConfigAssociate configAssociate) {
        this.listener = listener;
        this.ddaPanel.setLayout(new BoxLayout(this.ddaPanel, 1));
        this.configHybrid = configHybrid != null ? configHybrid : this.configHybrid;
        this.configKlt = configKlt != null ? configKlt : this.configKlt;
        this.configDetDesc = configDetDesc != null ? configDetDesc : this.configDetDesc;
        this.configAssociate = configAssociate != null ? configAssociate : this.configAssociate;
    }

    @Override
    public void initializeControlsGUI() {
        this.associateWithPixels = true;
        super.initializeControlsGUI();
        this.controlTracker = new ControlTracker();
        this.controlKlt = new ControlPanelPointTrackerKlt(() -> this.listener.changedHybridTracker(), null, this.configKlt);
        this.controlKlt.setBorder(BorderFactory.createEmptyBorder());
        this.updateActiveControls(this.selectedSelection);
        this.add(this.controlTracker);
        this.addLabeled(this.spinnerSelection, "Component", "Select a component of the tracker to modify");
        this.add(this.controlPanel);
    }

    private void updateActiveControls(int which) {
        JPanel inside;
        this.selectedSelection = which;
        this.controlPanel.removeAll();
        if (which == 0) {
            inside = this.controlKlt;
        } else {
            inside = this.ddaPanel;
            this.ddaPanel.removeAll();
            switch (which) {
                case 1: {
                    this.ddaPanel.add(this.comboDetect);
                    this.ddaPanel.add(this.getDetectorPanel());
                    break;
                }
                case 2: {
                    this.ddaPanel.add(this.comboDescribe);
                    this.ddaPanel.add(this.getDescriptorPanel());
                    break;
                }
                case 3: {
                    this.ddaPanel.add(this.comboAssociate);
                    this.ddaPanel.add(this.getAssociatePanel());
                }
            }
            this.ddaPanel.validate();
        }
        if (inside != null) {
            this.controlPanel.add("Center", inside);
        }
        this.controlPanel.validate();
        SwingUtilities.invokeLater(this::repaint);
    }

    public ConfigPointTracker createConfiguration() {
        ConfigPointTracker config = new ConfigPointTracker();
        config.typeTracker = ConfigPointTracker.TrackerType.HYBRID;
        config.hybrid.setTo(this.configHybrid);
        config.detDesc.setTo(this.configDetDesc);
        config.associate.setTo(this.configAssociate);
        config.klt.setTo(this.configKlt);
        return config;
    }

    public <T extends ImageBase<T>> PointTracker<T> createTracker(ImageType<T> imageType) {
        return FactoryPointTracker.tracker((ConfigPointTracker)this.createConfiguration(), (Class)imageType.getImageClass(), null);
    }

    @Override
    protected void handleControlsUpdated() {
        this.listener.changedHybridTracker();
    }

    @Override
    public void controlChanged(Object source) {
        if (source == this.comboDetect) {
            this.configDetDesc.typeDetector = ConfigDetectInterestPoint.Type.values()[this.comboDetect.getSelectedIndex()];
        } else if (source == this.comboDescribe) {
            this.configDetDesc.typeDescribe = ConfigDescribeRegion.Type.values()[this.comboDescribe.getSelectedIndex()];
        } else if (source == this.comboAssociate) {
            this.configAssociate.type = ConfigAssociate.AssociationType.values()[this.comboAssociate.getSelectedIndex()];
        }
        this.updateActiveControls(this.spinnerSelection.getSelectedIndex());
        this.listener.changedHybridTracker();
    }

    public static interface Listener {
        public void changedHybridTracker();
    }

    public class ControlTracker
    extends StandardAlgConfigPanel {
        JSpinner spinnerMaxInactive;
        JCheckBox checkPruneClose;
        JConfigLength jRespawn;

        public ControlTracker() {
            this.spinnerMaxInactive = this.spinner(ControlPanelHybridTracker.this.configHybrid.maxInactiveTracks, 0, 5000, 10);
            this.checkPruneClose = this.checkbox("Prune Close", ControlPanelHybridTracker.this.configHybrid.pruneCloseTracks);
            this.jRespawn = this.configLength(ControlPanelHybridTracker.this.configHybrid.thresholdRespawn, 0.0, 1000.0);
            this.addLabeled(this.spinnerMaxInactive, "Max Inactive", "Maximum number of inactive/not visible tracks kept around");
            this.addAlignLeft(this.checkPruneClose, "Prune tracks if they get too close to each other");
            this.addLabeled(this.jRespawn, "Respawn", "Respawn tracks when the number of active tracks drops below this threshold");
        }

        @Override
        public void controlChanged(Object source) {
            if (source == this.spinnerMaxInactive) {
                ControlPanelHybridTracker.this.configHybrid.maxInactiveTracks = (Integer)this.spinnerMaxInactive.getValue();
            } else if (source == this.checkPruneClose) {
                ControlPanelHybridTracker.this.configHybrid.pruneCloseTracks = this.checkPruneClose.isSelected();
            } else if (source == this.jRespawn) {
                ControlPanelHybridTracker.this.configHybrid.thresholdRespawn.setTo(this.jRespawn.getValue());
            } else {
                throw new RuntimeException("BUG");
            }
            ControlPanelHybridTracker.this.listener.changedHybridTracker();
        }
    }
}

