/*
 * Decompiled with CFR 0.152.
 */
package boofcv.gui.d3;

import boofcv.alg.geo.PerspectiveOps;
import boofcv.alg.misc.ImageMiscOps;
import boofcv.gui.image.SaveImageOnClick;
import boofcv.io.image.ConvertBufferedImage;
import boofcv.misc.BoofMiscOps;
import boofcv.struct.calib.CameraPinhole;
import boofcv.struct.calib.CameraPinholeBrown;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayS32;
import boofcv.struct.image.ImageBase;
import boofcv.struct.packed.PackedBigArrayPoint3D_F32;
import boofcv.visualize.PointCloudViewer;
import georegression.geometry.ConvertRotation3D_F32;
import georegression.metric.UtilAngle;
import georegression.struct.ConvertFloatType;
import georegression.struct.EulerType;
import georegression.struct.GeoTuple2D_F32;
import georegression.struct.point.Point2D_F32;
import georegression.struct.point.Point3D_F32;
import georegression.struct.point.Point3D_F64;
import georegression.struct.point.Vector3D_F32;
import georegression.struct.se.Se3_F32;
import georegression.transform.se.SePointOps_F32;
import java.awt.Graphics;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import javax.swing.JPanel;
import org.ddogleg.struct.BigDogArray_I32;
import org.ddogleg.struct.DogArray;
import org.ddogleg.struct.DogArray_B;
import org.ejml.data.FMatrixRMaj;
import org.jetbrains.annotations.Nullable;

public class PointCloudViewerPanelSwing
extends JPanel
implements MouseMotionListener,
MouseListener,
MouseWheelListener {
    private final PackedBigArrayPoint3D_F32 cloudXyz = new PackedBigArrayPoint3D_F32();
    private final BigDogArray_I32 cloudColor = new BigDogArray_I32();
    private final DogArray<Wireframe> wireframes = new DogArray(() -> new Wireframe());
    private final ReentrantLock lockWireFrame = new ReentrantLock();
    float maxRenderDistance = Float.MAX_VALUE;
    boolean fog;
    PointCloudViewer.Colorizer colorizer;
    float hfov = UtilAngle.radian((float)50.0f);
    private final RenderingWork rendering = new RenderingWork();
    private int dotRadius = 2;
    int backgroundColor = 0;
    int prevX;
    int prevY;
    Keyboard keyboard = new Keyboard();
    @Nullable
    ScheduledExecutorService pressedTask = null;
    volatile float stepSize;
    boolean shiftPressed = false;
    boolean controlPressed = false;
    private final ReentrantLock lockPressed = new ReentrantLock();
    private final Set<Integer> pressed = new HashSet<Integer>();

    public PointCloudViewerPanelSwing(float keyStepSize) {
        this.addMouseListener(new SaveImageOnClick(this));
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addMouseWheelListener(this);
        this.setFocusable(true);
        this.requestFocus();
        this.stepSize = keyStepSize;
        this.addFocusListener(new FocusListener(){
            ScheduledFuture<?> future;

            @Override
            public void focusGained(FocusEvent e) {
                KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(PointCloudViewerPanelSwing.this.keyboard);
                if (PointCloudViewerPanelSwing.this.pressedTask != null) {
                    throw new RuntimeException("BUG! pressedTask is not null");
                }
                PointCloudViewerPanelSwing.this.pressedTask = Executors.newScheduledThreadPool(1);
                this.future = PointCloudViewerPanelSwing.this.pressedTask.scheduleAtFixedRate(new KeyPressedTask(), 100L, 30L, TimeUnit.MILLISECONDS);
            }

            @Override
            public void focusLost(FocusEvent e) {
                KeyboardFocusManager.getCurrentKeyboardFocusManager().removeKeyEventDispatcher(PointCloudViewerPanelSwing.this.keyboard);
                Objects.requireNonNull(PointCloudViewerPanelSwing.this.pressedTask).shutdown();
                PointCloudViewerPanelSwing.this.pressedTask = null;
                PointCloudViewerPanelSwing.this.resetKey();
            }
        });
    }

    public PointCloudViewerPanelSwing(float hfov, float keyStepSize) {
        this(keyStepSize);
        this.setHorizontalFieldOfView(hfov);
    }

    public void resetKey() {
        this.lockPressed.lock();
        try {
            this.pressed.clear();
        }
        finally {
            this.lockPressed.unlock();
        }
        this.shiftPressed = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addWireFrame(List<Point3D_F64> vertexes, boolean closed, int rgb, int radiusPixels) {
        this.lockWireFrame.lock();
        try {
            if (vertexes.size() <= 1) {
                return;
            }
            Wireframe wf = (Wireframe)this.wireframes.grow();
            wf.vertexes.reset();
            wf.rgb = rgb;
            wf.radiusPixels = radiusPixels;
            for (int i = 0; i < vertexes.size(); ++i) {
                ConvertFloatType.convert((Point3D_F64)vertexes.get(i), (Point3D_F32)((Point3D_F32)wf.vertexes.grow()));
            }
            if (closed) {
                ConvertFloatType.convert((Point3D_F64)vertexes.get(0), (Point3D_F32)((Point3D_F32)wf.vertexes.grow()));
            }
        }
        finally {
            this.lockWireFrame.unlock();
        }
    }

    public void setWorldToCamera(Se3_F32 worldToCamera) {
        this.rendering.lock.lock();
        try {
            this.rendering.worldToCamera.setTo(worldToCamera);
        }
        finally {
            this.rendering.lock.unlock();
        }
    }

    public void setHorizontalFieldOfView(float radians) {
        this.hfov = radians;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCloud() {
        PackedBigArrayPoint3D_F32 packedBigArrayPoint3D_F32 = this.cloudXyz;
        synchronized (packedBigArrayPoint3D_F32) {
            this.cloudXyz.reset();
            this.cloudColor.reset();
        }
        this.lockWireFrame.lock();
        try {
            this.wireframes.reset();
        }
        finally {
            this.lockWireFrame.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPoint(float x, float y, float z, int rgb) {
        PackedBigArrayPoint3D_F32 packedBigArrayPoint3D_F32 = this.cloudXyz;
        synchronized (packedBigArrayPoint3D_F32) {
            this.cloudXyz.append(x, y, z);
            this.cloudColor.add(rgb);
        }
    }

    public Se3_F32 getWorldToCamera(@Nullable Se3_F32 worldToCamera) {
        if (worldToCamera == null) {
            worldToCamera = new Se3_F32();
        }
        this.rendering.lock.lock();
        try {
            worldToCamera.setTo(this.rendering.worldToCamera);
        }
        finally {
            this.rendering.lock.unlock();
        }
        return worldToCamera;
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.rendering.lock.lock();
        try {
            this.projectScene();
            this.rendering.imageOutput = ConvertBufferedImage.checkDeclare((int)this.rendering.imageRgb.width, (int)this.rendering.imageRgb.height, (BufferedImage)this.rendering.imageOutput, (int)1);
            DataBufferInt buffer = (DataBufferInt)this.rendering.imageOutput.getRaster().getDataBuffer();
            System.arraycopy(this.rendering.imageRgb.data, 0, buffer.getData(), 0, this.rendering.imageRgb.width * this.rendering.imageRgb.height);
            g.drawImage(this.rendering.imageOutput, 0, 0, null);
        }
        finally {
            this.rendering.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void projectScene() {
        if (!this.rendering.lock.isLocked()) {
            throw new RuntimeException("Must be locked already");
        }
        int w = this.getWidth();
        int h = this.getHeight();
        this.rendering.imageDepth.reshape(w, h);
        this.rendering.imageRgb.reshape(w, h);
        CameraPinholeBrown intrinsic = PerspectiveOps.createIntrinsic((int)w, (int)h, (double)UtilAngle.degree((float)this.hfov), null);
        ImageMiscOps.fill((GrayF32)this.rendering.imageDepth, (float)Float.MAX_VALUE);
        ImageMiscOps.fill((GrayS32)this.rendering.imageRgb, (int)this.backgroundColor);
        float maxDistanceSq = this.maxRenderDistance * this.maxRenderDistance;
        if (Float.isInfinite(maxDistanceSq)) {
            maxDistanceSq = Float.MAX_VALUE;
        }
        PackedBigArrayPoint3D_F32 packedBigArrayPoint3D_F32 = this.cloudXyz;
        synchronized (packedBigArrayPoint3D_F32) {
            this.renderCloud((CameraPinhole)intrinsic, this.colorizer, maxDistanceSq);
        }
        this.lockWireFrame.lock();
        try {
            this.renderWireframes((CameraPinhole)intrinsic, maxDistanceSq);
        }
        finally {
            this.lockWireFrame.unlock();
        }
    }

    private void renderCloud(CameraPinhole intrinsic, PointCloudViewer.Colorizer colorizer, float maxDistanceSq) {
        if (!this.rendering.lock.isLocked()) {
            throw new RuntimeException("Must be locked already");
        }
        Point2D_F32 pixel = this.rendering.pixel;
        Point3D_F32 cameraPt = this.rendering.cameraPt;
        Se3_F32 worldToCamera = this.rendering.worldToCamera;
        GrayF32 imageDepth = this.rendering.imageDepth;
        float fx = (float)intrinsic.fx;
        float fy = (float)intrinsic.fy;
        float cx = (float)intrinsic.cx;
        float cy = (float)intrinsic.cy;
        this.cloudXyz.forIdx(0, this.cloudXyz.size(), (idx, worldPt) -> {
            SePointOps_F32.transform((Se3_F32)worldToCamera, (Point3D_F32)worldPt, (Point3D_F32)cameraPt);
            if (cameraPt.z < 0.0f) {
                return;
            }
            float r2 = cameraPt.normSq();
            if (r2 > maxDistanceSq) {
                return;
            }
            pixel.x = fx * cameraPt.x / cameraPt.z + cx;
            pixel.y = fy * cameraPt.y / cameraPt.z + cy;
            int x = (int)(pixel.x + 0.5f);
            int y = (int)(pixel.y + 0.5f);
            if (!imageDepth.isInBounds(x, y)) {
                return;
            }
            int rgb = colorizer == null ? this.cloudColor.get(idx) : colorizer.color(idx, (double)worldPt.x, (double)worldPt.y, (double)worldPt.z);
            if (this.fog) {
                rgb = this.applyFog(rgb, 1.0f - (float)Math.sqrt(r2) / this.maxRenderDistance);
            }
            this.renderDot(x, y, cameraPt.z, rgb, this.dotRadius);
        });
    }

    private void renderWireframes(CameraPinhole intrinsic, float maxDistanceSq) {
        if (!this.rendering.lock.isLocked()) {
            throw new RuntimeException("Must be locked already");
        }
        if (!this.lockWireFrame.isLocked()) {
            throw new RuntimeException("Wireframe must already be locked");
        }
        DogArray cameraPts = this.rendering.cameraPts;
        DogArray pixels = this.rendering.pixels;
        DogArray_B visible = this.rendering.visible;
        Se3_F32 worldToCamera = this.rendering.worldToCamera;
        GrayF32 imageDepth = this.rendering.imageDepth;
        float fx = (float)intrinsic.fx;
        float fy = (float)intrinsic.fy;
        float cx = (float)intrinsic.cx;
        float cy = (float)intrinsic.cy;
        int maxDotsPerLine = this.rendering.imageDepth.width;
        for (int wireIdx = 0; wireIdx < this.wireframes.size; ++wireIdx) {
            int i;
            Wireframe wf = (Wireframe)this.wireframes.get(wireIdx);
            pixels.reset();
            visible.reset();
            cameraPts.reset();
            for (i = 0; i < wf.vertexes.size; ++i) {
                Point3D_F32 cameraPt = (Point3D_F32)cameraPts.grow();
                Point2D_F32 pixel = (Point2D_F32)pixels.grow();
                SePointOps_F32.transform((Se3_F32)worldToCamera, (Point3D_F32)((Point3D_F32)wf.vertexes.get(i)), (Point3D_F32)cameraPt);
                pixel.x = fx * cameraPt.x / cameraPt.z + cx;
                pixel.y = fy * cameraPt.y / cameraPt.z + cy;
                boolean v = cameraPt.z > 0.0f;
                visible.add(v);
            }
            i = 0;
            int j = 1;
            while (j < wf.vertexes.size) {
                if (visible.data[i] && visible.data[j]) {
                    float distance;
                    int N;
                    Point2D_F32 a = (Point2D_F32)pixels.get(i);
                    Point2D_F32 b = (Point2D_F32)pixels.get(j);
                    Point3D_F32 A = (Point3D_F32)cameraPts.get(i);
                    Point3D_F32 B = (Point3D_F32)cameraPts.get(j);
                    if ((BoofMiscOps.isInside((ImageBase)imageDepth, (float)a.x, (float)a.y) || BoofMiscOps.isInside((ImageBase)imageDepth, (float)b.x, (float)b.y)) && (N = (int)Math.ceil((double)(distance = a.distance((GeoTuple2D_F32)b)) / (1.0 + 1.5 * (double)wf.radiusPixels))) >= 1 && N <= maxDotsPerLine) {
                        Point3D_F32 cameraPt = this.rendering.worldPt;
                        for (int locidx = 0; locidx < N; ++locidx) {
                            float y;
                            int py;
                            float x;
                            int px;
                            float lineLoc = (float)locidx / (float)N;
                            cameraPt.x = (B.x - A.x) * lineLoc + A.x;
                            cameraPt.y = (B.y - A.y) * lineLoc + A.y;
                            cameraPt.z = (B.z - A.z) * lineLoc + A.z;
                            float r2 = cameraPt.normSq();
                            if (r2 > maxDistanceSq || !imageDepth.isInBounds(px = (int)((x = (b.x - a.x) * lineLoc + a.x) + 0.5f), py = (int)((y = (b.y - a.y) * lineLoc + a.y) + 0.5f))) continue;
                            int rgb = wf.rgb;
                            if (this.fog) {
                                rgb = this.applyFog(rgb, 1.0f - (float)Math.sqrt(r2) / this.maxRenderDistance);
                            }
                            this.renderDot(px, py, cameraPt.z, rgb, wf.radiusPixels);
                        }
                    }
                }
                i = j++;
            }
        }
    }

    private int applyFog(int rgb, float fraction) {
        int adjustment = (int)(1000.0f * fraction);
        int r = rgb >> 16 & 0xFF;
        int g = rgb >> 8 & 0xFF;
        int b = rgb & 0xFF;
        r = (r * adjustment + (this.backgroundColor >> 16 & 0xFF) * (1000 - adjustment)) / 1000;
        g = (g * adjustment + (this.backgroundColor >> 8 & 0xFF) * (1000 - adjustment)) / 1000;
        b = (b * adjustment + (this.backgroundColor & 0xFF) * (1000 - adjustment)) / 1000;
        return r << 16 | g << 8 | b;
    }

    private void renderDot(int cx, int cy, float Z2, int rgb, int dotRadius) {
        GrayF32 imageDepth = this.rendering.imageDepth;
        GrayS32 imageRgb = this.rendering.imageRgb;
        int x0 = cx - dotRadius;
        int x1 = cx + dotRadius + 1;
        int y0 = cy - dotRadius;
        int y1 = cy + dotRadius + 1;
        if (x0 < 0) {
            x0 = 0;
        }
        if (x1 > imageRgb.width) {
            x1 = imageRgb.width;
        }
        if (y0 < 0) {
            y0 = 0;
        }
        if (y1 > imageRgb.height) {
            y1 = imageRgb.height;
        }
        for (int y = y0; y < y1; ++y) {
            int pixelIndex = y * imageDepth.width + x0;
            int x = x0;
            while (x < x1) {
                float depth = imageDepth.data[pixelIndex];
                if (depth > Z2) {
                    imageDepth.data[pixelIndex] = Z2;
                    imageRgb.data[pixelIndex] = rgb;
                }
                ++x;
                ++pixelIndex;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleKeyPress() {
        float x = 0.0f;
        float y = 0.0f;
        float z = 0.0f;
        boolean reset = false;
        boolean change = true;
        this.lockPressed.lock();
        try {
            Integer[] keys;
            float multiplier = this.shiftPressed ? 5.0f : 1.0f;
            multiplier *= this.controlPressed ? 0.2f : 1.0f;
            Integer[] integerArray = keys = this.pressed.toArray(new Integer[0]);
            int n = integerArray.length;
            block15: for (int i = 0; i < n; ++i) {
                int k = integerArray[i];
                switch (k) {
                    case 87: {
                        z -= multiplier;
                        continue block15;
                    }
                    case 83: {
                        z += multiplier;
                        continue block15;
                    }
                    case 65: {
                        x += multiplier;
                        continue block15;
                    }
                    case 68: {
                        x -= multiplier;
                        continue block15;
                    }
                    case 81: {
                        y -= multiplier;
                        continue block15;
                    }
                    case 69: {
                        y += multiplier;
                        continue block15;
                    }
                    case 72: {
                        reset = true;
                        continue block15;
                    }
                    default: {
                        change = false;
                    }
                }
            }
        }
        finally {
            this.lockPressed.unlock();
        }
        if (change) {
            this.rendering.lock.lock();
            try {
                float stepSize = this.stepSize;
                Vector3D_F32 T = this.rendering.worldToCamera.getT();
                T.x += stepSize * x;
                T.y += stepSize * y;
                T.z += stepSize * z;
                if (reset) {
                    this.rendering.worldToCamera.reset();
                }
            }
            finally {
                this.rendering.lock.unlock();
            }
        }
        this.repaint();
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        this.repaint();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.requestFocus();
        this.prevX = e.getX();
        this.prevY = e.getY();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void mouseDragged(MouseEvent e) {
        float rotX = 0.0f;
        float rotY = 0.0f;
        float rotZ = 0.0f;
        if (this.controlPressed) {
            int centerX = this.getWidth() / 2;
            int centerY = this.getHeight() / 2;
            double angle0 = Math.atan2(this.prevX - centerX, this.prevY - centerY);
            double angle1 = Math.atan2(e.getX() - centerX, e.getY() - centerY);
            rotZ += (float)(angle0 - angle1);
        } else {
            rotY += (float)(e.getX() - this.prevX) * 0.002f;
            rotX += (float)(this.prevY - e.getY()) * 0.002f;
        }
        Se3_F32 rotTran = new Se3_F32();
        ConvertRotation3D_F32.eulerToMatrix((EulerType)EulerType.XYZ, (float)rotX, (float)rotY, (float)rotZ, (FMatrixRMaj)rotTran.getR());
        this.rendering.lock.lock();
        try {
            Se3_F32 temp = this.rendering.worldToCamera.concat(rotTran, null);
            this.rendering.worldToCamera.setTo(temp);
        }
        finally {
            this.rendering.lock.unlock();
        }
        this.prevX = e.getX();
        this.prevY = e.getY();
        this.repaint();
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    public float getStepSize() {
        return this.stepSize;
    }

    public void setStepSize(float size) {
        this.stepSize = size;
    }

    public int getDotRadius() {
        return this.dotRadius;
    }

    public void setDotRadius(int dotRadius) {
        this.dotRadius = dotRadius;
    }

    public PackedBigArrayPoint3D_F32 getCloudXyz() {
        return this.cloudXyz;
    }

    public BigDogArray_I32 getCloudColor() {
        return this.cloudColor;
    }

    private static class RenderingWork {
        private final ReentrantLock lock = new ReentrantLock();
        final Se3_F32 worldToCamera = new Se3_F32();
        private final DogArray<Point3D_F32> cameraPts = new DogArray(Point3D_F32::new);
        private final DogArray<Point2D_F32> pixels = new DogArray(Point2D_F32::new);
        private final DogArray_B visible = new DogArray_B();
        private final Point3D_F32 worldPt = new Point3D_F32();
        private final Point3D_F32 cameraPt = new Point3D_F32();
        private final Point2D_F32 pixel = new Point2D_F32();
        GrayS32 imageRgb = new GrayS32(1, 1);
        GrayF32 imageDepth = new GrayF32(1, 1);
        BufferedImage imageOutput = new BufferedImage(1, 1, 1);

        private RenderingWork() {
        }
    }

    private class Keyboard
    implements KeyEventDispatcher {
        private Keyboard() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public boolean dispatchKeyEvent(KeyEvent e) {
            PointCloudViewerPanelSwing.this.lockPressed.lock();
            try {
                switch (e.getID()) {
                    case 401: {
                        switch (e.getKeyCode()) {
                            case 16: {
                                PointCloudViewerPanelSwing.this.shiftPressed = true;
                                return false;
                            }
                            case 17: {
                                PointCloudViewerPanelSwing.this.controlPressed = true;
                                return false;
                            }
                        }
                        PointCloudViewerPanelSwing.this.pressed.add(e.getKeyCode());
                        return false;
                    }
                    case 402: {
                        switch (e.getKeyCode()) {
                            case 16: {
                                PointCloudViewerPanelSwing.this.shiftPressed = false;
                                return false;
                            }
                            case 17: {
                                PointCloudViewerPanelSwing.this.controlPressed = false;
                                return false;
                            }
                        }
                        if (PointCloudViewerPanelSwing.this.pressed.remove(e.getKeyCode())) return false;
                        System.err.println("Possible Java / Mac OS X bug related to 'character accent menu' if using Java 1.8 try upgrading to 11 or later");
                        return false;
                    }
                }
                return false;
            }
            finally {
                PointCloudViewerPanelSwing.this.lockPressed.unlock();
            }
        }
    }

    private static class Wireframe {
        public final DogArray<Point3D_F32> vertexes = new DogArray(Point3D_F32::new);
        public int radiusPixels = 1;
        public int rgb;

        private Wireframe() {
        }
    }

    private class KeyPressedTask
    implements Runnable {
        private KeyPressedTask() {
        }

        @Override
        public void run() {
            PointCloudViewerPanelSwing.this.handleKeyPress();
        }
    }
}

