/*
 * Decompiled with CFR 0.152.
 */
package boofcv.gui.image;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;

public class ImageGridPanel
extends JPanel {
    BufferedImage[] images;
    int numRows;
    int numCols;
    boolean scaleToFit = false;
    AffineTransform affine = new AffineTransform();

    public ImageGridPanel(int numRows, int numCols) {
        this.images = new BufferedImage[numRows * numCols];
        this.numRows = numRows;
        this.numCols = numCols;
    }

    public ImageGridPanel(int numRows, int numCols, BufferedImage ... images) {
        this.images = new BufferedImage[numRows * numCols];
        for (int i = 0; i < images.length; ++i) {
            this.images[i] = images[i];
        }
        this.numRows = numRows;
        this.numCols = numCols;
        this.autoSetPreferredSize();
    }

    public synchronized void autoSetPreferredSize() {
        this.setPreferredSize(this.computePreferredSize());
    }

    public Dimension computePreferredSize() {
        int width = 0;
        int height = 0;
        for (int row = 0; row < this.numRows; ++row) {
            int h = 0;
            int w = 0;
            for (int col = 0; col < this.numCols; ++col) {
                BufferedImage img = this.images[row * this.numCols + col];
                if (img == null) continue;
                w += img.getWidth();
                h = Math.max(h, img.getHeight());
            }
            width = Math.max(w, width);
            height += h;
        }
        return new Dimension(width, height);
    }

    @Override
    public synchronized void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        double scale = 1.0;
        if (this.scaleToFit) {
            Dimension preferred = this.computePreferredSize();
            double scaleX = (double)this.getWidth() / preferred.getWidth();
            double scaleY = (double)this.getHeight() / preferred.getHeight();
            scale = Math.min(1.0, Math.min(scaleX, scaleY));
        }
        int y = 0;
        for (int row = 0; row < this.numRows; ++row) {
            int rowHeight = 0;
            int x = 0;
            for (int col = 0; col < this.numCols; ++col) {
                BufferedImage img = this.images[row * this.numCols + col];
                if (img == null) continue;
                this.affine.setTransform(scale, 0.0, 0.0, scale, (double)x * scale, (double)y * scale);
                g2.drawImage(img, this.affine, null);
                x += img.getWidth();
                rowHeight = Math.max(rowHeight, img.getHeight());
            }
            y += rowHeight;
        }
    }

    public void setScaleToFit(boolean scaleToFit) {
        this.scaleToFit = scaleToFit;
    }

    public synchronized void setImage(int row, int col, BufferedImage image) {
        this.images[row * this.numCols + col] = image;
    }

    public synchronized BufferedImage getImage(int row, int col) {
        return this.images[row * this.numCols + col];
    }

    public synchronized void setImages(BufferedImage ... images) {
        for (int i = 0; i < images.length; ++i) {
            this.images[i] = images[i];
        }
        this.autoSetPreferredSize();
    }
}

