/*
 * Decompiled with CFR 0.152.
 */
package boofcv.gui.calibration;

import boofcv.abst.fiducial.calib.CalibrationPatterns;
import boofcv.abst.fiducial.calib.ConfigECoCheckMarkers;
import boofcv.abst.fiducial.calib.ConfigGridDimen;
import boofcv.alg.drawing.FiducialRenderEngine;
import boofcv.alg.feature.detect.chess.ChessboardCorner;
import boofcv.alg.fiducial.calib.ecocheck.ECoCheckGenerator;
import boofcv.alg.fiducial.calib.ecocheck.ECoCheckUtils;
import boofcv.alg.fiducial.calib.hammingchess.HammingChessboardGenerator;
import boofcv.alg.fiducial.calib.hamminggrids.HammingGridGenerator;
import boofcv.factory.fiducial.ConfigHammingChessboard;
import boofcv.factory.fiducial.ConfigHammingGrid;
import boofcv.gui.FiducialRenderEngineGraphics2D;
import boofcv.gui.RenderCalibrationTargetsGraphics2D;
import boofcv.misc.BoofMiscOps;
import boofcv.struct.distort.Point2Transform2_F32;
import boofcv.struct.geo.PointIndex2D_F64;
import georegression.struct.point.Point2D_F32;
import georegression.struct.point.Point2D_F64;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.image.BufferedImage;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class UtilCalibrationGui {
    public static BufferedImage renderTargetBuffered(CalibrationPatterns type, Object config, int squareWidth) {
        int circle = squareWidth / 2;
        if (type == CalibrationPatterns.ECOCHECK) {
            ConfigECoCheckMarkers c = (ConfigECoCheckMarkers)config;
            ECoCheckUtils utils = new ECoCheckUtils();
            utils.codec.setErrorCorrectionLevel(c.errorCorrectionLevel);
            utils.codec.setChecksumBitCount(c.checksumBits);
            c.convertToGridList(utils.markers);
            utils.fixate();
            ConfigECoCheckMarkers.MarkerShape shape = (ConfigECoCheckMarkers.MarkerShape)c.markerShapes.get(0);
            int markerWidth = squareWidth * (shape.numCols - 1);
            int markerHeight = squareWidth * (shape.numRows - 1);
            FiducialRenderEngineGraphics2D render = UtilCalibrationGui.configureRenderGraphics2D(markerWidth, markerHeight, squareWidth / 2);
            ECoCheckGenerator generator = new ECoCheckGenerator(utils);
            generator.squareWidth = squareWidth;
            generator.setRender((FiducialRenderEngine)render);
            generator.render(0);
            return render.getImage();
        }
        if (type == CalibrationPatterns.HAMMING_CHESSBOARD) {
            ConfigHammingChessboard c = (ConfigHammingChessboard)config;
            int markerWidth = squareWidth * c.numCols;
            int markerHeight = squareWidth * c.numRows;
            FiducialRenderEngineGraphics2D render = UtilCalibrationGui.configureRenderGraphics2D(markerWidth, markerHeight, squareWidth / 2);
            HammingChessboardGenerator generator = new HammingChessboardGenerator(c);
            generator.squareWidth = squareWidth;
            generator.setRender((FiducialRenderEngine)render);
            generator.render();
            return render.getImage();
        }
        if (type == CalibrationPatterns.HAMMING_GRID) {
            ConfigHammingGrid c = (ConfigHammingGrid)config;
            int markerWidth = (int)Math.round((double)squareWidth * c.getMarkerWidth() / c.squareSize);
            int markerHeight = (int)Math.round((double)squareWidth * c.getMarkerHeight() / c.squareSize);
            FiducialRenderEngineGraphics2D render = UtilCalibrationGui.configureRenderGraphics2D(markerWidth, markerHeight, squareWidth / 2);
            HammingGridGenerator generator = new HammingGridGenerator(c);
            generator.squareWidth = squareWidth;
            generator.setRender((FiducialRenderEngine)render);
            generator.render();
            return render.getImage();
        }
        RenderCalibrationTargetsGraphics2D renderer = new RenderCalibrationTargetsGraphics2D(20, 1.0);
        if (type == CalibrationPatterns.CHESSBOARD) {
            ConfigGridDimen c = (ConfigGridDimen)config;
            renderer.chessboard(c.numRows, c.numCols, squareWidth);
        } else if (type == CalibrationPatterns.SQUARE_GRID) {
            ConfigGridDimen c = (ConfigGridDimen)config;
            double space = (double)squareWidth * c.shapeDistance / c.shapeSize;
            renderer.squareGrid(c.numRows, c.numCols, squareWidth, space);
        } else if (type == CalibrationPatterns.CIRCLE_GRID) {
            ConfigGridDimen c = (ConfigGridDimen)config;
            double space = (double)circle * c.shapeDistance / c.shapeSize;
            renderer.circleRegular(c.numRows, c.numCols, circle, space);
        } else if (type == CalibrationPatterns.CIRCLE_HEXAGONAL) {
            ConfigGridDimen c = (ConfigGridDimen)config;
            double space = (double)circle * c.shapeDistance / c.shapeSize;
            renderer.circleHex(c.numRows, c.numCols, circle, space);
        }
        return renderer.getBuffered();
    }

    private static FiducialRenderEngineGraphics2D configureRenderGraphics2D(int markerWidth, int markerHeight, int border) {
        FiducialRenderEngineGraphics2D render = new FiducialRenderEngineGraphics2D();
        render.configure(border, border, markerWidth, markerHeight);
        return render;
    }

    public static void renderOrder(Graphics2D g2, @Nullable Point2Transform2_F32 transform, double scale, List<PointIndex2D_F64> points) {
        g2.setStroke(new BasicStroke(5.0f));
        Point2D_F32 adj0 = new Point2D_F32();
        Point2D_F32 adj1 = new Point2D_F32();
        Line2D.Double l = new Line2D.Double();
        int i = 0;
        int j = 1;
        while (j < points.size()) {
            double fraction = (double)i / ((double)points.size() - 2.0);
            int red = (int)(255.0 * fraction) + (int)(0.0 * (1.0 - fraction));
            int green = 0;
            int blue = (int)(0.0 * fraction) + (int)(255.0 * (1.0 - fraction));
            int lineRGB = red << 16 | green << 8 | blue;
            Point2D_F64 p0 = (Point2D_F64)points.get((int)i).p;
            Point2D_F64 p1 = (Point2D_F64)points.get((int)j).p;
            if (transform == null) {
                l.setLine(scale * p0.x, scale * p0.y, scale * p1.x, scale * p1.y);
            } else {
                transform.compute((float)p0.x, (float)p0.y, adj0);
                transform.compute((float)p1.x, (float)p1.y, adj1);
                l.setLine(scale * (double)adj0.x, scale * (double)adj0.y, scale * (double)adj1.x, scale * (double)adj1.y);
            }
            g2.setColor(new Color(lineRGB));
            g2.draw(l);
            i = j++;
        }
    }

    public static void drawNumbers(Graphics2D g2, List<PointIndex2D_F64> points, @Nullable Point2Transform2_F32 transform, double scale) {
        Font regular = new Font("Serif", 0, 16);
        g2.setFont(regular);
        Point2D_F32 adj = new Point2D_F32();
        AffineTransform origTran = g2.getTransform();
        for (int i = 0; i < points.size(); ++i) {
            Point2D_F64 p = (Point2D_F64)points.get((int)i).p;
            int gridIndex = points.get((int)i).index;
            if (transform != null) {
                transform.compute((float)p.x, (float)p.y, adj);
            } else {
                adj.setTo((float)p.x, (float)p.y);
            }
            String text = String.format("%2d", gridIndex);
            int x = (int)((double)adj.x * scale);
            int y = (int)((double)adj.y * scale);
            g2.setColor(Color.BLACK);
            g2.drawString(text, x - 1, y);
            g2.drawString(text, x + 1, y);
            g2.drawString(text, x, y - 1);
            g2.drawString(text, x, y + 1);
            g2.setTransform(origTran);
            g2.setColor(Color.GREEN);
            g2.drawString(text, x, y);
        }
    }

    public static void drawIndexes(Graphics2D g2, int fontSize, List<Point2D_F64> points, @Nullable Point2Transform2_F32 transform, double scale) {
        int numDigits = BoofMiscOps.numDigits((int)points.size());
        String format = "%" + numDigits + "d";
        Font regular = new Font("Serif", 0, fontSize);
        g2.setFont(regular);
        Point2D_F32 adj = new Point2D_F32();
        AffineTransform origTran = g2.getTransform();
        for (int i = 0; i < points.size(); ++i) {
            Point2D_F64 p = points.get(i);
            if (transform != null) {
                transform.compute((float)p.x, (float)p.y, adj);
            } else {
                adj.setTo((float)p.x, (float)p.y);
            }
            String text = String.format(format, i);
            int x = (int)((double)adj.x * scale);
            int y = (int)((double)adj.y * scale);
            g2.setColor(Color.BLACK);
            g2.drawString(text, x - 1, y);
            g2.drawString(text, x + 1, y);
            g2.drawString(text, x, y - 1);
            g2.drawString(text, x, y + 1);
            g2.setTransform(origTran);
            g2.setColor(Color.GREEN);
            g2.drawString(text, x, y);
        }
    }

    public static void drawFeatureID(Graphics2D g2, int fontSize, List<PointIndex2D_F64> points, @Nullable Point2Transform2_F32 transform, double scale) {
        int numDigits = BoofMiscOps.numDigits((int)points.size());
        String format = "%" + numDigits + "d";
        Font regular = new Font("Serif", 0, fontSize);
        g2.setFont(regular);
        Point2D_F32 adj = new Point2D_F32();
        AffineTransform origTran = g2.getTransform();
        for (int i = 0; i < points.size(); ++i) {
            PointIndex2D_F64 p = points.get(i);
            if (transform != null) {
                transform.compute((float)((Point2D_F64)p.p).x, (float)((Point2D_F64)p.p).y, adj);
            } else {
                adj.setTo((float)((Point2D_F64)p.p).x, (float)((Point2D_F64)p.p).y);
            }
            String text = String.format(format, p.index);
            int x = (int)((double)adj.x * scale + 0.5);
            int y = (int)((double)adj.y * scale + 0.5);
            g2.setColor(Color.BLACK);
            g2.drawString(text, x - 1, y);
            g2.drawString(text, x + 1, y);
            g2.drawString(text, x, y - 1);
            g2.drawString(text, x, y + 1);
            g2.setTransform(origTran);
            g2.setColor(Color.GREEN);
            g2.drawString(text, x, y);
        }
    }

    public static void drawIndexes(Graphics2D g2, int fontSize, List<ChessboardCorner> points, @Nullable Point2Transform2_F32 transform, int minLevel, double scale) {
        int numDigits = BoofMiscOps.numDigits((int)points.size());
        String format = "%" + numDigits + "d";
        Font regular = new Font("Serif", 0, fontSize);
        g2.setFont(regular);
        Point2D_F32 adj = new Point2D_F32();
        AffineTransform origTran = g2.getTransform();
        for (int i = 0; i < points.size(); ++i) {
            ChessboardCorner p = points.get(i);
            if (p.level2 < minLevel) continue;
            if (transform != null) {
                transform.compute((float)p.x, (float)p.y, adj);
            } else {
                adj.setTo((float)p.x, (float)p.y);
            }
            String text = String.format(format, i);
            int x = (int)((double)adj.x * scale);
            int y = (int)((double)adj.y * scale);
            g2.setColor(Color.BLACK);
            g2.drawString(text, x - 1, y);
            g2.drawString(text, x + 1, y);
            g2.drawString(text, x, y - 1);
            g2.drawString(text, x, y + 1);
            g2.setTransform(origTran);
            g2.setColor(Color.GREEN);
            g2.drawString(text, x, y);
        }
    }
}

