/*
 * Decompiled with CFR 0.152.
 */
package boofcv.gui.mesh;

import boofcv.alg.geo.PerspectiveOps;
import boofcv.struct.calib.CameraPinhole;
import georegression.geometry.ConvertRotation3D_F64;
import georegression.geometry.GeometryMath_F64;
import georegression.metric.UtilAngle;
import georegression.struct.EulerType;
import georegression.struct.GeoTuple3D_F64;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point3D_F64;
import georegression.struct.point.Vector3D_F64;
import georegression.struct.se.Se3_F64;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;

public class OrbitAroundPoint {
    CameraPinhole camera = new CameraPinhole();
    Se3_F64 worldToView = new Se3_F64();
    DMatrixRMaj localRotation = new DMatrixRMaj(3, 3);
    DMatrixRMaj rotationAroundTarget = new DMatrixRMaj(3, 3);
    DMatrixRMaj tmp = new DMatrixRMaj(3, 3);
    Vector3D_F64 translateWorld = new Vector3D_F64();
    Point3D_F64 targetPoint = new Point3D_F64();
    double radiusScale = 1.0;
    Point3D_F64 cameraLoc = new Point3D_F64();
    Point2D_F64 norm1 = new Point2D_F64();
    Point2D_F64 norm2 = new Point2D_F64();

    public OrbitAroundPoint() {
        this.resetView();
    }

    public void resetView() {
        this.radiusScale = 1.0;
        this.translateWorld.zero();
        CommonOps_DDRM.setIdentity((DMatrix1Row)this.rotationAroundTarget);
    }

    public void updateTransform() {
        this.cameraLoc.x = -this.targetPoint.x * this.radiusScale;
        this.cameraLoc.y = -this.targetPoint.y * this.radiusScale;
        this.cameraLoc.z = -this.targetPoint.z * this.radiusScale;
        GeometryMath_F64.mult((DMatrixRMaj)this.rotationAroundTarget, (GeoTuple3D_F64)this.cameraLoc, (GeoTuple3D_F64)this.cameraLoc);
        this.worldToView.T.setTo(this.cameraLoc.x + this.targetPoint.x + this.translateWorld.x, this.cameraLoc.y + this.targetPoint.y + this.translateWorld.y, this.cameraLoc.z + this.targetPoint.z + this.translateWorld.z);
        this.worldToView.R.setTo((DMatrixD1)this.rotationAroundTarget);
    }

    public void mouseWheel(double ticks, double scale) {
        this.radiusScale = Math.max(0.005, this.radiusScale * (1.0 + 0.02 * ticks * scale));
    }

    public void mouseDragRotate(double x0, double y0, double x1, double y1) {
        if (this.camera.fx == 0.0 || this.camera.fy == 0.0) {
            return;
        }
        PerspectiveOps.convertPixelToNorm((CameraPinhole)this.camera, (double)x0, (double)y0, (Point2D_F64)this.norm1);
        PerspectiveOps.convertPixelToNorm((CameraPinhole)this.camera, (double)x1, (double)y1, (Point2D_F64)this.norm2);
        double rotX = UtilAngle.minus((double)Math.atan(this.norm1.x), (double)Math.atan(this.norm2.x));
        double rotY = UtilAngle.minus((double)Math.atan(this.norm1.y), (double)Math.atan(this.norm2.y));
        ConvertRotation3D_F64.eulerToMatrix((EulerType)EulerType.XYZ, (double)(-rotY), (double)rotX, (double)0.0, (DMatrixRMaj)this.localRotation);
        CommonOps_DDRM.mult((DMatrix1Row)this.localRotation, (DMatrix1Row)this.rotationAroundTarget, (DMatrix1Row)this.tmp);
        this.rotationAroundTarget.setTo((DMatrixD1)this.tmp);
    }

    public void mouseDragTranslate(double x0, double y0, double x1, double y1) {
        if (this.camera.fx == 0.0 || this.camera.fy == 0.0) {
            return;
        }
        PerspectiveOps.convertPixelToNorm((CameraPinhole)this.camera, (double)x0, (double)y0, (Point2D_F64)this.norm1);
        PerspectiveOps.convertPixelToNorm((CameraPinhole)this.camera, (double)x1, (double)y1, (Point2D_F64)this.norm2);
        double z = ((Point3D_F64)this.targetPoint.plus((GeoTuple3D_F64)this.translateWorld)).norm() * this.radiusScale;
        this.translateWorld.x += (this.norm2.x - this.norm1.x) * z;
        this.translateWorld.y += (this.norm2.y - this.norm1.y) * z;
    }

    public void mouseDragZoomRoll(double x0, double y0, double x1, double y1) {
        if (this.camera.fx == 0.0 || this.camera.fy == 0.0) {
            return;
        }
        PerspectiveOps.convertPixelToNorm((CameraPinhole)this.camera, (double)x0, (double)y0, (Point2D_F64)this.norm1);
        PerspectiveOps.convertPixelToNorm((CameraPinhole)this.camera, (double)x1, (double)y1, (Point2D_F64)this.norm2);
        double z = ((Point3D_F64)this.targetPoint.plus((GeoTuple3D_F64)this.translateWorld)).norm() * this.radiusScale;
        this.translateWorld.z += (this.norm2.y - this.norm1.y) * z;
        double rotX = UtilAngle.minus((double)Math.atan(this.norm1.x), (double)Math.atan(this.norm2.x));
        ConvertRotation3D_F64.eulerToMatrix((EulerType)EulerType.XYZ, (double)0.0, (double)0.0, (double)(-rotX), (DMatrixRMaj)this.localRotation);
        CommonOps_DDRM.mult((DMatrix1Row)this.localRotation, (DMatrix1Row)this.rotationAroundTarget, (DMatrix1Row)this.tmp);
        this.rotationAroundTarget.setTo((DMatrixD1)this.tmp);
    }

    public CameraPinhole getCamera() {
        return this.camera;
    }
}

