/*
 * Decompiled with CFR 0.152.
 */
package boofcv.gui.mesh;

import boofcv.gui.mesh.OrbitAroundPoint;
import boofcv.gui.mesh.Swing3dCameraControl;
import boofcv.struct.calib.CameraPinhole;
import boofcv.struct.mesh.VertexMesh;
import georegression.struct.point.Point3D_F64;
import georegression.struct.se.Se3_F64;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.ddogleg.struct.DogArray;
import org.ddogleg.struct.DogArray_F64;

public class OrbitAroundPointControl
extends MouseAdapter
implements Swing3dCameraControl {
    public int maxSamplePoints = 1000;
    public Runnable handleCameraChanged = () -> {};
    final OrbitAroundPoint orbit = new OrbitAroundPoint();
    int prevX;
    int prevY;

    @Override
    public void attachControls(JComponent parent) {
        parent.addMouseListener(this);
        parent.addMouseMotionListener(this);
        parent.addMouseWheelListener(this);
    }

    @Override
    public void detachControls(JComponent parent) {
        parent.removeMouseListener(this);
        parent.removeMouseMotionListener(this);
        parent.removeMouseWheelListener(this);
    }

    @Override
    public void reset() {
        this.orbit.resetView();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void selectInitialParameters(VertexMesh mesh) {
        int N = Math.min(this.maxSamplePoints, mesh.vertexes.size());
        if (N == 0) {
            this.orbit.targetPoint.setTo(0.0, 0.0, 1.0);
            return;
        }
        DogArray sampled = new DogArray(Point3D_F64::new);
        sampled.reserve(N);
        for (int i = 0; i < N; ++i) {
            int vertIndex = i * mesh.vertexes.size() / N;
            mesh.vertexes.getCopy(vertIndex, (Point3D_F64)sampled.grow());
        }
        DogArray_F64 values = new DogArray_F64();
        values.resize(sampled.size);
        OrbitAroundPoint orbitAroundPoint = this.orbit;
        synchronized (orbitAroundPoint) {
            for (int axis = 0; axis < 3; ++axis) {
                int _axis = axis;
                sampled.forIdx((idx, v) -> values.set(idx, v.getIdx(_axis)));
                values.sort();
                this.orbit.targetPoint.setIdx(axis, values.getFraction(0.5));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCamera(CameraPinhole intrinsics) {
        OrbitAroundPoint orbitAroundPoint = this.orbit;
        synchronized (orbitAroundPoint) {
            this.orbit.getCamera().setTo(intrinsics);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Se3_F64 getWorldToCamera() {
        OrbitAroundPoint orbitAroundPoint = this.orbit;
        synchronized (orbitAroundPoint) {
            this.orbit.updateTransform();
            return this.orbit.worldToView.copy();
        }
    }

    @Override
    public void setChangeHandler(Runnable handler) {
        this.handleCameraChanged = handler;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.prevX = e.getX();
        this.prevY = e.getY();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        OrbitAroundPoint orbitAroundPoint = this.orbit;
        synchronized (orbitAroundPoint) {
            this.orbit.mouseWheel(e.getPreciseWheelRotation(), 1.0);
        }
        this.handleCameraChanged.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mouseDragged(MouseEvent e) {
        OrbitAroundPoint orbitAroundPoint = this.orbit;
        synchronized (orbitAroundPoint) {
            if (e.isShiftDown() || SwingUtilities.isMiddleMouseButton(e)) {
                this.orbit.mouseDragTranslate(this.prevX, this.prevY, e.getX(), e.getY());
            } else if (e.isControlDown() || SwingUtilities.isRightMouseButton(e)) {
                this.orbit.mouseDragZoomRoll(this.prevX, this.prevY, e.getX(), e.getY());
            } else {
                this.orbit.mouseDragRotate(this.prevX, this.prevY, e.getX(), e.getY());
            }
        }
        this.prevX = e.getX();
        this.prevY = e.getY();
        this.handleCameraChanged.run();
    }

    @Override
    public String getHelpText() {
        return "Rotates around a single point\nMouse left to rotate around the point\nMouse middle (shift) to translate\nMouse right (ctrl) to zoom and roll\n";
    }
}

