/*
 * Decompiled with CFR 0.152.
 */
package boofcv.gui.feature;

import boofcv.abst.distort.FDistort;
import boofcv.core.image.GeneralizedImageOps;
import boofcv.gui.feature.VisualizeFeatures;
import boofcv.io.image.ConvertBufferedImage;
import boofcv.struct.feature.ScalePoint;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageGray;
import boofcv.struct.pyramid.PyramidFloat;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nullable;

public class ScaleSpacePyramidPointPanel
extends JPanel
implements MouseListener {
    private PyramidFloat ss;
    BufferedImage background;
    List<ScalePoint> points = new ArrayList<ScalePoint>();
    List<ScalePoint> unused = new ArrayList<ScalePoint>();
    @Nullable
    BufferedImage levelImage;
    List<ScalePoint> levelPoints = new ArrayList<ScalePoint>();
    int activeLevel = 0;
    double scaleToRadius;

    public ScaleSpacePyramidPointPanel(double scaleToRadius) {
        this.scaleToRadius = scaleToRadius;
        this.addMouseListener(this);
    }

    public void setSs(PyramidFloat ss) {
        this.ss = ss;
    }

    public void setBackground(BufferedImage background) {
        this.background = background;
        this.setPreferredSize(new Dimension(background.getWidth(), background.getHeight()));
    }

    public synchronized void setPoints(List<ScalePoint> points) {
        this.unused.addAll(this.points);
        this.points.clear();
        for (ScalePoint p : points) {
            if (this.unused.isEmpty()) {
                this.points.add(p.copy());
            } else {
                ScalePoint c = this.unused.remove(this.unused.size() - 1);
                c.setTo(p);
            }
            this.points.add(p);
        }
        this.setLevel(0);
    }

    private synchronized void setLevel(int level) {
        if (level > 0 && this.ss != null) {
            ImageGray small = (ImageGray)this.ss.getLayer(level - 1);
            ImageGray enlarge = GeneralizedImageOps.createSingleBand(small.getClass(), (int)this.ss.getInputWidth(), (int)this.ss.getInputHeight());
            new FDistort((ImageBase)small, (ImageBase)enlarge).interpNN().apply();
            if (this.levelImage != null && (this.levelImage.getWidth() != enlarge.width || this.levelImage.getHeight() != enlarge.height)) {
                this.levelImage = null;
            }
            this.levelImage = ConvertBufferedImage.convertTo((ImageBase)enlarge, (BufferedImage)this.levelImage, (boolean)true);
            double scale = this.ss.getScale(level - 1);
            this.levelPoints.clear();
            for (ScalePoint p : this.points) {
                if (p.scale != scale) continue;
                this.levelPoints.add(p);
            }
        } else {
            this.levelPoints.clear();
            this.levelPoints.addAll(this.points);
        }
        this.activeLevel = level;
    }

    @Override
    public synchronized void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        double scaleX = (double)this.ss.getInputWidth() / (double)this.getWidth();
        double scaleY = (double)this.ss.getInputHeight() / (double)this.getHeight();
        double scale = Math.max(scaleX, scaleY);
        if (scale > 1.0) {
            AffineTransform tran = g2.getTransform();
            tran.concatenate(AffineTransform.getScaleInstance(1.0 / scale, 1.0 / scale));
            g2.setTransform(tran);
        }
        if (this.activeLevel == 0) {
            this.showAll(g);
        } else {
            Objects.requireNonNull(this.levelImage);
            g.drawImage(this.levelImage, 0, 0, this.levelImage.getWidth(), this.levelImage.getHeight(), null);
            VisualizeFeatures.drawScalePoints((Graphics2D)g, this.levelPoints, this.scaleToRadius);
        }
    }

    private void showAll(Graphics g) {
        if (this.background != null) {
            g.drawImage(this.background, 0, 0, this.background.getWidth(), this.background.getHeight(), null);
        }
        VisualizeFeatures.drawScalePoints((Graphics2D)g, this.levelPoints, this.scaleToRadius);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        int level = this.activeLevel + 1;
        if (level > this.ss.getNumLayers()) {
            level = 0;
        }
        this.setLevel(level);
        this.repaint();
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }
}

