/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.calib;

import boofcv.abst.calib.CalibrateMonoPlanar;
import boofcv.abst.calib.PlanarCalibrationDetector;
import boofcv.alg.geo.calibration.PlanarCalibrationTarget;
import boofcv.alg.geo.calibration.Zhang99Parameters;
import boofcv.struct.calib.IntrinsicParameters;
import boofcv.struct.calib.StereoParameters;
import boofcv.struct.image.ImageFloat32;
import georegression.fitting.se.FitSpecialEuclideanOps_F64;
import georegression.geometry.RotationMatrixGenerator;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point3D_F64;
import georegression.struct.se.Se3_F64;
import georegression.struct.so.Rodrigues_F64;
import georegression.transform.se.SePointOps_F64;
import java.util.ArrayList;
import java.util.List;
import org.ejml.data.DenseMatrix64F;

public class CalibrateStereoPlanar {
    List<Se3_F64> viewLeft = new ArrayList<Se3_F64>();
    List<Se3_F64> viewRight = new ArrayList<Se3_F64>();
    CalibrateMonoPlanar calibLeft;
    CalibrateMonoPlanar calibRight;

    public CalibrateStereoPlanar(PlanarCalibrationDetector detector, boolean flipY) {
        this.calibLeft = new CalibrateMonoPlanar(detector, flipY);
        this.calibRight = new CalibrateMonoPlanar(detector, flipY);
    }

    public void reset() {
        this.viewLeft.clear();
        this.viewRight.clear();
        this.calibLeft.reset();
        this.calibRight.reset();
    }

    public void configure(PlanarCalibrationTarget target, boolean assumeZeroSkew, int numRadialParam) {
        this.calibLeft.configure(target, assumeZeroSkew, numRadialParam);
        this.calibRight.configure(target, assumeZeroSkew, numRadialParam);
    }

    public boolean addPair(ImageFloat32 left, ImageFloat32 right) {
        if (!this.calibLeft.addImage(left)) {
            return false;
        }
        if (!this.calibRight.addImage(right)) {
            this.calibLeft.removeLatestImage();
            return false;
        }
        return true;
    }

    public StereoParameters process() {
        IntrinsicParameters leftParam = this.calibrateMono(this.calibLeft, this.viewLeft);
        IntrinsicParameters rightParam = this.calibrateMono(this.calibRight, this.viewRight);
        Se3_F64 rightToLeft = this.computeRightToLeft();
        return new StereoParameters(leftParam, rightParam, rightToLeft);
    }

    private IntrinsicParameters calibrateMono(CalibrateMonoPlanar calib, List<Se3_F64> location) {
        IntrinsicParameters intrinsic = calib.process();
        Zhang99Parameters zhangParam = calib.getZhangParam();
        for (Zhang99Parameters.View v : zhangParam.views) {
            Se3_F64 pose = new Se3_F64();
            RotationMatrixGenerator.rodriguesToMatrix((Rodrigues_F64)v.rotation, (DenseMatrix64F)pose.getR());
            pose.getT().set(v.T);
            location.add(pose);
        }
        return intrinsic;
    }

    private Se3_F64 computeRightToLeft() {
        List<Point2D_F64> points2D = this.calibLeft.getTarget().points;
        ArrayList<Point3D_F64> points3D = new ArrayList<Point3D_F64>();
        for (Point2D_F64 p : points2D) {
            points3D.add(new Point3D_F64(p.x, p.y, 0.0));
        }
        ArrayList<Point3D_F64> left = new ArrayList<Point3D_F64>();
        ArrayList<Point3D_F64> right = new ArrayList<Point3D_F64>();
        for (int i = 0; i < this.viewLeft.size(); ++i) {
            Se3_F64 worldToLeft = this.viewLeft.get(i);
            Se3_F64 worldToRight = this.viewRight.get(i);
            for (Point3D_F64 p : points3D) {
                Point3D_F64 l = SePointOps_F64.transform((Se3_F64)worldToLeft, (Point3D_F64)p, null);
                Point3D_F64 r = SePointOps_F64.transform((Se3_F64)worldToRight, (Point3D_F64)p, null);
                left.add(l);
                right.add(r);
            }
        }
        return FitSpecialEuclideanOps_F64.fitPoints3D(right, left);
    }

    public CalibrateMonoPlanar getCalibLeft() {
        return this.calibLeft;
    }

    public CalibrateMonoPlanar getCalibRight() {
        return this.calibRight;
    }

    public boolean isConvertToRightHanded() {
        return this.calibLeft.isFlipY();
    }

    public void printStatistics() {
        System.out.println("********** LEFT ************");
        this.calibLeft.printStatistics();
        System.out.println("********** RIGHT ************");
        this.calibRight.printStatistics();
    }
}

