/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.calib;

import boofcv.abst.calib.ConfigSquareGrid;
import boofcv.abst.calib.PlanarCalibrationDetector;
import boofcv.alg.feature.detect.InvalidCalibrationTarget;
import boofcv.alg.feature.detect.grid.DetectSquareCalibrationPoints;
import boofcv.alg.feature.detect.grid.RefineCalibrationGridCorner;
import boofcv.alg.feature.detect.grid.UtilCalibrationGrid;
import boofcv.alg.feature.detect.grid.refine.WrapRefineCornerSegmentFit;
import boofcv.alg.feature.detect.quadblob.QuadBlob;
import boofcv.alg.filter.binary.GThresholdImageOps;
import boofcv.struct.image.ImageFloat32;
import boofcv.struct.image.ImageSingleBand;
import boofcv.struct.image.ImageUInt8;
import georegression.struct.point.Point2D_F64;
import java.util.ArrayList;
import java.util.List;

public class WrapPlanarSquareGridTarget
implements PlanarCalibrationDetector {
    int squareColumns;
    int pointColumns;
    int pointRows;
    RefineCalibrationGridCorner refine;
    DetectSquareCalibrationPoints detect;
    private ImageUInt8 binary = new ImageUInt8(1, 1);
    List<Point2D_F64> ret;
    ImageFloat32 work1 = new ImageFloat32(1, 1);
    ImageFloat32 work2 = new ImageFloat32(1, 1);
    ConfigSquareGrid config;

    public WrapPlanarSquareGridTarget(ConfigSquareGrid config) {
        this.config = config;
        this.refine = new WrapRefineCornerSegmentFit();
        this.squareColumns = config.numCols;
        this.pointColumns = (this.squareColumns / 2 + 1) * 2;
        this.pointRows = (config.numRows / 2 + 1) * 2;
        this.detect = new DetectSquareCalibrationPoints(config.relativeSizeThreshold, config.spaceToSquareRatio, this.squareColumns, config.numRows);
    }

    @Override
    public boolean process(ImageFloat32 input) {
        this.work1.reshape(input.width, input.height);
        this.work2.reshape(input.width, input.height);
        this.binary.reshape(input.width, input.height);
        if (this.config.binaryGlobalThreshold <= 0.0) {
            this.work1.reshape(input.width, input.height);
            this.work2.reshape(input.width, input.height);
            GThresholdImageOps.adaptiveSquare((ImageSingleBand)input, (ImageUInt8)this.binary, (int)this.config.binaryAdaptiveRadius, (double)this.config.binaryAdaptiveBias, (boolean)true, (ImageSingleBand)this.work1, (ImageSingleBand)this.work2);
        } else {
            GThresholdImageOps.threshold((ImageSingleBand)input, (ImageUInt8)this.binary, (double)this.config.binaryGlobalThreshold, (boolean)true);
        }
        if (!this.detect.process(this.binary)) {
            return false;
        }
        try {
            List<QuadBlob> squares = this.detect.getInterestSquares();
            this.refine.refine(squares, input);
            ArrayList<Point2D_F64> subpixel = new ArrayList<Point2D_F64>();
            for (QuadBlob b : squares) {
                for (Point2D_F64 p : b.subpixel) {
                    subpixel.add(p);
                }
            }
            this.ret = UtilCalibrationGrid.rotatePoints(subpixel, this.pointRows, this.pointColumns, this.pointRows, this.pointColumns);
        }
        catch (InvalidCalibrationTarget e) {
            return false;
        }
        return this.ret != null;
    }

    @Override
    public List<Point2D_F64> getPoints() {
        return this.ret;
    }

    public ImageUInt8 getBinary() {
        return this.binary;
    }

    public RefineCalibrationGridCorner getRefine() {
        return this.refine;
    }

    public DetectSquareCalibrationPoints getDetect() {
        return this.detect;
    }
}

